/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jface.dialogs;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.jface.dialogs.DatasetRunPameterDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.dataset.IEditableDatasetRun;
import com.jaspersoft.studio.model.dataset.descriptor.DatasetRunRVPropertyPage;
import com.jaspersoft.studio.property.dataset.DatasetRunSelectionListener;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.ModelUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetParameter;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class DatasetRunBaseComposite
extends Composite
implements IExpressionContextSetter {
    private IEditableDatasetRun datasetRunInstance;
    private Combo comboSubDataset;
    private CTabFolder tabFolderDataSetRun;
    private Combo comboConnDS;
    private WTextExpression connDSExpression;
    private WTextExpression paramsMapExpression;
    private DatasetRunRVPropertyPage returnValueEditor;
    private TableViewer tableViewerDatasetRunParams;
    private List<DatasetRunSelectionListener> dsRunSelectionListeners;
    private ExpressionContext expContext;
    private HashMap<String, JRDesignDatasetRun> datasetRunMap = new HashMap();

    public DatasetRunBaseComposite(IEditableDatasetRun datasetRun, Composite parent, int style) {
        super(parent, style);
        this.dsRunSelectionListeners = new ArrayList<DatasetRunSelectionListener>();
        this.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, true, 2, 2);
        gd.heightHint = 300;
        gd.horizontalSpan = 2;
        this.setLayoutData(gd);
        this.datasetRunInstance = datasetRun;
        Label lblSubDataset = new Label((Composite)this, 0);
        lblSubDataset.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblSubDataset.setText(Messages.DatasetRunBaseComposite_SubDatasetLbl);
        this.comboSubDataset = new Combo((Composite)this, 8);
        GridData gd_combo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo.horizontalIndent = 15;
        this.comboSubDataset.setLayoutData((Object)gd_combo);
        this.comboSubDataset.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = ((Combo)e.widget).getSelectionIndex();
                DatasetRunBaseComposite.this.updateSubDatasetInformation(selIndex);
                DatasetRunBaseComposite.this.comboConnDS.select(0);
                DatasetRunBaseComposite.this.connDSExpression.setEnabled(false);
                DatasetRunBaseComposite.this.connDSExpression.setVisible(false);
                DatasetRunBaseComposite.this.connDSExpression.setExpression(null);
                DatasetRunBaseComposite.this.notifyDatasetRunSelectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tabFolderDataSetRun = new CTabFolder((Composite)this, 0);
        GridData gd_tabFolderDataSetRun = new GridData(4, 4, true, true, 2, 2);
        this.tabFolderDataSetRun.setLayoutData((Object)gd_tabFolderDataSetRun);
        this.tabFolderDataSetRun.setEnabled(false);
        this.tabFolderDataSetRun.setVisible(false);
        CTabItem tbtmConnectionDatasourceExpression = new CTabItem(this.tabFolderDataSetRun, 0);
        tbtmConnectionDatasourceExpression.setText(Messages.DatasetRunBaseComposite_ConnDSExprTab);
        Composite compositeConnDSExpContent = new Composite((Composite)this.tabFolderDataSetRun, 0);
        tbtmConnectionDatasourceExpression.setControl((Control)compositeConnDSExpContent);
        compositeConnDSExpContent.setLayout((Layout)new GridLayout(1, false));
        Label lblConnDSExprSelection = new Label(compositeConnDSExpContent, 0);
        lblConnDSExprSelection.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        lblConnDSExprSelection.setText(Messages.DatasetRunBaseComposite_ConnDSExprLbl);
        this.comboConnDS = new Combo(compositeConnDSExpContent, 8);
        this.comboConnDS.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.comboConnDS.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int connectionType = ((Combo)e.widget).getSelectionIndex();
                switch (connectionType) {
                    case 0: {
                        DatasetRunBaseComposite.this.connDSExpression.setEnabled(false);
                        DatasetRunBaseComposite.this.connDSExpression.setVisible(false);
                        DatasetRunBaseComposite.this.connDSExpression.setExpression(null);
                        break;
                    }
                    case 1: {
                        DatasetRunBaseComposite.this.connDSExpression.setEnabled(true);
                        DatasetRunBaseComposite.this.connDSExpression.setVisible(true);
                        DatasetRunBaseComposite.this.connDSExpression.setExpression(new JRDesignExpression("$P{REPORT_CONNECTION}"));
                        break;
                    }
                    case 2: {
                        DatasetRunBaseComposite.this.connDSExpression.setEnabled(true);
                        DatasetRunBaseComposite.this.connDSExpression.setVisible(true);
                        DatasetRunBaseComposite.this.connDSExpression.setExpression(new JRDesignExpression("new net.sf.jasperreports.engine.JREmptyDataSource(1)"));
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.connDSExpression = new WTextExpression(compositeConnDSExpContent, 0, Messages.DatasetRunBaseComposite_ConnDSExprWidgetLbl, 1){

            @Override
            public void setExpression(JRDesignExpression exp) {
                super.setExpression(exp);
                int connectionType = DatasetRunBaseComposite.this.comboConnDS.getSelectionIndex();
                switch (connectionType) {
                    case 0: {
                        DatasetRunBaseComposite.this.datasetRunInstance.setConnectionExpression(null);
                        DatasetRunBaseComposite.this.datasetRunInstance.setDataSourceExpression(null);
                        break;
                    }
                    case 1: {
                        DatasetRunBaseComposite.this.datasetRunInstance.setDataSourceExpression(null);
                        DatasetRunBaseComposite.this.datasetRunInstance.setConnectionExpression((JRExpression)exp);
                        break;
                    }
                    case 2: {
                        DatasetRunBaseComposite.this.datasetRunInstance.setConnectionExpression(null);
                        DatasetRunBaseComposite.this.datasetRunInstance.setDataSourceExpression((JRExpression)exp);
                    }
                }
            }
        };
        this.connDSExpression.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        CTabItem tbtmParameters = new CTabItem(this.tabFolderDataSetRun, 0);
        tbtmParameters.setText(Messages.DatasetRunBaseComposite_ParametersTab);
        Composite compositeParametersContent = new Composite((Composite)this.tabFolderDataSetRun, 0);
        tbtmParameters.setControl((Control)compositeParametersContent);
        compositeParametersContent.setLayout((Layout)new GridLayout(2, false));
        Composite compositeTableViewerDSRunParams = new Composite(compositeParametersContent, 0);
        compositeTableViewerDSRunParams.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        TableColumnLayout layoutForTableViewerDSRunParams = new TableColumnLayout();
        compositeTableViewerDSRunParams.setLayout((Layout)layoutForTableViewerDSRunParams);
        this.tableViewerDatasetRunParams = new TableViewer(compositeTableViewerDSRunParams, 67584);
        Table tableDatasetRunParameters = this.tableViewerDatasetRunParams.getTable();
        tableDatasetRunParameters.setHeaderVisible(true);
        tableDatasetRunParameters.setLinesVisible(true);
        TableViewerColumn tblclmnDatasetRunParam = new TableViewerColumn(this.tableViewerDatasetRunParams, 0);
        tblclmnDatasetRunParam.getColumn().setWidth(156);
        tblclmnDatasetRunParam.getColumn().setText(Messages.DatasetRunBaseComposite_ParametersCol1);
        tblclmnDatasetRunParam.setLabelProvider((CellLabelProvider)new DSParameterNameLabelProvider());
        layoutForTableViewerDSRunParams.setColumnData((Widget)tblclmnDatasetRunParam.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        TableViewerColumn tblclmnDatasetRunParamExp = new TableViewerColumn(this.tableViewerDatasetRunParams, 0);
        tblclmnDatasetRunParamExp.getColumn().setWidth(187);
        tblclmnDatasetRunParamExp.getColumn().setText(Messages.DatasetRunBaseComposite_ParametersCol2);
        tblclmnDatasetRunParamExp.setLabelProvider((CellLabelProvider)new DSParameterExpressionLabelProvider());
        layoutForTableViewerDSRunParams.setColumnData((Widget)tblclmnDatasetRunParamExp.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this.tableViewerDatasetRunParams.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewerDatasetRunParams.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selElement != null) {
                    JRDesignDataset designDS = (JRDesignDataset)DatasetRunBaseComposite.this.datasetRunInstance.getEditableDataset().getJasperDesign().getDatasetMap().get(DatasetRunBaseComposite.this.datasetRunInstance.getJRDatasetRun().getDatasetName());
                    JRDesignDatasetParameter originalParameter = (JRDesignDatasetParameter)selElement;
                    DatasetRunPameterDialog dialog = new DatasetRunPameterDialog((JRDesignDatasetParameter)originalParameter.clone(), designDS, DatasetRunBaseComposite.this.getShell());
                    dialog.setExpressionContext(DatasetRunBaseComposite.this.expContext);
                    if (dialog.open() == 0) {
                        JRDesignDatasetParameter modifiedParameter = dialog.getModifiedDatasetParameter();
                        DatasetRunBaseComposite.this.datasetRunInstance.removeParameter((JRDatasetParameter)originalParameter);
                        DatasetRunBaseComposite.this.datasetRunInstance.addParameter((JRDatasetParameter)modifiedParameter);
                        DatasetRunBaseComposite.this.tableViewerDatasetRunParams.setInput((Object)DatasetRunBaseComposite.this.datasetRunInstance.getJRDatasetRun().getParameters());
                    }
                }
            }
        });
        Button btnAddParamDatasetRun = new Button(compositeParametersContent, 0);
        btnAddParamDatasetRun.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        btnAddParamDatasetRun.setText(Messages.DatasetRunBaseComposite_AddParamBtn);
        btnAddParamDatasetRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRDesignDataset designDS = (JRDesignDataset)DatasetRunBaseComposite.this.datasetRunInstance.getEditableDataset().getJasperDesign().getDatasetMap().get(DatasetRunBaseComposite.this.datasetRunInstance.getJRDatasetRun().getDatasetName());
                DatasetRunPameterDialog dialog = new DatasetRunPameterDialog(null, designDS, DatasetRunBaseComposite.this.getShell());
                dialog.setExpressionContext(DatasetRunBaseComposite.this.expContext);
                if (dialog.open() == 0) {
                    JRDesignDatasetParameter newParameter = dialog.getModifiedDatasetParameter();
                    DatasetRunBaseComposite.this.datasetRunInstance.addParameter((JRDatasetParameter)newParameter);
                    DatasetRunBaseComposite.this.tableViewerDatasetRunParams.setInput((Object)DatasetRunBaseComposite.this.datasetRunInstance.getJRDatasetRun().getParameters());
                }
            }
        });
        Button btnModifyParameterDatasetRun = new Button(compositeParametersContent, 0);
        btnModifyParameterDatasetRun.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        btnModifyParameterDatasetRun.setText(Messages.DatasetRunBaseComposite_ModifyParamBtn);
        btnModifyParameterDatasetRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selElement = ((IStructuredSelection)DatasetRunBaseComposite.this.tableViewerDatasetRunParams.getSelection()).getFirstElement();
                if (selElement != null) {
                    JRDesignDataset designDS = (JRDesignDataset)DatasetRunBaseComposite.this.datasetRunInstance.getEditableDataset().getJasperDesign().getDatasetMap().get(DatasetRunBaseComposite.this.datasetRunInstance.getJRDatasetRun().getDatasetName());
                    JRDesignDatasetParameter originalParameter = (JRDesignDatasetParameter)selElement;
                    DatasetRunPameterDialog dialog = new DatasetRunPameterDialog((JRDesignDatasetParameter)originalParameter.clone(), designDS, DatasetRunBaseComposite.this.getShell());
                    dialog.setExpressionContext(DatasetRunBaseComposite.this.expContext);
                    if (dialog.open() == 0) {
                        JRDesignDatasetParameter modifiedParameter = dialog.getModifiedDatasetParameter();
                        DatasetRunBaseComposite.this.datasetRunInstance.removeParameter((JRDatasetParameter)originalParameter);
                        DatasetRunBaseComposite.this.datasetRunInstance.addParameter((JRDatasetParameter)modifiedParameter);
                        DatasetRunBaseComposite.this.tableViewerDatasetRunParams.setInput((Object)DatasetRunBaseComposite.this.datasetRunInstance.getJRDatasetRun().getParameters());
                    }
                }
            }
        });
        Button btnRemoveParameterDatasetRun = new Button(compositeParametersContent, 0);
        btnRemoveParameterDatasetRun.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        btnRemoveParameterDatasetRun.setText(Messages.DatasetRunBaseComposite_RemoveParamBtn);
        btnRemoveParameterDatasetRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selElement = ((IStructuredSelection)DatasetRunBaseComposite.this.tableViewerDatasetRunParams.getSelection()).getFirstElement();
                if (selElement != null) {
                    DatasetRunBaseComposite.this.datasetRunInstance.removeParameter((JRDatasetParameter)((JRDesignDatasetParameter)selElement));
                    DatasetRunBaseComposite.this.tableViewerDatasetRunParams.setInput((Object)DatasetRunBaseComposite.this.datasetRunInstance.getJRDatasetRun().getParameters());
                }
            }
        });
        CTabItem tbtmParametersMapExp = new CTabItem(this.tabFolderDataSetRun, 0);
        tbtmParametersMapExp.setText(Messages.DatasetRunBaseComposite_ParametersMapExprTab);
        Composite compositeParamsExpMapBox = new Composite((Composite)this.tabFolderDataSetRun, 0);
        tbtmParametersMapExp.setControl((Control)compositeParamsExpMapBox);
        GridLayout gl_compositeParamsExpMapBox = new GridLayout(3, false);
        compositeParamsExpMapBox.setLayout((Layout)gl_compositeParamsExpMapBox);
        this.paramsMapExpression = new WTextExpression(compositeParamsExpMapBox, 0, Messages.DatasetRunBaseComposite_ParametersMapExprWidgetLbl, 2){

            @Override
            public void setExpression(JRDesignExpression exp) {
                super.setExpression(exp);
                DatasetRunBaseComposite.this.datasetRunInstance.setParametersMapExpression((JRExpression)exp);
            }
        };
        this.paramsMapExpression.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        this.createDatasetRunReturnTab();
        this.tabFolderDataSetRun.setSelection(0);
        this.initWidgets();
    }

    private void createDatasetRunReturnTab() {
        CTabItem tbtmParametersMapExp = new CTabItem(this.tabFolderDataSetRun, 0);
        tbtmParametersMapExp.setText(Messages.common_return_values);
        Composite container = new Composite((Composite)this.tabFolderDataSetRun, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.returnValueEditor = new DatasetRunRVPropertyPage(null);
        this.returnValueEditor.setValue(null);
        this.returnValueEditor.createControl(container);
        this.returnValueEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatasetRunBaseComposite.this.returnValueEditor.saveValuesIntoDataset();
            }
        });
        tbtmParametersMapExp.setControl((Control)container);
    }

    private void initWidgets() {
        this.fillSubDatasetComboBox();
        if (this.datasetRunInstance.getJRDatasetRun() == null) {
            this.comboSubDataset.select(0);
            this.tabFolderDataSetRun.setEnabled(false);
            this.tabFolderDataSetRun.setVisible(false);
        } else {
            String datasetName = this.datasetRunInstance.getJRDatasetRun().getDatasetName();
            this.datasetRunMap.put(datasetName, (JRDesignDatasetRun)this.datasetRunInstance.getJRDatasetRun());
            int i = 0;
            while (i < this.comboSubDataset.getItemCount()) {
                if (this.comboSubDataset.getItem(i).equals(datasetName)) {
                    this.comboSubDataset.select(i);
                    break;
                }
                ++i;
            }
            if (this.comboSubDataset.getSelectionIndex() >= 1) {
                this.tabFolderDataSetRun.setEnabled(true);
                this.tabFolderDataSetRun.setVisible(true);
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.DatasetRunBaseComposite_SubDatasetErrorTitle, (String)MessageFormat.format(Messages.DatasetRunBaseComposite_SubDatasetErrorMsg, datasetName));
                this.tabFolderDataSetRun.setEnabled(false);
                this.tabFolderDataSetRun.setVisible(false);
                this.comboSubDataset.select(0);
            }
        }
        this.comboConnDS.setItems(new String[]{"Don't use connection or datasource", "Use a Connection expression", "Use a DataSource expression"});
        JRDesignExpression exp1 = null;
        if (this.datasetRunInstance.getJRDatasetRun() == null) {
            this.comboConnDS.select(0);
            this.connDSExpression.setEnabled(false);
            this.connDSExpression.setVisible(false);
        } else if (this.datasetRunInstance.getJRDatasetRun().getConnectionExpression() != null) {
            this.comboConnDS.select(1);
            this.connDSExpression.setEnabled(true);
            this.connDSExpression.setVisible(true);
            exp1 = (JRDesignExpression)this.datasetRunInstance.getJRDatasetRun().getConnectionExpression();
        } else if (this.datasetRunInstance.getJRDatasetRun().getDataSourceExpression() != null) {
            this.comboConnDS.select(2);
            this.connDSExpression.setEnabled(true);
            this.connDSExpression.setVisible(true);
            exp1 = (JRDesignExpression)this.datasetRunInstance.getJRDatasetRun().getDataSourceExpression();
        } else {
            this.comboConnDS.select(0);
            this.connDSExpression.setEnabled(false);
            this.connDSExpression.setVisible(false);
        }
        this.connDSExpression.setExpression(exp1);
        if (this.datasetRunInstance.getJRDatasetRun() != null) {
            this.tableViewerDatasetRunParams.setInput((Object)this.datasetRunInstance.getJRDatasetRun().getParameters());
        }
        JRDesignExpression exp2 = null;
        if (this.datasetRunInstance.getJRDatasetRun() != null) {
            exp2 = (JRDesignExpression)this.datasetRunInstance.getJRDatasetRun().getParametersMapExpression();
        }
        this.paramsMapExpression.setExpression(exp2);
        this.returnValueEditor.setDatasetRun((JRDesignDatasetRun)this.datasetRunInstance.getJRDatasetRun(), this.datasetRunInstance.getEditableDataset().getJasperDesign());
    }

    private void fillSubDatasetComboBox() {
        List datasetsList = this.datasetRunInstance.getEditableDataset().getJasperDesign().getDatasetsList();
        this.comboSubDataset.removeAll();
        ArrayList<String> datasetNames = new ArrayList<String>();
        datasetNames.add("[Report main dataset]");
        if (datasetsList != null && !datasetsList.isEmpty()) {
            int i = 0;
            while (i < datasetsList.size()) {
                JRDataset currDS = (JRDataset)datasetsList.get(i);
                datasetNames.add(currDS.getName());
                ++i;
            }
        }
        this.comboSubDataset.setItems(datasetNames.toArray(new String[0]));
    }

    private void updateSubDatasetInformation(int selIndex) {
        if (selIndex == 0) {
            this.datasetRunInstance.resetDatasetRun(true);
            this.tabFolderDataSetRun.setEnabled(false);
            this.tabFolderDataSetRun.setVisible(false);
        } else {
            String selectDatasetName = this.comboSubDataset.getItem(selIndex);
            if (this.datasetRunMap.containsKey(selectDatasetName)) {
                this.datasetRunInstance.setDatasetRun(this.datasetRunMap.get(selectDatasetName));
            } else {
                JRDesignDatasetRun newDataset = new JRDesignDatasetRun();
                newDataset.setDatasetName(selectDatasetName);
                this.datasetRunMap.put(selectDatasetName, newDataset);
                this.datasetRunInstance.setDatasetRun(newDataset);
            }
            this.tabFolderDataSetRun.setEnabled(true);
            this.tabFolderDataSetRun.setVisible(true);
        }
    }

    public void addDatasetRunSelectionListener(DatasetRunSelectionListener listener) {
        this.dsRunSelectionListeners.add(listener);
    }

    public void removeDatasetRunSelectionListener(DatasetRunSelectionListener listener) {
        this.dsRunSelectionListeners.remove(listener);
    }

    private void notifyDatasetRunSelectionChanged() {
        for (DatasetRunSelectionListener l : this.dsRunSelectionListeners) {
            l.selectionChanged();
        }
        this.fixDSParametersList();
        this.returnValueEditor.setDatasetRun((JRDesignDatasetRun)this.datasetRunInstance.getJRDatasetRun(), this.datasetRunInstance.getEditableDataset().getJasperDesign());
        if (this.tabFolderDataSetRun.isVisible()) {
            this.tabFolderDataSetRun.setSelection(0);
        }
    }

    private void fixDSParametersList() {
        JRDatasetParameter[] currParams = (JRDatasetParameter[])this.tableViewerDatasetRunParams.getInput();
        String datasetName = "";
        JRDatasetRun jrDatasetRun = this.datasetRunInstance.getJRDatasetRun();
        if (jrDatasetRun != null) {
            datasetName = jrDatasetRun.getDatasetName();
            List<JRParameter> parameters4Datasource = ModelUtils.getParameters4Datasource(this.datasetRunInstance.getEditableDataset().getJasperDesign(), datasetName);
            if (currParams != null) {
                JRDatasetParameter[] jRDatasetParameterArray = currParams;
                int n = currParams.length;
                int n2 = 0;
                while (n2 < n) {
                    JRDatasetParameter p1 = jRDatasetParameterArray[n2];
                    for (JRParameter p2 : parameters4Datasource) {
                        if (!p2.getName().equals(p1.getName())) continue;
                        this.datasetRunInstance.addParameter((JRDatasetParameter)p1.clone());
                        break;
                    }
                    ++n2;
                }
            }
            this.tableViewerDatasetRunParams.setInput((Object)this.datasetRunInstance.getJRDatasetRun().getParameters());
        } else {
            this.tableViewerDatasetRunParams.getTable().clearAll();
        }
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
        this.connDSExpression.setExpressionContext(expContext);
        this.paramsMapExpression.setExpressionContext(expContext);
    }

    private class DSParameterExpressionLabelProvider
    extends ColumnLabelProvider {
        private DSParameterExpressionLabelProvider() {
        }

        public String getText(Object element) {
            JRExpression expression;
            if (element != null && (expression = ((JRDatasetParameter)element).getExpression()) != null) {
                return expression.getText();
            }
            return null;
        }
    }

    private class DSParameterNameLabelProvider
    extends ColumnLabelProvider {
        private DSParameterNameLabelProvider() {
        }

        public String getText(Object element) {
            if (element != null) {
                return ((JRDatasetParameter)element).getName();
            }
            return null;
        }
    }
}

