/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jface.dialogs;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.jface.dialogs.DatasetRunBaseComposite;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.dataset.IEditableDataset;
import com.jaspersoft.studio.model.dataset.IEditableDatasetRun;
import com.jaspersoft.studio.property.dataset.DatasetRunSelectionListener;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.EnumHelper;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.DatasetResetTypeEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class EditableDatasetBaseComposite
extends Composite
implements IExpressionContextSetter {
    private IEditableDataset datasetInstance;
    private Combo comboResetType;
    private Combo comboResetGroup;
    private Combo comboIncrementType;
    private Combo comboIncrementGroup;
    private WTextExpression filterExpression;
    private List<DatasetRunSelectionListener> dsRunSelectionListeners = new ArrayList<DatasetRunSelectionListener>();
    private DatasetRunBaseComposite datasetRunContent;

    public void setDatasetInstance(IEditableDataset datasetInstance) {
        this.datasetInstance = datasetInstance;
    }

    public EditableDatasetBaseComposite(IEditableDataset datasetInst, Composite parent, int style) {
        super(parent, 0);
        this.datasetInstance = datasetInst;
        this.setLayout((Layout)new GridLayout(2, true));
        Label lblResetType = new Label((Composite)this, 0);
        lblResetType.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        lblResetType.setText(Messages.EditableDatasetBaseComposite_ResetTypeLbl);
        Label lblResetGroup = new Label((Composite)this, 0);
        lblResetGroup.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        lblResetGroup.setBounds(0, 0, 59, 14);
        lblResetGroup.setText(Messages.EditableDatasetBaseComposite_ResetGroupLbl);
        this.comboResetType = new Combo((Composite)this, 8);
        this.comboResetType.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.comboResetType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = ((Combo)e.widget).getSelectionIndex();
                EditableDatasetBaseComposite.this.updateResetTypeInformation(selIndex);
            }
        });
        this.comboResetGroup = new Combo((Composite)this, 8);
        this.comboResetGroup.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.comboResetGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = ((Combo)e.widget).getSelectionIndex();
                EditableDatasetBaseComposite.this.updateResetGroupInformation(selIndex);
            }
        });
        Label lblIncrementType = new Label((Composite)this, 0);
        lblIncrementType.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        lblIncrementType.setText(Messages.EditableDatasetBaseComposite_IncrementTypeLbl);
        Label lblIncrementGroup = new Label((Composite)this, 0);
        lblIncrementGroup.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        lblIncrementGroup.setText(Messages.EditableDatasetBaseComposite_IncrementGroupLbl);
        this.comboIncrementType = new Combo((Composite)this, 8);
        this.comboIncrementType.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.comboIncrementType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = ((Combo)e.widget).getSelectionIndex();
                EditableDatasetBaseComposite.this.updateIncrementTypeInformation(selIndex);
            }
        });
        this.comboIncrementGroup = new Combo((Composite)this, 8);
        this.comboIncrementGroup.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.comboIncrementGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = ((Combo)e.widget).getSelectionIndex();
                EditableDatasetBaseComposite.this.updateIncrementGroupInformation(selIndex);
            }
        });
        this.filterExpression = new WTextExpression(this, 0, Messages.EditableDatasetBaseComposite_FilterExprWidgetLbl, 2){

            @Override
            public void setExpression(JRDesignExpression exp) {
                super.setExpression(exp);
                EditableDatasetBaseComposite.this.datasetInstance.setIncrementWhenExpression((JRExpression)exp);
            }
        };
        GridData gdFilterExpression = new GridData(4, 4, true, false, 2, 1);
        this.filterExpression.setLayoutData(gdFilterExpression);
        Group grpDatasetRun = new Group((Composite)this, 0);
        grpDatasetRun.setText(Messages.EditableDatasetBaseComposite_DatasetRunGroupTitle);
        grpDatasetRun.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        grpDatasetRun.setLayoutData((Object)gd);
        this.datasetRunContent = new DatasetRunBaseComposite(this.getEditableDatesetRun(), (Composite)grpDatasetRun, 0);
        this.datasetRunContent.addDatasetRunSelectionListener(this::notifyDatasetRunSelectionChanged);
        this.initWidgets();
    }

    private void initWidgets() {
        int i;
        String currentGroupName;
        if (this.datasetInstance.getJRElementDataset() == null) {
            return;
        }
        this.comboResetType.setItems(EnumHelper.getEnumNames((NamedEnum[])ResetTypeEnum.values(), NullEnum.NOTNULL));
        this.comboResetType.select(this.datasetInstance.getJRElementDataset().getDatasetResetType().ordinal());
        this.comboResetGroup.setItems(new String[0]);
        this.comboResetGroup.setEnabled(false);
        if (this.datasetInstance.getJRElementDataset().getDatasetResetType() == DatasetResetTypeEnum.GROUP) {
            this.fillGroupCombo(this.comboResetGroup);
            JRGroup resetGroup = this.datasetInstance.getJRElementDataset().getResetGroup();
            if (resetGroup != null) {
                currentGroupName = resetGroup.getName();
                i = 0;
                while (i < this.comboResetGroup.getItemCount()) {
                    if (this.comboResetGroup.getItem(i).equals(currentGroupName)) {
                        this.comboResetGroup.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        this.comboIncrementType.setItems(EnumHelper.getEnumNames((NamedEnum[])IncrementTypeEnum.values(), NullEnum.NOTNULL));
        this.comboIncrementType.select(this.datasetInstance.getJRElementDataset().getIncrementTypeValue().ordinal());
        this.comboIncrementGroup.setItems(new String[0]);
        this.comboIncrementGroup.setEnabled(false);
        if (this.datasetInstance.getJRElementDataset().getIncrementTypeValue() == IncrementTypeEnum.GROUP) {
            this.fillGroupCombo(this.comboIncrementGroup);
            JRGroup incrementGroup = this.datasetInstance.getJRElementDataset().getIncrementGroup();
            if (incrementGroup != null) {
                currentGroupName = incrementGroup.getName();
                i = 0;
                while (i < this.comboIncrementGroup.getItemCount()) {
                    if (this.comboIncrementGroup.getItem(i).equals(currentGroupName)) {
                        this.comboIncrementGroup.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        this.filterExpression.setExpression((JRDesignExpression)this.datasetInstance.getJRElementDataset().getIncrementWhenExpression());
    }

    protected abstract IEditableDatasetRun getEditableDatesetRun();

    protected IEditableDataset getEditableDataset() {
        return this.datasetInstance;
    }

    protected List<JRGroup> getCurrentGroupsList() {
        JasperDesign jd = this.datasetInstance.getJasperDesign();
        JRDataset currentDataset = jd.getMainDataset();
        JRDatasetRun darasetRun = this.datasetInstance.getJRElementDataset().getDatasetRun();
        if (darasetRun != null && jd.getDatasetMap().containsKey(darasetRun.getDatasetName())) {
            currentDataset = (JRDataset)jd.getDatasetMap().get(darasetRun.getDatasetName());
        }
        return ((JRDesignDataset)currentDataset).getGroupsList();
    }

    private boolean fillGroupCombo(Combo widget) {
        List<JRGroup> groupsList = this.getCurrentGroupsList();
        if (groupsList == null || groupsList.isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.EditableDatasetBaseComposite_NoGroupsErrTitle, (String)Messages.EditableDatasetBaseComposite_NoGroupsErrMsg);
            widget.setItems(new String[0]);
            widget.setEnabled(false);
            return false;
        }
        ArrayList<String> groupLst = new ArrayList<String>();
        for (JRGroup g : groupsList) {
            groupLst.add(g.getName());
        }
        widget.setEnabled(true);
        widget.setItems(groupLst.toArray(new String[0]));
        return true;
    }

    private void updateResetGroupInformation(int selIndex) {
        JRGroup jrGroup = this.getCurrentGroupsList().get(selIndex);
        this.datasetInstance.setResetGroup(jrGroup);
    }

    private void updateResetTypeInformation(int selIndex) {
        DatasetResetTypeEnum selectedResType = (DatasetResetTypeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])DatasetResetTypeEnum.values(), (Object)this.comboResetType.getText());
        if (selectedResType == DatasetResetTypeEnum.GROUP) {
            if (this.fillGroupCombo(this.comboResetGroup)) {
                this.comboResetGroup.select(0);
                this.updateResetGroupInformation(0);
            }
        } else {
            this.datasetInstance.setResetGroup(null);
            this.comboResetGroup.setEnabled(false);
            this.comboResetGroup.setItems(new String[0]);
        }
        this.datasetInstance.setResetType(selectedResType);
    }

    private void updateIncrementGroupInformation(int selIndex) {
        JRGroup jrGroup = this.getCurrentGroupsList().get(selIndex);
        this.datasetInstance.setIncrementGroup(jrGroup);
    }

    private void updateIncrementTypeInformation(int selIndex) {
        IncrementTypeEnum selectedIncrType = (IncrementTypeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])IncrementTypeEnum.values(), (Object)this.comboIncrementType.getText());
        if (selectedIncrType == IncrementTypeEnum.GROUP) {
            if (this.fillGroupCombo(this.comboIncrementGroup)) {
                this.comboIncrementGroup.select(0);
                this.updateIncrementGroupInformation(0);
            }
        } else {
            this.datasetInstance.setResetGroup(null);
            this.comboIncrementGroup.setEnabled(false);
            this.comboIncrementGroup.setItems(new String[0]);
        }
        this.datasetInstance.setIncrementType(selectedIncrType);
    }

    public void addDatasetRunSelectionListener(DatasetRunSelectionListener listener) {
        this.dsRunSelectionListeners.add(listener);
    }

    public void removeDatasetRunSelectionListener(DatasetRunSelectionListener listener) {
        this.dsRunSelectionListeners.remove(listener);
    }

    private void notifyDatasetRunSelectionChanged() {
        for (DatasetRunSelectionListener l : this.dsRunSelectionListeners) {
            l.selectionChanged();
        }
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.filterExpression.setExpressionContext(expContext);
    }

    public void setDefaultExpressionContext(ExpressionContext expContext) {
        this.datasetRunContent.setExpressionContext(expContext);
    }
}

