/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jface.dialogs;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.UIUtil;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;

public class ElementWithValueExpressionDialog
extends FormDialog
implements IExpressionContextSetter {
    private String dialogTitle = Messages.ElementWithValueExpressionDialog_Title;
    private String lblNameText = Messages.ElementWithValueExpressionDialog_NameLbl;
    private String lblValueExpressionText = Messages.ElementWithValueExpressionDialog_ValueExprLbl;
    private String elementName;
    private JRDesignExpression elementValueExpr;
    private ExpressionContext expContext;
    private Text name;
    private WTextExpression valueExpression;

    public ElementWithValueExpressionDialog(Shell parentShell) {
        super(parentShell);
    }

    public ElementWithValueExpressionDialog(String dialogTitle, String labelName, String labelValueExpression, String currentName, JRDesignExpression currentExpression, Shell parentShell) {
        this(parentShell);
        Assert.isNotNull((Object)dialogTitle, (String)Messages.ElementWithValueExpressionDialog_AssertCustomTitleNotNull);
        Assert.isNotNull((Object)labelName, (String)Messages.ElementWithValueExpressionDialog_AssertCustomNameLblNotNull);
        Assert.isNotNull((Object)labelValueExpression, (String)Messages.ElementWithValueExpressionDialog_AssertCustomValueExprLblNotNull);
        this.dialogTitle = dialogTitle;
        this.lblNameText = labelName;
        this.lblValueExpressionText = labelValueExpression;
        this.elementName = currentName;
        this.elementValueExpr = currentExpression;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.dialogTitle);
    }

    protected void createFormContent(IManagedForm mform) {
        Composite container = mform.getForm().getBody();
        container.setBackground(UIUtil.getColor("org.eclipse.ui.workbench.INFORMATION_BACKGROUND"));
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginHeight = 10;
        containerLayout.verticalSpacing = 10;
        container.setLayout((Layout)containerLayout);
        Label lblName = new Label(container, 0);
        lblName.setLayoutData((Object)new GridData(4, 128, false, false));
        lblName.setText(this.lblNameText);
        this.name = new Text(container, 2048);
        GridData gd_name = new GridData(16384, 128, false, false);
        gd_name.widthHint = 150;
        this.name.setLayoutData((Object)gd_name);
        Label lblValueExpression = new Label(container, 0);
        lblValueExpression.setText(this.lblValueExpressionText);
        lblValueExpression.setLayoutData((Object)new GridData(4, 128, false, false));
        this.valueExpression = new WTextExpression(container, 0);
        GridData gd_valueExpression = new GridData(4, 4, true, true);
        gd_valueExpression.widthHint = 300;
        this.valueExpression.setLayoutData(gd_valueExpression);
        if (this.elementName != null) {
            this.name.setText(this.elementName);
        } else {
            this.name.setText("");
        }
        this.valueExpression.setExpression(this.elementValueExpr);
        this.valueExpression.setExpressionContext(this.expContext);
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void okPressed() {
        if (this.name.getText().isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ElementWithValueExpressionDialog_EmptyNameErrTitle, (String)Messages.ElementWithValueExpressionDialog_EmptyNameErrMsg);
        } else {
            this.elementName = this.name.getText();
            this.elementValueExpr = this.valueExpression.getExpression();
            super.okPressed();
        }
    }

    public String getElementName() {
        return this.elementName;
    }

    public JRDesignExpression getElementValueExpression() {
        return this.elementValueExpr;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
        if (this.valueExpression != null) {
            this.valueExpression.setExpressionContext(this.expContext);
        }
    }
}

