/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jface.dialogs;

import com.jaspersoft.studio.jface.dialogs.FilePreviewSelectionDialog;
import com.jaspersoft.studio.messages.Messages;
import org.eclipse.swt.widgets.Shell;

public class ImageSelectionDialog
extends FilePreviewSelectionDialog {
    private static final String SVG_TYPE = ".svg";
    private static final String GIF_TYPE = "*.gif";
    private static final String JPEG_JPG_TYPE = "*.jpeg; *.jpg";
    private static final String ALL_IMAGES_TYPE = "*.png;*.jpeg;*.jpg;*.gif;*.svg";
    private static final String PNG_TYPE = "*.png";

    public ImageSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected String getDialogTitle() {
        return Messages.ImageSelectionDialog_0;
    }

    @Override
    protected String[] getImageModesAndHeaderTitles() {
        return new String[]{Messages.ImageSelectionDialog_1, Messages.ImageSelectionDialog_2, Messages.ImageSelectionDialog_3, Messages.ImageSelectionDialog_4, Messages.ImageSelectionDialog_5, Messages.ImageSelectionDialog_6};
    }

    @Override
    protected String getDefaultResourcesPattern() {
        return PNG_TYPE;
    }

    @Override
    public String getSupportedTypeName(String type) {
        switch (type) {
            case "*.png;*.jpeg;*.jpg;*.gif;*.svg": {
                return Messages.ImageSelectionDialog_AllImagesTxt;
            }
            case "*.png": {
                return Messages.ImageSelectionDialog_PngTxt;
            }
            case "*.jpeg; *.jpg": {
                return Messages.ImageSelectionDialog_JpegTxt;
            }
            case "*.gif": {
                return Messages.ImageSelectionDialog_GifTxt;
            }
            case ".svg": {
                return Messages.ImageSelectionDialog_SvgTxt;
            }
            case "*.*": {
                return Messages.ImageSelectionDialog_AllFilesTxt;
            }
        }
        return super.getSupportedTypeName(type);
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{ALL_IMAGES_TYPE, PNG_TYPE, JPEG_JPG_TYPE, GIF_TYPE, SVG_TYPE, "*.*"};
    }
}

