/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import java.util.Collection;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;

public class CopyElementExpressionProperty
implements ICopyable {
    protected String propertyName;
    protected String value;
    protected boolean isSimpleText;

    public CopyElementExpressionProperty(String propertyName, Object value) {
        this.propertyName = propertyName;
        if (value instanceof JRDesignExpression) {
            this.value = ((JRDesignExpression)value).getText();
            this.isSimpleText = ExpressionTypeEnum.SIMPLE_TEXT == ((JRDesignExpression)value).getType();
        } else {
            this.value = (String)value;
            this.isSimpleText = false;
        }
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof APropertyNode) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    public Command getPasteCommand(Collection<?> targets) {
        CompoundCommand cc = new CompoundCommand();
        for (Object target : targets) {
            if (target instanceof EditPart) {
                target = ((EditPart)target).getModel();
            }
            if (!(target instanceof APropertyNode)) continue;
            Command pasteCommand = this.getPasteCommand((APropertyNode)target);
            cc.add(pasteCommand);
        }
        return cc;
    }

    protected Command getPasteCommand(APropertyNode target) {
        return new PastePropertyExpressionCommand(target);
    }

    public boolean isExpression() {
        return true;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isSimpleText() {
        return this.isSimpleText;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }

    private class PastePropertyExpressionCommand
    extends Command {
        private boolean alreadyPresent = false;
        private String oldValue;
        private APropertyNode target;

        public PastePropertyExpressionCommand(APropertyNode target) {
            this.target = target;
        }

        public boolean canExecute() {
            return CopyElementExpressionProperty.this.propertyName != null && this.target != null;
        }

        public void execute() {
            PropertyExpressionsDTO elementProperties = (PropertyExpressionsDTO)this.target.getPropertyValue("propertyExpressions");
            if (elementProperties != null) {
                if (elementProperties.hasProperty(CopyElementExpressionProperty.this.propertyName, CopyElementExpressionProperty.this.isExpression())) {
                    this.alreadyPresent = true;
                    this.oldValue = elementProperties.getProperty(CopyElementExpressionProperty.this.propertyName, CopyElementExpressionProperty.this.isExpression()).getValue();
                }
                elementProperties.setProperty(CopyElementExpressionProperty.this.propertyName, CopyElementExpressionProperty.this.value, CopyElementExpressionProperty.this.isExpression(), CopyElementExpressionProperty.this.isSimpleText());
                this.target.setPropertyValue("propertyExpressions", elementProperties);
            }
        }

        public void undo() {
            PropertyExpressionsDTO elementProperties = (PropertyExpressionsDTO)this.target.getPropertyValue("propertyExpressions");
            if (elementProperties != null) {
                if (this.alreadyPresent) {
                    elementProperties.setProperty(CopyElementExpressionProperty.this.propertyName, this.oldValue, CopyElementExpressionProperty.this.isExpression(), CopyElementExpressionProperty.this.isSimpleText());
                } else {
                    elementProperties.removeProperty(CopyElementExpressionProperty.this.propertyName, CopyElementExpressionProperty.this.isExpression());
                }
            }
            this.target.setPropertyValue("propertyExpressions", elementProperties);
        }
    }
}

