/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MGraphicElementLineBox;
import com.jaspersoft.studio.model.MGraphicElementLinePen;
import com.jaspersoft.studio.model.MRectangle;
import com.jaspersoft.studio.model.image.MImage;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.model.text.MTextField;
import java.awt.Color;
import java.util.HashMap;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;

public class DefaultValuesMap {
    private static HashMap<Class<?>, HashMap<String, Object>> valuesMap = null;
    private static final Integer INTEGER_ZERO = 0;

    private static String concatenateProperties(String prop1, String prop2) {
        return prop1.concat(".").concat(prop2);
    }

    private static void createBaseLinePen(HashMap<String, Object> result, String baseProperty) {
        String widthKey = DefaultValuesMap.concatenateProperties(baseProperty, "lineWidth");
        String colorKey = DefaultValuesMap.concatenateProperties(baseProperty, "lineColor");
        String styleKey = DefaultValuesMap.concatenateProperties(baseProperty, "lineStyle");
        result.put(colorKey, Color.black);
        result.put(styleKey, LineStyleEnum.SOLID);
        result.put(widthKey, JRPen.LINE_WIDTH_0);
    }

    public static void createBaseLineBox(HashMap<String, Object> result, String baseProperty) {
        String paddingKey = DefaultValuesMap.concatenateProperties(baseProperty, "padding");
        String paddingLeftKey = DefaultValuesMap.concatenateProperties(baseProperty, "leftPadding");
        String paddingRightKey = DefaultValuesMap.concatenateProperties(baseProperty, "rightPadding");
        String paddingBottomKey = DefaultValuesMap.concatenateProperties(baseProperty, "bottomPadding");
        String paddingTopKey = DefaultValuesMap.concatenateProperties(baseProperty, "topPadding");
        String penKey = DefaultValuesMap.concatenateProperties(baseProperty, "LinePen");
        String penLeftKey = DefaultValuesMap.concatenateProperties(baseProperty, "LinePen_LEFT");
        String penRightKey = DefaultValuesMap.concatenateProperties(baseProperty, "LinePen_RIGHT");
        String penBottomKey = DefaultValuesMap.concatenateProperties(baseProperty, "LinePen_BOTTOM");
        String penTopKey = DefaultValuesMap.concatenateProperties(baseProperty, "LinePen_TOP");
        result.put(paddingKey, INTEGER_ZERO);
        result.put(paddingTopKey, INTEGER_ZERO);
        result.put(paddingBottomKey, INTEGER_ZERO);
        result.put(paddingLeftKey, INTEGER_ZERO);
        result.put(paddingRightKey, INTEGER_ZERO);
        DefaultValuesMap.createBaseLinePen(result, penKey);
        DefaultValuesMap.createBaseLinePen(result, penLeftKey);
        DefaultValuesMap.createBaseLinePen(result, penRightKey);
        DefaultValuesMap.createBaseLinePen(result, penBottomKey);
        DefaultValuesMap.createBaseLinePen(result, penTopKey);
    }

    private static void createBaseParagraph(HashMap<String, Object> result, String baseProperty) {
        String lineSpacingKey = DefaultValuesMap.concatenateProperties(baseProperty, "lineSpacing");
        String lineSpacingSizeKey = DefaultValuesMap.concatenateProperties(baseProperty, "lineSpacingSize");
        String firstLineIdentKey = DefaultValuesMap.concatenateProperties(baseProperty, "firstLineIndent");
        String leftIdentKey = DefaultValuesMap.concatenateProperties(baseProperty, "leftIndent");
        String rightIdentKey = DefaultValuesMap.concatenateProperties(baseProperty, "rightIndent");
        String spacingBeforeKey = DefaultValuesMap.concatenateProperties(baseProperty, "spacingBefore");
        String spacingAfterKey = DefaultValuesMap.concatenateProperties(baseProperty, "spacingAfter");
        String tabStopsWidthKey = DefaultValuesMap.concatenateProperties(baseProperty, "tabStopWidth");
        result.put(lineSpacingKey, LineSpacingEnum.SINGLE);
        JRPropertiesUtil prop = JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance());
        result.put(lineSpacingSizeKey, Float.valueOf(prop.getFloatProperty("net.sf.jasperreports.default.line.spacing.size")));
        result.put(firstLineIdentKey, prop.getIntegerProperty("net.sf.jasperreports.default.first.line.indent"));
        result.put(leftIdentKey, prop.getIntegerProperty("net.sf.jasperreports.default.left.indent"));
        result.put(rightIdentKey, prop.getIntegerProperty("net.sf.jasperreports.default.right.indent"));
        result.put(spacingBeforeKey, prop.getIntegerProperty("net.sf.jasperreports.default.spacing.before"));
        result.put(spacingAfterKey, prop.getIntegerProperty("net.sf.jasperreports.default.spacing.after"));
        result.put(tabStopsWidthKey, prop.getIntegerProperty("net.sf.jasperreports.default.tab.stop.width"));
    }

    private static HashMap<String, Object> initializeType(APropertyNode type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JRPropertiesUtil prop = JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance());
        result.put("fontName", prop.getProperty("net.sf.jasperreports.default.font.name"));
        result.put("pattern", null);
        result.put("markup", "none");
        if (type instanceof MStyle) {
            result.put("fontSize", null);
            result.put("isBold", null);
            result.put("isItalic", null);
            result.put("isUnderline", null);
            result.put("isStrikeThrough", null);
            result.put("isBlankWhenNull", null);
            result.put("verticalTextAlignment", null);
            result.put("horizontalTextAlignment", null);
            result.put("verticalImageAlignment", null);
            result.put("horizontalImageAlignment", null);
            result.put("scaleImage", null);
            result.put("rotation", null);
            result.put("radius", null);
            result.put("lineWidth", null);
            result.put("lineColor", null);
            result.put("backcolor", null);
            result.put("forecolor", null);
            result.put("fill", null);
            result.put("mode", ModeEnum.OPAQUE.getName());
            result.put("pdfFontName", prop.getProperty("net.sf.jasperreports.default.pdf.font.name"));
            result.put("pdfEncoding", prop.getProperty("net.sf.jasperreports.default.pdf.encoding"));
            result.put("isPdfEmbedded", prop.getBooleanProperty("net.sf.jasperreports.default.pdf.embedded"));
            DefaultValuesMap.createBaseLinePen(result, "LinePen");
            DefaultValuesMap.createBaseLineBox(result, "LineBox");
            DefaultValuesMap.createBaseParagraph(result, "paragraph");
        } else {
            result.put("backcolor", Color.white);
            result.put("forecolor", Color.black);
            ModeEnum transparency = ModeEnum.OPAQUE;
            if (type instanceof MGraphicElementLinePen) {
                DefaultValuesMap.createBaseLinePen(result, "LinePen");
            } else if (type instanceof MGraphicElementLineBox) {
                DefaultValuesMap.createBaseLineBox(result, "LineBox");
            }
            if (type instanceof MTextElement) {
                result.put("fontSize", prop.getIntegerProperty("net.sf.jasperreports.default.font.size"));
                result.put("isBold", false);
                result.put("isItalic", false);
                result.put("isUnderline", false);
                result.put("isStrikeThrough", false);
                result.put("verticalTextAlignment", VerticalTextAlignEnum.TOP);
                result.put("horizontalTextAlignment", HorizontalTextAlignEnum.LEFT);
                result.put("rotation", RotationEnum.NONE);
                result.put("pdfFontName", prop.getProperty("net.sf.jasperreports.default.pdf.font.name"));
                result.put("pdfEncoding", prop.getProperty("net.sf.jasperreports.default.pdf.encoding"));
                result.put("isPdfEmbedded", prop.getBooleanProperty("net.sf.jasperreports.default.pdf.embedded"));
                transparency = ModeEnum.TRANSPARENT;
                DefaultValuesMap.createBaseParagraph(result, "paragraph");
            }
            if (type instanceof MTextField) {
                result.put("isBlankWhenNull", false);
            }
            if (type instanceof MRectangle) {
                result.put("fill", FillEnum.SOLID);
                result.put("radius", INTEGER_ZERO);
            }
            if (type instanceof MImage) {
                result.put("scaleImage", ScaleImageEnum.RETAIN_SHAPE);
                result.put("fill", FillEnum.SOLID);
            }
            result.put("mode", transparency);
        }
        return result;
    }

    public static HashMap<String, Object> getPropertiesByType(APropertyNode element) {
        HashMap<String, Object> result;
        if (valuesMap == null) {
            valuesMap = new HashMap();
        }
        if ((result = valuesMap.get(element.getClass())) == null) {
            result = DefaultValuesMap.initializeType(element);
            valuesMap.put(element.getClass(), result);
        }
        return result;
    }
}

