/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model;

import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.editor.gef.rulers.ReportRulerGuide;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.IDesignDragable;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.IGraphicElementContainer;
import com.jaspersoft.studio.model.IGraphicalPropertiesHandler;
import com.jaspersoft.studio.model.IGuidebleElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastableGraphic;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.RefreshPropertyEvent;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import com.jaspersoft.studio.property.JSSStyleResolver;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.checkbox.NullCheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.color.ColorPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWStyleComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRPrintWhenExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.JPropertyExpressionsDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.AbstractJSSCellEditorValidator;
import com.jaspersoft.studio.property.descriptors.JSSPixelLocationValidator;
import com.jaspersoft.studio.property.descriptors.JSSTextPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import com.jaspersoft.studio.utils.ModelUtils;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignGenericElement;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MGraphicElement
extends APropertyNode
implements IGraphicElement,
ICopyable,
IGuidebleElement,
IDragable,
IDesignDragable,
IGraphicalPropertiesHandler {
    public static final long serialVersionUID = 10200L;
    private static RComboBoxPropertyDescriptor groupChangesD;
    private static NamedEnumPropertyDescriptor<PositionTypeEnum> positionTypeD;
    private static NamedEnumPropertyDescriptor<StretchTypeEnum> stretchTypeD;
    private transient IPropertyDescriptor[] descriptors;
    private ReportRulerGuide verticalGuide;
    private ReportRulerGuide horizontalGuide;
    private transient List<AbstractJSSCellEditorValidator> positionValidators = new ArrayList<AbstractJSSCellEditorValidator>();
    public static String FORCE_GRAPHICAL_REFRESH;
    private static IIconDescriptor iconDescriptor;
    private boolean visualPropertyChanged = true;
    public static final String PROPERTY_ELEMENT_NAME = "com.jaspersoft.studio.element.name";
    private static HashMap<Class<?>, HashSet<String>> cachedGraphicalProperties;

    static {
        FORCE_GRAPHICAL_REFRESH = "forceGraphicalRefresh";
        cachedGraphicalProperties = new HashMap();
    }

    @Override
    public ReportRulerGuide getVerticalGuide() {
        return this.verticalGuide;
    }

    @Override
    public void setVerticalGuide(ReportRulerGuide verticalGuide) {
        this.verticalGuide = verticalGuide;
    }

    @Override
    public ReportRulerGuide getHorizontalGuide() {
        return this.horizontalGuide;
    }

    @Override
    public void setHorizontalGuide(ReportRulerGuide horizontalGuide) {
        this.horizontalGuide = horizontalGuide;
    }

    @Override
    public void setParent(ANode parent, int newIndex) {
        if (parent instanceof MGraphicElement) {
            IGuidebleElement p = (IGuidebleElement)((Object)parent);
            if (p.getVerticalGuide() != null) {
                p.getVerticalGuide().detachPart(p);
            }
            if (p.getHorizontalGuide() != null) {
                p.getHorizontalGuide().detachPart(p);
            }
        }
        super.setParent(parent, newIndex);
    }

    public INode getBand() {
        INode node = this;
        while (!(node instanceof MBand) && !(node instanceof MRoot)) {
            if (node == null || node.getParent() == null) {
                return this;
            }
            node = node.getParent();
        }
        return node;
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("generic");
        }
        return iconDescriptor;
    }

    public MGraphicElement() {
    }

    public MGraphicElement(ANode parent, int newIndex) {
        super(parent, newIndex);
    }

    public MGraphicElement(ANode parent, JRDesignElement jrLine, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrLine);
    }

    public JRDesignElement getValue() {
        return (JRDesignElement)super.getValue();
    }

    @Override
    public void setValue(Object value) {
        if (this.getValue() instanceof JRDesignGraphicElement) {
            ((JRBasePen)((JRDesignGraphicElement)this.getValue()).getLinePen()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
        } else if (value instanceof JRDesignGraphicElement) {
            ((JRBasePen)((JRDesignGraphicElement)value).getLinePen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        super.setValue(value);
    }

    @Override
    public int getDefaultHeight() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(this.getClass(), "height");
        return defaultValue != null ? (Integer)defaultValue : 30;
    }

    @Override
    public int getDefaultWidth() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(this.getClass(), "width");
        return defaultValue != null ? (Integer)defaultValue : 100;
    }

    public JRDesignElement createJRElement(JasperDesign jasperDesign, boolean applyDefault) {
        return new JRDesignGenericElement((JRDefaultStyleProvider)jasperDesign);
    }

    @Override
    public JRDesignElement createJRElement(JasperDesign jasperDesign) {
        return this.createJRElement(jasperDesign, true);
    }

    @Override
    public String getDisplayText() {
        String p = this.getElementNameProperty();
        return Misc.isNullOrEmpty((String)p) ? MGraphicElement.getIconDescriptor().getTitle() : p;
    }

    protected String getElementNameProperty() {
        JRDesignElement el = this.getValue();
        if (el != null) {
            return el.getPropertiesMap().getProperty(PROPERTY_ELEMENT_NAME);
        }
        return null;
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MGraphicElement.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MGraphicElement.getIconDescriptor().getToolTip();
    }

    @Override
    public Rectangle getBounds() {
        JRDesignElement jr = this.getValue();
        INode node = this.getParent();
        while (node != null) {
            if (node instanceof MPage) {
                return new Rectangle(0, 0, jr.getWidth(), jr.getHeight());
            }
            if (node instanceof IGraphicElement) {
                Rectangle b = ((IGraphicElement)((Object)node)).getBounds();
                if (b == null) {
                    return new Rectangle(jr.getX(), jr.getY(), jr.getWidth(), jr.getHeight());
                }
                b = new Rectangle(b);
                if (node instanceof IGraphicElementContainer) {
                    int x = ((IGraphicElementContainer)((Object)node)).getLeftPadding();
                    int y = ((IGraphicElementContainer)((Object)node)).getTopPadding();
                    b.setLocation(b.x + x, b.y + y);
                }
                return new Rectangle(b.x + jr.getX(), b.y + jr.getY(), jr.getWidth(), jr.getHeight());
            }
            node = node.getParent();
        }
        return new Rectangle(0, 0, jr.getWidth(), jr.getHeight());
    }

    @Override
    public Rectangle getJRBounds() {
        JRDesignElement jr = this.getValue();
        return new Rectangle(jr.getX(), jr.getY(), jr.getWidth(), jr.getHeight());
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        JRDataset dataset;
        super.postDescriptors(descriptors);
        JasperDesign jd = this.getJasperDesign();
        if (jd != null && this.getValue() != null && (dataset = this.getElementDataset()) != null) {
            JRGroup[] groups = dataset.getGroups();
            String[] items = new String[groups.length + 1];
            items[0] = "";
            int j = 0;
            while (j < groups.length) {
                items[j + 1] = groups[j].getName();
                ++j;
            }
            this.setGroupItems(items);
        }
        for (AbstractJSSCellEditorValidator validator : this.positionValidators) {
            validator.setTargetNode(this);
        }
    }

    public JRDataset getElementDataset() {
        JRDesignDataset dataset = ModelUtils.getDataset(this);
        if (dataset == null && this.getJasperDesign() != null) {
            dataset = this.getJasperDesign().getMainDataset();
        }
        return dataset;
    }

    protected void setGroupItems(String[] items) {
        if (groupChangesD != null) {
            groupChangesD.setItems(items);
        }
    }

    @Override
    public HashMap<String, Object> getStylesDescriptors() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.getValue() == null) {
            return result;
        }
        JRDesignElement element = this.getValue();
        result.put("backcolor", element.getOwnBackcolor());
        result.put("forecolor", element.getOwnForecolor());
        result.put("mode", element.getOwnModeValue());
        return result;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        JSSTextPropertyDescriptor nameD = new JSSTextPropertyDescriptor(PROPERTY_ELEMENT_NAME, Messages.PHolderUtil_1);
        nameD.setDescription(Messages.PHolderUtil_1);
        nameD.setCategory(Messages.common_graphic);
        desc.add((IPropertyDescriptor)nameD);
        RWStyleComboBoxPropertyDescriptor styleD = new RWStyleComboBoxPropertyDescriptor("parentStyle", Messages.common_parent_style, new String[]{""}, NullEnum.NULL);
        styleD.setDescription(Messages.MGraphicElement_parent_style_description);
        desc.add((IPropertyDescriptor)styleD);
        styleD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#reportElement_style"));
        groupChangesD = new RComboBoxPropertyDescriptor("printWhenGroupChanges", Messages.MGraphicElement_print_when_group_changes, new String[]{""});
        groupChangesD.setDescription(Messages.MGraphicElement_print_when_group_changes_description);
        groupChangesD.setCategory(Messages.MGraphicElement_print_when);
        desc.add((IPropertyDescriptor)groupChangesD);
        NTextPropertyDescriptor keyD = new NTextPropertyDescriptor("key", Messages.common_key);
        keyD.setDescription(Messages.MGraphicElement_key_description);
        desc.add((IPropertyDescriptor)keyD);
        JSSPixelLocationValidator heightValidator = new JSSPixelLocationValidator("height");
        heightValidator.setTargetNode(this);
        PixelPropertyDescriptor heightD = new PixelPropertyDescriptor("height", Messages.common_height);
        heightD.setCategory(Messages.common_size);
        heightD.setDescription(Messages.MGraphicElement_height_description);
        heightD.setValidator(heightValidator);
        desc.add((IPropertyDescriptor)heightD);
        this.positionValidators.add(heightValidator);
        JSSPixelLocationValidator widthValidator = new JSSPixelLocationValidator("width");
        widthValidator.setTargetNode(this);
        PixelPropertyDescriptor widthD = new PixelPropertyDescriptor("width", Messages.MGraphicElement_width);
        widthD.setCategory(Messages.common_size);
        widthD.setDescription(Messages.MGraphicElement_width_description);
        widthD.setValidator(widthValidator);
        desc.add((IPropertyDescriptor)widthD);
        this.positionValidators.add(widthValidator);
        JSSPixelLocationValidator xValidator = new JSSPixelLocationValidator("x");
        xValidator.setTargetNode(this);
        PixelPropertyDescriptor xD = new PixelPropertyDescriptor("x", Messages.common_left);
        xD.setCategory(Messages.MGraphicElement_location_category);
        xD.setDescription(Messages.MGraphicElement_left_description);
        xD.setValidator(xValidator);
        desc.add((IPropertyDescriptor)xD);
        this.positionValidators.add(xValidator);
        JSSPixelLocationValidator yValidator = new JSSPixelLocationValidator("y");
        yValidator.setTargetNode(this);
        PixelPropertyDescriptor yD = new PixelPropertyDescriptor("y", Messages.common_top);
        yD.setCategory(Messages.MGraphicElement_location_category);
        yD.setDescription(Messages.MGraphicElement_top_description);
        yD.setValidator(yValidator);
        desc.add((IPropertyDescriptor)yD);
        this.positionValidators.add(yValidator);
        ColorPropertyDescriptor backcolorD = new ColorPropertyDescriptor("backcolor", Messages.common_backcolor, NullEnum.INHERITED);
        backcolorD.setDescription(Messages.MGraphicElement_backcolor_description);
        desc.add((IPropertyDescriptor)backcolorD);
        ColorPropertyDescriptor forecolorD = new ColorPropertyDescriptor("forecolor", Messages.common_forecolor, NullEnum.INHERITED);
        forecolorD.setDescription(Messages.MGraphicElement_forecolor_description);
        desc.add((IPropertyDescriptor)forecolorD);
        NullCheckBoxPropertyDescriptor opaqueDBool = new NullCheckBoxPropertyDescriptor("mode", Messages.common_opaque);
        opaqueDBool.setDescription(Messages.MGraphicElement_opaque_description);
        opaqueDBool.setCategory(Messages.common_graphic);
        desc.add((IPropertyDescriptor)opaqueDBool);
        positionTypeD = new NamedEnumPropertyDescriptor<PositionTypeEnum>("positionType", Messages.common_position_type, PositionTypeEnum.FIX_RELATIVE_TO_BOTTOM, NullEnum.NOTNULL);
        positionTypeD.setDescription(Messages.MGraphicElement_position_type_description);
        desc.add((IPropertyDescriptor)positionTypeD);
        positionTypeD.setCategory(Messages.MGraphicElement_location_category);
        CheckBoxPropertyDescriptor printRVAlueD = new CheckBoxPropertyDescriptor("isPrintRepeatedValues", Messages.MGraphicElement_print_repeated_values);
        printRVAlueD.setDescription(Messages.MGraphicElement_print_repeated_values_description);
        desc.add((IPropertyDescriptor)printRVAlueD);
        CheckBoxPropertyDescriptor rmLineWBlankD = new CheckBoxPropertyDescriptor("isRemoveLineWhenBlank", Messages.MGraphicElement_remove_line_when_blank);
        rmLineWBlankD.setDescription(Messages.MGraphicElement_remove_line_when_blank_description);
        desc.add((IPropertyDescriptor)rmLineWBlankD);
        CheckBoxPropertyDescriptor printInFirstWholeBandD = new CheckBoxPropertyDescriptor("isPrintInFirstWholeBand", Messages.MGraphicElement_print_in_first_whole_band);
        printInFirstWholeBandD.setDescription(Messages.MGraphicElement_print_in_first_whole_band_description);
        desc.add((IPropertyDescriptor)printInFirstWholeBandD);
        CheckBoxPropertyDescriptor printWhenDetailOverflowsD = new CheckBoxPropertyDescriptor("isPrintWhenDetailOverflows", Messages.MGraphicElement_print_when_detail_overflows);
        printWhenDetailOverflowsD.setDescription(Messages.MGraphicElement_print_when_detail_overflows_desription);
        printWhenDetailOverflowsD.setCategory(Messages.MGraphicElement_print_when);
        desc.add((IPropertyDescriptor)printWhenDetailOverflowsD);
        JRPrintWhenExpressionPropertyDescriptor printWhenExprD = new JRPrintWhenExpressionPropertyDescriptor("printWhenExpression", Messages.common_print_when_expression);
        printWhenExprD.setDescription(Messages.MGraphicElement_print_when_expression_description);
        printWhenExprD.setCategory(Messages.MGraphicElement_print_when);
        desc.add((IPropertyDescriptor)printWhenExprD);
        printWhenExprD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#printWhenExpression"));
        JPropertyExpressionsDescriptor propertiesD = new JPropertyExpressionsDescriptor("propertyExpressions", Messages.MGraphicElement_property_expressions);
        propertiesD.setDescription(Messages.MGraphicElement_property_expressions_description);
        desc.add((IPropertyDescriptor)propertiesD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#reportElement");
        stretchTypeD = new NamedEnumPropertyDescriptor<StretchTypeEnum>("stretchType", Messages.common_stretch_type, StretchTypeEnum.NO_STRETCH, NullEnum.NOTNULL);
        stretchTypeD.setCategory(Messages.common_size);
        stretchTypeD.setDescription(Messages.MGraphicElement_stretch_type_description);
        desc.add((IPropertyDescriptor)stretchTypeD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#graphicElement");
        forecolorD.setCategory(Messages.common_graphic);
        backcolorD.setCategory(Messages.common_graphic);
        styleD.setCategory(Messages.common_graphic);
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("parentStyle", new DefaultValue(null, true));
        defaultsMap.put("forecolor", new DefaultValue(null, true));
        defaultsMap.put("backcolor", new DefaultValue(null, true));
        defaultsMap.put("mode", new DefaultValue(Boolean.FALSE, true));
        int positionDefault = NamedEnumPropertyDescriptor.getIntValue(PositionTypeEnum.FIX_RELATIVE_TO_TOP, NullEnum.NOTNULL, PositionTypeEnum.FIX_RELATIVE_TO_TOP);
        defaultsMap.put("positionType", new DefaultValue(positionDefault, false));
        StretchTypeEnum stretchDefault = NamedEnumPropertyDescriptor.getEnumValue(StretchTypeEnum.NO_STRETCH, NullEnum.NOTNULL, StretchTypeEnum.NO_STRETCH);
        defaultsMap.put("stretchType", new DefaultValue(stretchDefault, false));
        defaultsMap.put("isPrintRepeatedValues", new DefaultValue(Boolean.TRUE, true));
        defaultsMap.put("isRemoveLineWhenBlank", new DefaultValue(Boolean.FALSE, true));
        defaultsMap.put("isPrintInFirstWholeBand", new DefaultValue(Boolean.FALSE, true));
        defaultsMap.put("isPrintWhenDetailOverflows", new DefaultValue(Boolean.FALSE, true));
        defaultsMap.put("printWhenExpression", new DefaultValue(null, true));
        return defaultsMap;
    }

    protected JRStyle getActualStyle() {
        JRDesignElement jrElement = this.getValue();
        if (jrElement.getStyle() != null && !this.getJasperDesign().getStylesMap().containsKey(jrElement.getStyle().getName())) {
            this.setPropertyValue("parentStyle", null);
        }
        if (jrElement.getStyle() != null) {
            return jrElement.getStyle();
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        JRDesignElement jrElement = this.getValue();
        if (id.equals(PROPERTY_ELEMENT_NAME)) {
            return jrElement.getPropertiesMap().getProperty(PROPERTY_ELEMENT_NAME);
        }
        if (id.equals("key")) {
            return jrElement.getKey();
        }
        if (id.equals("printWhenExpression")) {
            return ExprUtil.getExpression(jrElement.getPrintWhenExpression());
        }
        if (id.equals("parentStyle")) {
            if (jrElement.getStyleNameReference() != null) {
                return jrElement.getStyleNameReference();
            }
            JRStyle actualStyle = this.getActualStyle();
            return actualStyle != null ? actualStyle.getName() : "";
        }
        if (id.equals("printWhenGroupChanges")) {
            if (jrElement.getPrintWhenGroupChanges() != null) {
                return jrElement.getPrintWhenGroupChanges().getName();
            }
            return "";
        }
        if (id.equals("propertyExpressions")) {
            JRPropertyExpression[] propertyExpressions = jrElement.getPropertyExpressions();
            if (propertyExpressions != null) {
                propertyExpressions = (JRPropertyExpression[])propertyExpressions.clone();
            }
            return new PropertyExpressionsDTO(propertyExpressions, this.getPropertiesMapClone(jrElement), this.getValue(), ModelUtils.getExpressionContext(this));
        }
        if (id.equals("PROPERTY_MAP")) {
            return this.getPropertiesMapClone(jrElement);
        }
        if (id.equals("height")) {
            return new Integer(jrElement.getHeight());
        }
        if (id.equals("width")) {
            return new Integer(jrElement.getWidth());
        }
        if (id.equals("x")) {
            return new Integer(jrElement.getX());
        }
        if (id.equals("y")) {
            return new Integer(jrElement.getY());
        }
        if (id.equals("backcolor")) {
            return Colors.getSWTRGB4AWTGBColor(jrElement.getOwnBackcolor());
        }
        if (id.equals("forecolor")) {
            return Colors.getSWTRGB4AWTGBColor(jrElement.getOwnForecolor());
        }
        if (id.equals("mode")) {
            ModeEnum modeValue = jrElement.getOwnModeValue();
            return modeValue != null ? Boolean.valueOf(modeValue.equals((Object)ModeEnum.TRANSPARENT)) : null;
        }
        if (id.equals("positionType")) {
            return positionTypeD.getIntValue(jrElement.getPositionTypeValue());
        }
        if (id.equals("stretchType")) {
            return stretchTypeD.getIntValue(jrElement.getStretchTypeValue());
        }
        if (id.equals("isPrintRepeatedValues")) {
            return new Boolean(jrElement.isPrintRepeatedValues());
        }
        if (id.equals("isRemoveLineWhenBlank")) {
            return new Boolean(jrElement.isRemoveLineWhenBlank());
        }
        if (id.equals("isPrintInFirstWholeBand")) {
            return new Boolean(jrElement.isPrintInFirstWholeBand());
        }
        if (id.equals("isPrintWhenDetailOverflows")) {
            return new Boolean(jrElement.isPrintWhenDetailOverflows());
        }
        return null;
    }

    protected JRPropertiesMap getPropertiesMapClone(JRDesignElement jrElement) {
        JRPropertiesMap propertiesMap = jrElement.getPropertiesMap();
        if (propertiesMap != null) {
            propertiesMap = propertiesMap.cloneProperties();
        }
        return propertiesMap;
    }

    public JRPropertiesMap getPropertiesMap() {
        JRDesignElement jrElement = this.getValue();
        return jrElement.getPropertiesMap();
    }

    @Override
    public Object getPropertyActualValue(Object id) {
        JRDesignElement jrElement = this.getValue();
        JSSStyleResolver resolver = this.getStyleResolver();
        if (id.equals("backcolor")) {
            Color backcolor = resolver.getBackcolor((JRCommonElement)jrElement);
            return Colors.getSWTRGB4AWTGBColor(backcolor);
        }
        if (id.equals("forecolor")) {
            Color forecolor = resolver.getForecolor((JRCommonElement)jrElement);
            return Colors.getSWTRGB4AWTGBColor(forecolor);
        }
        if (id.equals("mode")) {
            return ModeEnum.TRANSPARENT.equals((Object)resolver.getMode((JRCommonElement)jrElement, ModeEnum.TRANSPARENT));
        }
        return super.getPropertyActualValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignElement jrElement = this.getValue();
        if (id.equals("key")) {
            jrElement.setKey((String)value);
        } else if (id.equals(PROPERTY_ELEMENT_NAME)) {
            if (Misc.isNullOrEmpty((String)((String)value))) {
                jrElement.getPropertiesMap().removeProperty(PROPERTY_ELEMENT_NAME);
            } else {
                jrElement.getPropertiesMap().setProperty(PROPERTY_ELEMENT_NAME, (String)value);
            }
            this.firePropertyChange(new PropertyChangeEvent(jrElement, "PROPERTY_MAP", null, jrElement.getPropertiesMap()));
        } else if (id.equals("parentStyle")) {
            if (value != null && !((String)value).trim().isEmpty()) {
                if (!value.equals("")) {
                    JRStyle style = (JRStyle)this.getJasperDesign().getStylesMap().get(value);
                    if (style != null) {
                        jrElement.setStyleNameReference(null);
                        jrElement.setStyle(style);
                    } else {
                        jrElement.setStyleNameReference((String)value);
                        jrElement.setStyle(null);
                    }
                }
            } else {
                jrElement.setStyleNameReference(null);
                jrElement.setStyle(null);
            }
        } else if (id.equals("printWhenExpression")) {
            jrElement.setPrintWhenExpression(ExprUtil.setValues(jrElement.getPrintWhenExpression(), value));
        } else if (id.equals("printWhenGroupChanges")) {
            if (!value.equals("")) {
                JRDesignDataset jrDataset = (JRDesignDataset)this.getElementDataset();
                JRGroup group = (JRGroup)jrDataset.getGroupsMap().get(value);
                jrElement.setPrintWhenGroupChanges(group);
            } else {
                jrElement.setPrintWhenGroupChanges(null);
            }
        } else if (id.equals("propertyExpressions")) {
            if (value instanceof PropertyExpressionsDTO) {
                PropertyExpressionsDTO dto = (PropertyExpressionsDTO)value;
                JRPropertyExpression[] expr = jrElement.getPropertyExpressions();
                if (expr != null) {
                    JRPropertyExpression[] jRPropertyExpressionArray = expr;
                    int n = expr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRPropertyExpression ex = jRPropertyExpressionArray[n2];
                        jrElement.removePropertyExpression(ex);
                        ++n2;
                    }
                }
                for (PropertyExpressionDTO p : dto.getProperties()) {
                    if (!p.isExpression()) continue;
                    JRDesignPropertyExpression newExp = new JRDesignPropertyExpression();
                    newExp.setName(p.getName());
                    newExp.setValueExpression(p.getValueAsExpression());
                    jrElement.addPropertyExpression((JRPropertyExpression)newExp);
                }
                JRPropertiesMap originalMap = jrElement.getPropertiesMap().cloneProperties();
                String[] names = jrElement.getPropertiesMap().getPropertyNames();
                int i = 0;
                while (i < names.length) {
                    jrElement.getPropertiesMap().removeProperty(names[i]);
                    ++i;
                }
                for (PropertyExpressionDTO p : dto.getProperties()) {
                    if (p.isExpression()) continue;
                    jrElement.getPropertiesMap().setProperty(p.getName(), p.getValue());
                }
                this.firePropertyChange(new PropertyChangeEvent(jrElement, "PROPERTY_MAP", originalMap, jrElement.getPropertiesMap()));
            }
        } else if (id.equals("height")) {
            jrElement.setHeight(((Integer)Misc.nvl((Object)value, (Object)0)).intValue());
        } else if (id.equals("width")) {
            jrElement.setWidth(((Integer)Misc.nvl((Object)value, (Object)0)).intValue());
        } else if (id.equals("x")) {
            jrElement.setX(((Integer)Misc.nvl((Object)value, (Object)0)).intValue());
        } else if (id.equals("y")) {
            jrElement.setY(((Integer)Misc.nvl((Object)value, (Object)0)).intValue());
        } else if (id.equals("forecolor")) {
            jrElement.setForecolor(Colors.getAWT4SWTRGBColor((AlfaRGB)value));
        } else if (id.equals("backcolor")) {
            jrElement.setBackcolor(Colors.getAWT4SWTRGBColor((AlfaRGB)value));
        } else if (id.equals("mode")) {
            if (value == null) {
                jrElement.setMode(null);
            } else if (((Boolean)value).booleanValue()) {
                jrElement.setMode(ModeEnum.TRANSPARENT);
            } else {
                jrElement.setMode(ModeEnum.OPAQUE);
            }
        } else if (id.equals("positionType")) {
            if (positionTypeD == null) {
                this.getPropertyDescriptors();
            }
            jrElement.setPositionType(positionTypeD.getEnumValue(value));
        } else if (id.equals("stretchType")) {
            jrElement.setStretchType(stretchTypeD.getEnumValue(value));
        } else if (id.equals("isPrintRepeatedValues")) {
            jrElement.setPrintRepeatedValues(((Boolean)value).booleanValue());
        } else if (id.equals("isRemoveLineWhenBlank")) {
            jrElement.setRemoveLineWhenBlank(((Boolean)value).booleanValue());
        } else if (id.equals("isPrintInFirstWholeBand")) {
            jrElement.setPrintInFirstWholeBand(((Boolean)value).booleanValue());
        } else if (id.equals("isPrintWhenDetailOverflows")) {
            jrElement.setPrintWhenDetailOverflows(((Boolean)value).booleanValue());
        } else if (id.equals("PROPERTY_MAP")) {
            JRPropertiesMap originalMap = jrElement.getPropertiesMap().cloneProperties();
            JRPropertiesMap v = (JRPropertiesMap)value;
            String[] names = jrElement.getPropertiesMap().getPropertyNames();
            int i = 0;
            while (i < names.length) {
                jrElement.getPropertiesMap().removeProperty(names[i]);
                ++i;
            }
            names = v.getPropertyNames();
            i = 0;
            while (i < names.length) {
                jrElement.getPropertiesMap().setProperty(names[i], v.getProperty(names[i]));
                ++i;
            }
            this.firePropertyChange(new PropertyChangeEvent(jrElement, "PROPERTY_MAP", originalMap, jrElement.getPropertiesMap()));
        }
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MElementGroup || parent instanceof IPastableGraphic) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    public HashSet<String> generateGraphicalProperties() {
        HashSet<String> result = new HashSet<String>();
        result.add(FORCE_GRAPHICAL_REFRESH);
        result.add("parentStyle");
        result.add("height");
        result.add("width");
        result.add("x");
        result.add("y");
        result.add("forecolor");
        result.add("backcolor");
        result.add("mode");
        return result;
    }

    @Override
    public HashSet<String> getGraphicalProperties() {
        HashSet<String> result = cachedGraphicalProperties.get(this.getClass());
        if (result == null) {
            result = this.generateGraphicalProperties();
            cachedGraphicalProperties.put(this.getClass(), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChangedProperty() {
        MGraphicElement mGraphicElement = this;
        synchronized (mGraphicElement) {
            return this.visualPropertyChanged;
        }
    }

    @Override
    public void setStyleChangedProperty() {
        this.setChangedProperty(true, new RefreshPropertyEvent(this));
    }

    @Override
    public void setChangedProperty(boolean value) {
        this.setChangedProperty(value, new RefreshPropertyEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChangedProperty(boolean value, PropertyChangeEvent event) {
        MGraphicElement mGraphicElement = this;
        synchronized (mGraphicElement) {
            this.visualPropertyChanged = value;
        }
        if (value) {
            RefreshPropertyEvent refreshEvent = null;
            refreshEvent = event == null || !RefreshPropertyEvent.class.equals(event.getClass()) ? new RefreshPropertyEvent(event.getSource()) : (RefreshPropertyEvent)event;
            ANode parent = this.getParent();
            while (parent != null) {
                if (parent.getValue() != null && parent.getValue() instanceof JRChangeEventsSupport) {
                    JRChangeEventsSupport parentEvents = (JRChangeEventsSupport)parent.getValue();
                    if (refreshEvent.hasElementTriggeredEvent(parentEvents)) break;
                    refreshEvent.setElementTriggeredEvent(parentEvents);
                    parentEvents.getEventSupport().firePropertyChange((PropertyChangeEvent)refreshEvent);
                    break;
                }
                parent = parent.getParent();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        HashSet<String> graphicalProperties;
        if (!this.visualPropertyChanged && (graphicalProperties = this.getGraphicalProperties()).contains(evt.getPropertyName())) {
            this.setChangedProperty(true, evt);
        }
        super.propertyChange(evt);
    }

    @Override
    public Map<String, List<ANode>> getUsedStyles() {
        Map<String, List<ANode>> result = super.getUsedStyles();
        JRStyle style = this.getValue().getStyle();
        this.addElementStyle(style, result);
        return result;
    }

    @Override
    public void setStyle(JRStyle style) {
        if (this.getValue() != null) {
            this.getValue().setStyle(style);
        }
    }

    protected SetValueCommand generateSetCommand(APropertyNode target, String propertyId, Object value) {
        SetValueCommand result = new SetValueCommand();
        result.setTarget(target);
        result.setPropertyId(propertyId);
        result.setPropertyValue(value);
        return result;
    }

    protected Color getColorClone(Color source) {
        if (source == null) {
            return null;
        }
        return new Color(source.getRed(), source.getGreen(), source.getBlue(), source.getAlpha());
    }

    protected String getStringClone(String source) {
        if (source == null) {
            return null;
        }
        return new String(source);
    }

    protected JRFont getFontClone(JRFont sourceFont) {
        if (sourceFont == null) {
            return null;
        }
        if (sourceFont instanceof JRBaseFont) {
            return (JRBaseFont)((JRBaseFont)sourceFont).clone();
        }
        if (sourceFont instanceof JRTextElement) {
            return (JRTextElement)((JRTextElement)sourceFont).clone();
        }
        return null;
    }

    public void trasnferProperties(JRElement target) {
        JRDesignElement jrTarget = (JRDesignElement)target;
        JRDesignElement jrSource = this.getValue();
        jrTarget.setKey(this.getStringClone(jrSource.getKey()));
        jrTarget.setWidth(jrSource.getWidth());
        jrTarget.setHeight(jrSource.getHeight());
        jrTarget.setBackcolor(jrSource.getOwnBackcolor());
        jrTarget.setForecolor(jrSource.getOwnForecolor());
        jrTarget.setMode(jrSource.getOwnModeValue());
        jrTarget.setPositionType(jrSource.getPositionTypeValue());
        jrTarget.setStretchType(jrSource.getStretchTypeValue());
        jrTarget.setPrintRepeatedValues(jrSource.isPrintRepeatedValues());
        jrTarget.setRemoveLineWhenBlank(jrSource.isRemoveLineWhenBlank());
        jrTarget.setPrintInFirstWholeBand(jrSource.isPrintInFirstWholeBand());
        jrTarget.setPrintWhenDetailOverflows(jrSource.isPrintWhenDetailOverflows());
    }

    @Override
    protected List<ValidationError> doValidation() {
        boolean isValidPosition = true;
        ANode parent = this.getParent();
        if (parent instanceof APropertyNode && !(parent instanceof MFrame)) {
            Rectangle r;
            IGraphicElement ge;
            JRDesignElement item = this.getValue();
            int x = item.getX();
            int y = item.getY();
            int w = item.getWidth();
            int h = item.getHeight();
            int fh = Integer.MAX_VALUE;
            int fw = Integer.MAX_VALUE;
            if (parent instanceof MGraphicElement) {
                MGraphicElement fatherModel = (MGraphicElement)this.getParent();
                JRDesignElement fitem = fatherModel.getValue();
                fh = fitem.getHeight();
                fw = fitem.getWidth();
            } else if (parent instanceof MBand) {
                JRDesignBand band = ((MBand)this.getParent()).getValue();
                fh = band.getHeight();
                fw = this.getJasperDesign().getPageWidth();
            } else if (parent instanceof MPage) {
                x = 0;
                y = 0;
                ge = (MPage)this.getParent();
                JasperDesign jd = (JasperDesign)((ANode)((Object)ge)).getValue();
                fh = jd.getPageHeight();
                fw = jd.getPageWidth();
            } else if (parent instanceof IGraphicElement && (r = (ge = (IGraphicElement)((Object)this.getParent())).getBounds()) != null) {
                fh = r.height;
                fw = r.width;
            }
            JRElementGroup elementGroup = this.getValue().getElementGroup();
            if (elementGroup instanceof JRBand) {
                isValidPosition = y + h <= fh;
            } else if (elementGroup != null) {
                boolean bl = isValidPosition = fh >= h + y && x >= 0 && y >= 0 && fw >= x + w;
            }
        }
        if (!isValidPosition) {
            ArrayList<ValidationError> error = new ArrayList<ValidationError>();
            ArrayList<String> lst = new ArrayList<String>();
            lst.add("height");
            lst.add("width");
            lst.add("x");
            lst.add("y");
            error.add(new ValidationError(lst, Messages.ErrorDecorator_PositionErrorToolTip));
            return error;
        }
        return null;
    }

    protected boolean checkVisibleFrame() {
        ANode parent = this.getParent();
        boolean visible = true;
        JRDesignElement currentEelement = this.getValue();
        int relative_X = currentEelement.getX();
        int relative_Y = currentEelement.getY();
        while (parent != null && visible) {
            JRDesignElement frame;
            Rectangle rect;
            boolean allowOutside;
            if (parent instanceof MFrame && !(allowOutside = ((Boolean)((MFrame)parent).getPropertyValue("ShowOutOfBoundContent")).booleanValue()) && !(rect = new Rectangle(0, 0, (frame = (JRDesignElement)parent.getValue()).getWidth(), frame.getHeight())).contains(relative_X, relative_Y)) {
                visible = false;
            }
            if (parent.getValue() instanceof JRDesignElement) {
                JRDesignElement jrParent = (JRDesignElement)parent.getValue();
                relative_Y += jrParent.getY();
                relative_X += jrParent.getX();
            }
            parent = parent.getParent();
        }
        return visible;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.checkVisibleFrame();
    }

    @Override
    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }

    @Override
    public boolean isReportSplittingSupported() {
        return true;
    }

    @Override
    public Rectangle getAbsoluteBounds() {
        int x = this.getValue().getX();
        int y = this.getValue().getY();
        ANode parent = this.getParent();
        if (parent instanceof IGraphicalPropertiesHandler) {
            Rectangle parentLocation = ((IGraphicalPropertiesHandler)((Object)parent)).getAbsoluteBounds();
            x += parentLocation.x;
            y += parentLocation.y;
        } else if (parent instanceof MBand) {
            JasperDesign jd = this.getJasperDesign();
            int bandVOffset = 0;
            JRBand[] jRBandArray = jd.getAllBands();
            int n = jRBandArray.length;
            int n2 = 0;
            while (n2 < n) {
                JRBand band = jRBandArray[n2];
                if (band == null || band == parent.getValue()) break;
                bandVOffset += band.getHeight();
                ++n2;
            }
            x += jd.getLeftMargin();
            y += jd.getTopMargin() + bandVOffset;
        }
        return new Rectangle(x, y, this.getValue().getWidth(), this.getValue().getHeight());
    }
}

