/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model;

import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.MGraphicElementLinePen;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.JSSStyleResolver;
import com.jaspersoft.studio.property.descriptors.IntegerPropertyDescriptor;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRCommonRectangle;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MRectangle
extends MGraphicElementLinePen {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("rectangle");
        }
        return iconDescriptor;
    }

    public MRectangle() {
    }

    public MRectangle(ANode parent, JRDesignRectangle jrRectangle, int newImage) {
        super(parent, newImage);
        this.setValue(jrRectangle);
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#graphicElement");
        IntegerPropertyDescriptor rD = new IntegerPropertyDescriptor("radius", Messages.common_radius);
        rD.setCategory(Messages.MRectangle_rectangle_properties_category);
        rD.setDescription(Messages.MRectangle_radius_description);
        rD.setBounds(0, Integer.MAX_VALUE);
        desc.add((IPropertyDescriptor)rD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#rectangle");
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("radius", new DefaultValue(null, true));
        return defaultsMap;
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignRectangle jrElement = (JRDesignRectangle)this.getValue();
        if (id.equals("radius")) {
            return jrElement.getOwnRadius();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public Object getPropertyActualValue(Object id) {
        JRDesignRectangle jrElement = (JRDesignRectangle)this.getValue();
        JSSStyleResolver resolver = this.getStyleResolver();
        if (id.equals("radius")) {
            return resolver.getRadius((JRCommonRectangle)jrElement);
        }
        return super.getPropertyActualValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        JRDesignRectangle jrElement = (JRDesignRectangle)this.getValue();
        if (id.equals("radius")) {
            Integer intv = (Integer)value;
            if (intv != null) {
                jrElement.setRadius(Integer.valueOf(Math.abs(intv)));
            } else {
                jrElement.setRadius(null);
            }
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public int getDefaultHeight() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(this.getClass(), "height");
        return defaultValue != null ? (Integer)defaultValue : 50;
    }

    @Override
    public int getDefaultWidth() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(this.getClass(), "width");
        return defaultValue != null ? (Integer)defaultValue : 100;
    }

    @Override
    public JRDesignElement createJRElement(JasperDesign jasperDesign, boolean applyDefault) {
        JRDesignRectangle jrDesignRectangle = new JRDesignRectangle((JRDefaultStyleProvider)jasperDesign);
        if (applyDefault) {
            DefaultManager.INSTANCE.applyDefault(this.getClass(), (JRElement)jrDesignRectangle);
        }
        jrDesignRectangle.setWidth(this.getDefaultWidth());
        jrDesignRectangle.setHeight(this.getDefaultHeight());
        return jrDesignRectangle;
    }

    @Override
    public String getDisplayText() {
        String p = this.getElementNameProperty();
        return Misc.isNullOrEmpty((String)p) ? MRectangle.getIconDescriptor().getTitle() : p;
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MRectangle.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MRectangle.getIconDescriptor().getToolTip();
    }

    @Override
    public HashSet<String> generateGraphicalProperties() {
        HashSet<String> result = super.generateGraphicalProperties();
        result.add("fill");
        result.add("radius");
        return result;
    }

    @Override
    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        JRRectangle jrSource = (JRRectangle)this.getValue();
        if (jrSource != null) {
            JRRectangle jrTarget = (JRRectangle)target;
            jrTarget.setFill(jrSource.getOwnFillValue());
            jrTarget.setRadius(jrSource.getOwnRadius());
        }
    }
}

