/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.util.List;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import org.eclipse.gef.commands.Command;

public class CloseSubeditorsCommand
extends Command {
    private Command deleteCommand;
    private INode element;

    public CloseSubeditorsCommand(Command deleteCommand, INode element) {
        this.deleteCommand = deleteCommand;
        this.element = element;
    }

    public CloseSubeditorsCommand(INode parent) {
        this.deleteCommand = new Command(){};
        this.element = parent;
    }

    public void execute() {
        if (this.areSubeditorOpened(this.element)) {
            this.sendDeleteEvent(this.element.getChildren());
        }
        this.deleteCommand.execute();
    }

    private void sendDeleteEvent(List<INode> children) {
        if (children == null) {
            return;
        }
        for (INode child : children) {
            this.sendDeleteEvent(child.getChildren());
            if (!(child.getValue() instanceof JRChangeEventsSupport)) continue;
            JRChangeEventsSupport eventElement = (JRChangeEventsSupport)child.getValue();
            PropertyChangeEvent event = new PropertyChangeEvent(child.getValue(), "closeElementEditor", child.getValue(), null);
            eventElement.getEventSupport().firePropertyChange(event);
        }
    }

    private boolean areSubeditorOpened(INode node) {
        Object rawEditor;
        JasperReportsConfiguration jConfig = ((ANode)node).getJasperConfiguration();
        if (jConfig != null && (rawEditor = jConfig.get("thecurrenteditor")) != null && rawEditor instanceof JrxmlEditor) {
            JrxmlEditor editor = (JrxmlEditor)rawEditor;
            return editor.getReportContainer().hasSubeditorOpened();
        }
        return true;
    }

    public boolean canExecute() {
        return this.deleteCommand != null && this.deleteCommand.canExecute();
    }

    public boolean canUndo() {
        return this.deleteCommand != null && this.deleteCommand.canUndo();
    }

    public void undo() {
        this.deleteCommand.undo();
    }
}

