/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.band.MBandGroupFooter;
import com.jaspersoft.studio.model.band.MBandGroupHeader;
import com.jaspersoft.studio.model.command.CancelledOperationException;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import com.jaspersoft.studio.model.command.Tag;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.regex.Matcher;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class CreateE4ObjectCommand
extends CreateElementCommand {
    protected ANode child;
    protected ANode parent;
    private JRDesignVariable var;

    public CreateE4ObjectCommand(ANode child, ANode parent, Rectangle location, int index) {
        this.child = child;
        this.parent = parent;
        this.location = location;
        this.index = index;
        this.jasperDesign = parent.getJasperDesign();
    }

    public ANode getChild() {
        return this.child;
    }

    protected ANode fixPosition(ANode destNode, ANode srcNode, Rectangle position) {
        if (position == null) {
            position = this.jrElement != null ? new Rectangle(this.jrElement.getX(), this.jrElement.getY(), this.jrElement.getWidth(), this.jrElement.getHeight()) : new Rectangle(0, 0, 70, 30);
        }
        MBand band = null;
        if (destNode instanceof MReport) {
            band = ModelUtils.getBand4Point(destNode, new Point(position.x, position.y));
        }
        if (band == null) {
            if (destNode instanceof MBand) {
                band = (MBand)destNode;
            } else {
                do {
                    if (!((destNode = destNode.getParent()) instanceof MBand)) continue;
                    band = (MBand)destNode;
                    break;
                } while (destNode != null);
            }
        }
        this.fixLocation(position, band);
        return band;
    }

    private boolean isSubdataset() {
        INode p = this.child.getParent();
        while (p != null) {
            if (p instanceof MDataset) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    @Override
    protected void createObject() {
        try {
            if (SelectionHelper.isMainEditorOpened() && this.isSubdataset()) {
                this.operationCancelled = true;
                UIUtils.showInformation((String)Messages.CreateE4ObjectCommand_subdataseterror);
                return;
            }
            Tag tag = Tag.getExpression(this.child);
            ANode n = null;
            n = this.parent instanceof MFrame ? (ANode)((MFrame)this.parent).getBand() : this.fixPosition(this.parent, this.child, this.location);
            if (n instanceof MBand) {
                JRDesignBand b = (JRDesignBand)n.getValue();
                BandTypeEnum btype = b.getOrigin().getBandTypeValue();
                if (btype.equals((Object)BandTypeEnum.DETAIL)) {
                    this.srcNode = Tag.createTextField(tag.txt.replaceAll("%", Matcher.quoteReplacement(tag.name)), tag.classname, this.jasperDesign);
                } else if (btype.equals((Object)BandTypeEnum.COLUMN_FOOTER) || btype.equals((Object)BandTypeEnum.COLUMN_HEADER)) {
                    this.var = Tag.createVariable(tag, ResetTypeEnum.COLUMN, null, this.jasperDesign.getMainDesignDataset());
                    this.srcNode = Tag.createTextField(tag.txt.replaceAll("%", Matcher.quoteReplacement(tag.name)), tag.classname, this.jasperDesign);
                } else if (btype.equals((Object)BandTypeEnum.GROUP_FOOTER)) {
                    this.var = Tag.createVariable(tag, ResetTypeEnum.GROUP, (JRGroup)((MBandGroupFooter)n).getJrGroup(), this.jasperDesign.getMainDesignDataset());
                    this.srcNode = Tag.createTextField(tag.txt.replaceAll("%", Matcher.quoteReplacement(tag.name)), tag.classname, this.jasperDesign);
                } else if (btype.equals((Object)BandTypeEnum.GROUP_HEADER)) {
                    this.var = Tag.createVariable(tag, ResetTypeEnum.GROUP, (JRGroup)((MBandGroupHeader)n).getJrGroup(), this.jasperDesign.getMainDesignDataset());
                    this.srcNode = Tag.createTextField(tag.txt.replaceAll("%", Matcher.quoteReplacement(tag.name)), tag.classname, this.jasperDesign);
                } else if (btype.equals((Object)BandTypeEnum.SUMMARY) || btype.equals((Object)BandTypeEnum.TITLE)) {
                    this.var = Tag.createVariable(tag, ResetTypeEnum.REPORT, null, this.jasperDesign.getMainDesignDataset());
                    this.srcNode = Tag.createTextField(tag.txt.replaceAll("%", Matcher.quoteReplacement(tag.name)), tag.classname, this.jasperDesign);
                } else if (btype.equals((Object)BandTypeEnum.PAGE_FOOTER) || btype.equals((Object)BandTypeEnum.PAGE_HEADER) || btype.equals((Object)BandTypeEnum.LAST_PAGE_FOOTER)) {
                    this.var = Tag.createVariable(tag, ResetTypeEnum.PAGE, null, this.jasperDesign.getMainDesignDataset());
                    this.srcNode = Tag.createTextField(tag.txt.replaceAll("%", Matcher.quoteReplacement(tag.name)), tag.classname, this.jasperDesign);
                } else {
                    this.srcNode = Tag.createStaticText(tag.name, this.jasperDesign);
                }
            } else {
                this.srcNode = Tag.createStaticText(tag.name, this.jasperDesign);
            }
            if (this.parent instanceof MFrame) {
                this.setContext(this.parent, this.srcNode, this.index);
            } else {
                this.setContext(n, this.srcNode, this.index);
            }
            super.createObject();
        }
        catch (CancelledOperationException e) {
            this.operationCancelled = true;
            JaspersoftStudioPlugin.getInstance().logError(Messages.CreateE4ObjectCommand_ErrorCreatingObject, e);
        }
    }

    @Override
    public boolean canExecute() {
        return this.parent == null || this.parent.canAcceptChildren(this.child);
    }

    @Override
    public void execute() {
        super.execute();
        try {
            if (this.var != null) {
                this.jasperDesign.addVariable(this.var);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void undo() {
        super.undo();
        if (this.var != null) {
            this.jasperDesign.removeVariable((JRVariable)this.var);
            this.var = null;
        }
    }
}

