/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.command.CreateE4ObjectCommand;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.text.MStaticText;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.UUID;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Shell;

public class CreateFieldInEditorCommand
extends CreateE4ObjectCommand {
    private JRElementGroup staticTextParent;
    private MStaticText staticText = null;
    private int createdFields = 1;

    public CreateFieldInEditorCommand(MField child, ANode parent, Rectangle location, int index) {
        super((ANode)child, parent, location, index);
    }

    private MStaticText createLabelForField() {
        Object description;
        int columnHeaderHeight;
        ANode dest = ModelUtils.getReport(this.destNode).getBand(BandTypeEnum.COLUMN_HEADER);
        int staticTextHeight = new MStaticText().getDefaultHeight();
        int defaultWidth = new MTextField().getDefaultWidth();
        boolean placeinTheHedaer = false;
        if (dest != null && dest.getValue() != null && (columnHeaderHeight = ((MBand)dest).getValue().getHeight()) > 0) {
            placeinTheHedaer = true;
            if (columnHeaderHeight < staticTextHeight) {
                staticTextHeight = columnHeaderHeight;
            }
        }
        if (!placeinTheHedaer) {
            if (this.createdFields > 1) {
                return null;
            }
            staticTextHeight = new MTextField().getDefaultHeight();
            dest = this.destNode;
        }
        MStaticText newText = new MStaticText();
        JRDesignStaticText newTextElement = (JRDesignStaticText)newText.createJRElement(this.parent.getJasperDesign());
        String labelText = null;
        String plabel = ((MField)this.child).getValue().getPropertiesMap().getProperty("com.jaspersoft.studio.field.label");
        labelText = !Misc.isNullOrEmpty((String)plabel) ? plabel : this.child.getDisplayText();
        Boolean useDescription = this.child.getJasperConfiguration().getPropertyBoolean("useDescriptionOnFieldDrop", false);
        if (useDescription.booleanValue() && (description = ((APropertyNode)this.child).getPropertyValue("description")) instanceof String) {
            labelText = (String)description;
        }
        newTextElement.setText(labelText);
        if (placeinTheHedaer) {
            String uuID = UUID.randomUUID().toString();
            newTextElement.getPropertiesMap().setProperty("com.jaspersoft.studio.spreadsheet.connectionID", uuID);
            this.srcNode.getValue().getPropertiesMap().setProperty("com.jaspersoft.studio.spreadsheet.connectionID", uuID);
        }
        newText.setValue(newTextElement);
        Rectangle location = null;
        String dragMessage = null;
        if (placeinTheHedaer) {
            int x = this.srcNode.getValue().getX();
            int actualWidth = this.getLocation().width != -1 ? this.getLocation().width : defaultWidth;
            location = new Rectangle(x, 0, actualWidth, staticTextHeight);
            dragMessage = Messages.JSSTemplateTransferDropTargetListener_createLabelMessage2;
        } else {
            int actualWidth = this.getLocation().width != -1 ? this.getLocation().width : defaultWidth;
            int x = this.srcNode.getValue().getX() - actualWidth;
            int y = this.srcNode.getValue().getY();
            location = new Rectangle(x, y, actualWidth, staticTextHeight);
            dragMessage = Messages.JSSTemplateTransferDropTargetListener_createLabelMessage1;
        }
        if (location != null) {
            String dragBehavior = JaspersoftStudioPlugin.getInstance().getPreferenceStore().getString("fieldDrop");
            if (dragBehavior.equals("ask_everytime")) {
                MessageDialogWithToggle question = MessageDialogWithToggle.open((int)3, (Shell)UIUtils.getShell(), (String)Messages.JSSTemplateTransferDropTargetListener_createLabelTitle, (String)dragMessage, null, (boolean)false, null, null, (int)0);
                dragBehavior = question.getReturnCode() == 2 ? "create_label" : "do_nothing";
                if (question.getToggleState()) {
                    JaspersoftStudioPlugin.getInstance().getPreferenceStore().setValue("fieldDrop", dragBehavior);
                }
            }
            if (dragBehavior.equals("create_label")) {
                this.staticTextParent = (JRElementGroup)dest.getValue();
                new CreateElementCommand(dest, (MGraphicElement)newText, location, this.index).execute();
                return newText;
            }
        }
        return null;
    }

    @Override
    public void execute() {
        super.execute();
        ANode parentBand = this.destNode;
        while (parentBand != null && !(parentBand instanceof MBand)) {
            parentBand = parentBand.getParent();
        }
        if (parentBand != null && ((MBand)parentBand).getBandType() == BandTypeEnum.DETAIL) {
            this.staticText = this.createLabelForField();
        }
    }

    @Override
    public void undo() {
        super.undo();
        if (this.staticText != null) {
            if (this.staticTextParent instanceof JRDesignBand) {
                ((JRDesignBand)this.staticTextParent).removeElement(this.staticText.getValue());
            } else if (this.staticTextParent instanceof JRDesignFrame) {
                ((JRDesignFrame)this.staticTextParent).removeElement((JRElement)this.staticText.getValue());
            }
            this.staticText = null;
        }
    }

    public void setCreatedFields(int createdFields) {
        this.createdFields = createdFields;
    }
}

