/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MElementGroup;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.eclipse.gef.commands.Command;

public class DeleteElementGroupCommand
extends Command {
    private JRElementGroup jrGroup;
    private JRDesignElementGroup jrElement;
    private int elementPosition = 0;

    public DeleteElementGroupCommand(ANode destNode, MElementGroup srcNode) {
        this.jrElement = (JRDesignElementGroup)srcNode.getValue();
        this.jrGroup = this.jrElement.getElementGroup();
    }

    public void execute() {
        this.elementPosition = this.jrGroup.getChildren().indexOf(this.jrElement);
        if (this.jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.jrGroup).removeElementGroup(this.jrElement);
        } else if (this.jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)this.jrGroup).removeElementGroup((JRElementGroup)this.jrElement);
        }
    }

    public boolean canUndo() {
        return this.jrGroup != null && this.jrElement != null;
    }

    public void undo() {
        if (this.jrGroup instanceof JRDesignElementGroup) {
            if (this.elementPosition > ((JRDesignElementGroup)this.jrGroup).getChildren().size()) {
                ((JRDesignElementGroup)this.jrGroup).addElementGroup(this.jrElement);
            } else {
                ((JRDesignElementGroup)this.jrGroup).addElementGroup(this.elementPosition, this.jrElement);
            }
        } else if (this.jrGroup instanceof JRDesignFrame) {
            if (this.elementPosition > ((JRDesignFrame)this.jrGroup).getChildren().size()) {
                ((JRDesignFrame)this.jrGroup).addElementGroup((JRElementGroup)this.jrElement);
            } else {
                ((JRDesignFrame)this.jrGroup).addElementGroup(this.elementPosition, (JRElementGroup)this.jrElement);
            }
        }
    }
}

