/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MElementGroup;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.eclipse.gef.commands.Command;

public class ReorderElementGroupCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignElementGroup jrElement;
    private JRElementGroup jrGroup;

    public ReorderElementGroupCommand(MElementGroup child, ANode parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = (JRDesignElementGroup)child.getValue();
        this.jrGroup = this.jrElement.getElementGroup();
    }

    public void execute() {
        this.oldIndex = this.jrGroup.getChildren().indexOf(this.jrElement);
        if (this.jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.jrGroup).removeElementGroup(this.jrElement);
            if (this.newIndex < 0 || this.newIndex > this.jrGroup.getChildren().size()) {
                ((JRDesignElementGroup)this.jrGroup).addElementGroup(this.jrElement);
            } else {
                ((JRDesignElementGroup)this.jrGroup).addElementGroup(this.newIndex, this.jrElement);
            }
        } else if (this.jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)this.jrGroup).removeElementGroup((JRElementGroup)this.jrElement);
            if (this.newIndex < 0 || this.newIndex > this.jrGroup.getChildren().size()) {
                ((JRDesignFrame)this.jrGroup).addElementGroup((JRElementGroup)this.jrElement);
            } else {
                ((JRDesignFrame)this.jrGroup).addElementGroup(this.newIndex, (JRElementGroup)this.jrElement);
            }
        }
    }

    public void undo() {
        if (this.jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.jrGroup).removeElementGroup(this.jrElement);
            if (this.oldIndex < 0 || this.oldIndex > this.jrGroup.getChildren().size()) {
                ((JRDesignElementGroup)this.jrGroup).addElementGroup(this.jrElement);
            } else {
                ((JRDesignElementGroup)this.jrGroup).addElementGroup(this.oldIndex, this.jrElement);
            }
        } else if (this.jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)this.jrGroup).removeElementGroup((JRElementGroup)this.jrElement);
            if (this.oldIndex < 0 || this.oldIndex > this.jrGroup.getChildren().size()) {
                ((JRDesignFrame)this.jrGroup).addElementGroup((JRElementGroup)this.jrElement);
            } else {
                ((JRDesignFrame)this.jrGroup).addElementGroup(this.oldIndex, (JRElementGroup)this.jrElement);
            }
        }
    }
}

