/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.model.MQuery;
import com.jaspersoft.studio.model.command.IQueryLanguageChanged;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.utils.SyncDatasetRunParameters;
import net.sf.jasperreports.engine.JRException;
import org.eclipse.gef.commands.Command;

public class SyncDatasetRunCommand
extends Command {
    protected MDataset dataset;
    protected String oldLang;
    protected String newLang;

    public SyncDatasetRunCommand(MDataset target, MQuery newValue, MQuery oldValue) {
        this.dataset = target;
        this.oldLang = oldValue != null && oldValue.getValue() != null ? oldValue.getValue().getLanguage() : null;
        this.newLang = newValue != null && newValue.getValue() != null ? newValue.getValue().getLanguage() : null;
    }

    public SyncDatasetRunCommand(MQuery target, String newValue, String oldValue) {
        this.dataset = target.getMdataset();
        this.oldLang = oldValue;
        this.newLang = newValue;
    }

    public SyncDatasetRunCommand(MDataset target, String newValue, String oldValue) {
        this.dataset = target;
        this.oldLang = oldValue;
        this.newLang = newValue;
    }

    public void execute() {
        try {
            for (IQueryLanguageChanged exec : SyncDatasetRunParameters.changed) {
                exec.syncDataset(this.dataset.getJasperDesign(), this.dataset.getValue(), this.oldLang, this.newLang);
            }
            SyncDatasetRunParameters.syncDataset(this.dataset, this.oldLang, this.newLang, false);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        try {
            for (IQueryLanguageChanged exec : SyncDatasetRunParameters.changed) {
                exec.syncDataset(this.dataset.getJasperDesign(), this.dataset.getValue(), this.newLang, this.oldLang);
            }
            SyncDatasetRunParameters.syncDataset(this.dataset, this.newLang, this.oldLang, false);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

