/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.command.CancelledOperationException;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.parameter.MParameterSystem;
import com.jaspersoft.studio.model.text.MStaticText;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.model.variable.MVariableSystem;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.obj2text.Obj2TextWizard;
import java.util.regex.Matcher;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class Tag {
    public boolean isField = false;
    public String name;
    public String txt;
    public String label;
    public String classname;
    public Class<?> clazz;

    public Tag(String txt, String classname, String name, Class<?> clazz, String label) {
        this.txt = txt;
        this.classname = classname;
        this.clazz = clazz;
        this.name = name;
        this.label = label;
    }

    public static Tag getExpression(ANode n) {
        if (n.getValue() != null) {
            if (n instanceof MField) {
                JRField f = (JRField)n.getValue();
                String lbl = f.getName();
                String plabel = f.getPropertiesMap().getProperty("com.jaspersoft.studio.field.label");
                if (!Misc.isNullOrEmpty((String)plabel)) {
                    lbl = plabel;
                }
                Tag tag = new Tag("$F{%}", f.getValueClassName(), f.getName(), Tag.resolveClass(n, f.getValueClassName()), lbl);
                tag.isField = true;
                return tag;
            }
            if (n instanceof MParameterSystem) {
                JRParameter f = (JRParameter)n.getValue();
                Tag result = new Tag("$P{%}", f.getValueClassName(), f.getName(), Tag.resolveClass(n, f.getValueClassName()), null);
                return result;
            }
            if (n instanceof MVariableSystem) {
                JRVariable f = (JRVariable)n.getValue();
                return new Tag("$V{%}", f.getValueClassName(), f.getName(), Tag.resolveClass(n, f.getValueClassName()), null);
            }
        }
        return new Tag("", "", "", null, null);
    }

    protected static Class<?> resolveClass(ANode node, String classFullName) {
        JasperReportsConfiguration jConfig = node.getJasperConfiguration();
        if (jConfig != null) {
            try {
                Class<?> clazz = jConfig.getClassLoader().loadClass(classFullName);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError(e);
            }
        }
        return null;
    }

    public static MStaticText createStaticText(String text, JasperDesign jd) {
        MStaticText src = new MStaticText();
        JRDesignStaticText tf = new JRDesignStaticText((JRDefaultStyleProvider)jd);
        tf.setText(text);
        src.setValue(tf);
        return src;
    }

    public static MTextField createTextField(String txtExp, String classExp, JasperDesign jd) {
        MTextField src = new MTextField();
        JRDesignTextField tf = new JRDesignTextField((JRDefaultStyleProvider)jd);
        src.setValue(tf);
        JRDesignExpression jre = new JRDesignExpression();
        jre.setText(txtExp);
        tf.setExpression((JRExpression)jre);
        return src;
    }

    public static JRDesignVariable createVariable(Tag tag, ResetTypeEnum rtype, JRGroup group, JRDesignDataset jDesign) throws CancelledOperationException {
        JRDesignVariable jrVariable = null;
        if (tag.isField) {
            String[] names = null;
            names = Number.class.isAssignableFrom(tag.clazz) ? EnumHelper.getEnumNames((NamedEnum[])CalculationEnum.values(), NullEnum.NOTNULL) : EnumHelper.getEnumNames((NamedEnum[])new CalculationEnum[]{CalculationEnum.NOTHING, CalculationEnum.COUNT, CalculationEnum.DISTINCT_COUNT}, NullEnum.NOTNULL);
            Obj2TextWizard wizard = new Obj2TextWizard(names);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            dialog.create();
            if (dialog.open() == 0) {
                CalculationEnum ce = wizard.getCalculation();
                if (ce != null && !CalculationEnum.NOTHING.equals((Object)ce)) {
                    jrVariable = new JRDesignVariable();
                    jrVariable.setCalculation(ce);
                    jrVariable.setName(ModelUtils.getDefaultName(jDesign.getVariablesMap(), tag.name));
                    jrVariable.setResetType(rtype);
                    if (rtype.equals((Object)ResetTypeEnum.GROUP)) {
                        jrVariable.setResetGroup(group);
                    }
                    if (CalculationEnum.COUNT.equals((Object)ce) || CalculationEnum.DISTINCT_COUNT.equals((Object)ce)) {
                        jrVariable.setValueClass(Integer.class);
                    } else {
                        jrVariable.setValueClassName(tag.classname);
                    }
                    JRDesignExpression jre = new JRDesignExpression();
                    jre.setText(tag.txt.replaceAll("%", tag.name));
                    jrVariable.setExpression((JRExpression)jre);
                    tag.name = jrVariable.getName();
                    tag.txt = "$V{%}";
                }
            } else {
                throw new CancelledOperationException();
            }
        }
        return jrVariable;
    }

    public String getExpressionText() {
        return this.txt.replaceAll("%", Matcher.quoteReplacement(this.name));
    }
}

