/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.dataset;

import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IContainerEditPart;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.dataset.descriptor.DatasetRunPropertyDescriptor;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.combo.RComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.DatasetResetTypeEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MElementDataset
extends APropertyNode
implements IContainer,
IContainerEditPart {
    private static IIconDescriptor iconDescriptor;
    public static final long serialVersionUID = 10200L;
    private IPropertyDescriptor[] descriptors;
    private MDatasetRun mDatasetRun;
    private RComboBoxPropertyDescriptor incGroupD;
    private RComboBoxPropertyDescriptor resetGroupD;
    private JasperDesign jasperDesign;
    private static NamedEnumPropertyDescriptor<ResetTypeEnum> resetTypeD;
    private static NamedEnumPropertyDescriptor<IncrementTypeEnum> inctypeD;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("dataset");
        }
        return iconDescriptor;
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MElementDataset.getIconDescriptor().getIcon16();
    }

    @Override
    public String getDisplayText() {
        return MElementDataset.getIconDescriptor().getTitle();
    }

    @Override
    public String getToolTip() {
        return MElementDataset.getIconDescriptor().getToolTip();
    }

    public MElementDataset(JRElementDataset value, JasperDesign jasperDesign) {
        this.setValue(value);
        this.jasperDesign = jasperDesign;
    }

    public MElementDataset(ANode parent, JRElementDataset value, JasperDesign jasperDesign) {
        super(parent, -1);
        this.setValue(value);
        this.jasperDesign = jasperDesign;
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        resetTypeD = new NamedEnumPropertyDescriptor<ResetTypeEnum>("datasetResetType", Messages.common_reset_type, ResetTypeEnum.COLUMN, NullEnum.NOTNULL);
        resetTypeD.setDescription(Messages.MElementDataset_reset_type_description);
        desc.add((IPropertyDescriptor)resetTypeD);
        inctypeD = new NamedEnumPropertyDescriptor<IncrementTypeEnum>("incrementType", Messages.common_increment_type, IncrementTypeEnum.COLUMN, NullEnum.NOTNULL);
        inctypeD.setDescription(Messages.MElementDataset_increment_type_description);
        desc.add((IPropertyDescriptor)inctypeD);
        JRExpressionPropertyDescriptor incWhenExprD = new JRExpressionPropertyDescriptor("incrementWhenExpression", Messages.MElementDataset_increment_when_expression);
        incWhenExprD.setDescription(Messages.MElementDataset_increment_when_expression_description);
        desc.add((IPropertyDescriptor)incWhenExprD);
        incWhenExprD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#incrementWhenExpression"));
        this.resetGroupD = new RComboBoxPropertyDescriptor("resetGroup", Messages.common_reset_group, new String[]{""});
        this.resetGroupD.setDescription(Messages.MElementDataset_reset_group_description);
        desc.add((IPropertyDescriptor)this.resetGroupD);
        this.incGroupD = new RComboBoxPropertyDescriptor("incrementGroup", Messages.common_increment_group, new String[]{""});
        this.incGroupD.setDescription(Messages.MElementDataset_increment_group_description);
        desc.add((IPropertyDescriptor)this.incGroupD);
        DatasetRunPropertyDescriptor datasetRunD = new DatasetRunPropertyDescriptor("datasetRun", Messages.MElementDataset_dataset_run);
        datasetRunD.setDescription(Messages.MElementDataset_dataset_run_description);
        desc.add((IPropertyDescriptor)datasetRunD);
        datasetRunD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#datasetRun"));
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#dataset");
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        JRDataset dataset;
        super.postDescriptors(descriptors);
        JasperDesign jd = this.getJasperDesign();
        if (jd != null && this.getValue() != null && (dataset = this.getElementDataset()) != null) {
            JRGroup[] groups = dataset.getGroups();
            String[] items = new String[groups.length + 1];
            items[0] = "";
            int j = 0;
            while (j < groups.length) {
                items[j + 1] = groups[j].getName();
                ++j;
            }
            this.setGroupItems(items);
        }
    }

    public JRDataset getElementDataset() {
        JRDesignDataset dataset = ModelUtils.getDataset(this);
        if (dataset == null && this.getJasperDesign() != null) {
            dataset = this.getJasperDesign().getMainDataset();
        }
        return dataset;
    }

    public void setGroupItems(String[] items) {
        if (this.resetGroupD == null) {
            IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
            int n = iPropertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyDescriptor p = iPropertyDescriptorArray[n2];
                if (p.getId().equals("resetGroup")) {
                    ((RComboBoxPropertyDescriptor)p).setItems(items);
                } else if (p.getId().equals("incrementGroup")) {
                    ((RComboBoxPropertyDescriptor)p).setItems(items);
                }
                ++n2;
            }
        }
        if (this.resetGroupD != null) {
            this.resetGroupD.setItems(items);
        }
        if (this.incGroupD != null) {
            this.incGroupD.setItems(items);
        }
    }

    public Object getPropertyValue(Object id) {
        JRDesignElementDataset jrElement = (JRDesignElementDataset)this.getValue();
        if (jrElement == null) {
            return null;
        }
        if (id.equals("datasetResetType")) {
            return jrElement.getDatasetResetType();
        }
        if (id.equals("incrementType")) {
            return jrElement.getIncrementTypeValue();
        }
        if (id.equals("incrementWhenExpression")) {
            return ExprUtil.getExpression(jrElement.getIncrementWhenExpression());
        }
        if (id.equals("resetGroup")) {
            if (jrElement.getResetGroup() != null) {
                return jrElement.getResetGroup().getName();
            }
            return "";
        }
        if (id.equals("incrementGroup")) {
            if (jrElement.getIncrementGroup() != null) {
                return jrElement.getIncrementGroup().getName();
            }
            return "";
        }
        if (id.equals("datasetRun")) {
            JRDatasetRun j = jrElement.getDatasetRun();
            if (j == null) {
                j = new JRDesignDatasetRun();
            }
            if (this.mDatasetRun != null) {
                this.mDatasetRun.setValue(j);
            } else {
                this.mDatasetRun = new MDatasetRun(j, this.getJasperDesign());
            }
            this.setChildListener(this.mDatasetRun);
            return this.mDatasetRun;
        }
        return null;
    }

    @Override
    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignElementDataset jrElement = (JRDesignElementDataset)this.getValue();
        if (jrElement == null) {
            return;
        }
        if (id.equals("incrementType")) {
            jrElement.setIncrementType((IncrementTypeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])IncrementTypeEnum.values(), (Object)value));
        } else if (id.equals("datasetResetType")) {
            jrElement.setResetType((DatasetResetTypeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])DatasetResetTypeEnum.values(), (Object)value));
        } else if (id.equals("incrementWhenExpression")) {
            jrElement.setIncrementWhenExpression(ExprUtil.setValues(jrElement.getIncrementWhenExpression(), value));
        } else if (id.equals("incrementGroup")) {
            if (value != null && !value.equals("")) {
                JRGroup group = (JRGroup)this.getJasperDesign().getGroupsMap().get(value);
                jrElement.setIncrementGroup(group);
            }
        } else if (id.equals("resetGroup")) {
            if (value != null && !value.equals("")) {
                JRGroup group = (JRGroup)this.getJasperDesign().getGroupsMap().get(value);
                jrElement.setResetGroup(group);
            }
        } else if (id.equals("datasetRun")) {
            if (value == null) {
                jrElement.setDatasetRun(null);
            } else {
                MDatasetRun mdr = (MDatasetRun)value;
                JRDesignDatasetRun dr = mdr.getValue();
                if (dr.getDatasetName() != null) {
                    jrElement.setDatasetRun((JRDatasetRun)dr);
                } else {
                    jrElement.setDatasetRun(null);
                }
            }
        }
    }
}

