/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.dataset.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.utils.ModelUtils;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class CopyDatasetCommand
extends Command {
    private JRDesignDataset originalDataset;
    private JRDesignDataset newDataset = null;
    private JasperDesign jrDesign;

    public CopyDatasetCommand(MDataset originalDataset) {
        this.originalDataset = originalDataset.getValue();
        this.jrDesign = originalDataset.getJasperDesign();
    }

    public CopyDatasetCommand(MDataset originalDataset, JasperDesign parentDesign) {
        this.originalDataset = originalDataset.getValue();
        this.jrDesign = parentDesign != null ? parentDesign : originalDataset.getJasperDesign();
    }

    public void execute() {
        this.newDataset = (JRDesignDataset)this.originalDataset.clone();
        boolean operationAborted = false;
        try {
            while (this.jrDesign.getDatasetMap().containsKey(this.newDataset.getName()) && !operationAborted) {
                String defaultName = ModelUtils.getDefaultName(this.jrDesign.getDatasetMap(), "CopyOfDataset_");
                InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.CreateFieldCommand_field_name, Messages.CreateFieldCommand_field_name_text_dialog, defaultName, null);
                if (dlg.open() == 0) {
                    this.newDataset.setName(dlg.getValue());
                    continue;
                }
                operationAborted = true;
            }
            if (!operationAborted) {
                this.jrDesign.addDataset(this.newDataset);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public boolean canExecute() {
        return this.originalDataset != null && this.jrDesign != null;
    }

    public boolean canUndo() {
        return this.newDataset != null;
    }

    public void undo() {
        this.jrDesign.removeDataset((JRDataset)this.newDataset);
    }
}

