/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.dataset.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IDatasetContainer;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;

public class DeleteDatasetCommand
extends Command {
    private JasperDesign jrDesign;
    private JRDesignDataset jrDataset;
    private MReport destNode;
    private MDataset srcNode;
    private int elementPosition = 0;

    public DeleteDatasetCommand(MReport destNode, MDataset srcNode) {
        this.jrDesign = srcNode.getJasperDesign();
        this.jrDataset = srcNode.getValue();
        this.destNode = destNode;
        this.srcNode = srcNode;
    }

    public void execute() {
        this.elementPosition = this.jrDesign.getDatasetsList().indexOf(this.jrDataset);
        int selection = 0;
        List<IDatasetContainer> nodeUsingDataset = DeleteDatasetCommand.getDatasetUsage(this.destNode.getChildren(), this.srcNode.getPropertyValue("name").toString());
        if (nodeUsingDataset.size() > 0) {
            MessageDialog dialog = new MessageDialog(UIUtils.getShell(), Messages.DeleteDatasetCommand_title, null, Messages.DeleteDatasetCommand_message, 4, new String[]{Messages.DeleteDatasetCommand_yesOption, Messages.DeleteDatasetCommand_noOption}, 1);
            selection = dialog.open();
        }
        if (selection == 0) {
            this.jrDesign.removeDataset((JRDataset)this.jrDataset);
        }
    }

    public static List<IDatasetContainer> getDatasetUsage(List<INode> children, String datasetName) {
        ArrayList<IDatasetContainer> result = new ArrayList<IDatasetContainer>();
        if (datasetName != null) {
            for (INode child : children) {
                if (child instanceof IDatasetContainer) {
                    List<MDatasetRun> datasets = ((IDatasetContainer)((Object)child)).getDatasetRunList();
                    MDatasetRun dataset = DeleteDatasetCommand.checkContains(datasets, datasetName);
                    if (dataset == null) continue;
                    result.add((IDatasetContainer)((Object)child));
                    continue;
                }
                if (!(child instanceof IContainer)) continue;
                result.addAll(DeleteDatasetCommand.getDatasetUsage(child.getChildren(), datasetName));
            }
        }
        return result;
    }

    public static MDatasetRun checkContains(List<MDatasetRun> availabeDatasets, String searchedName) {
        if (availabeDatasets != null && !availabeDatasets.isEmpty()) {
            for (MDatasetRun actualDataset : availabeDatasets) {
                if (actualDataset == null || searchedName == null || !searchedName.equals(actualDataset.getPropertyValue("datasetName"))) continue;
                return actualDataset;
            }
        }
        return null;
    }

    public boolean canUndo() {
        return this.jrDesign != null && this.jrDataset != null;
    }

    public void undo() {
        try {
            if (this.elementPosition < 0 || this.elementPosition > this.jrDesign.getDatasetsList().size()) {
                this.jrDesign.addDataset(this.jrDataset);
            } else {
                this.jrDesign.addDataset(this.elementPosition, this.jrDataset);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

