/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.dataset.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.dataset.MDataset;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class ReorderDatasetCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignDataset jrField;
    private JasperDesign jrDesign;

    public ReorderDatasetCommand(MReport child, MDataset parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrDesign = child.getJasperDesign();
        this.jrField = parent.getValue();
    }

    public void execute() {
        try {
            this.oldIndex = this.jrDesign.getDatasetsList().indexOf(this.jrField);
            this.jrDesign.removeDataset((JRDataset)this.jrField);
            if (this.newIndex < 0 || this.newIndex > this.jrDesign.getDatasetsList().size()) {
                this.jrDesign.addDataset(this.jrField);
            } else {
                this.jrDesign.addDataset(this.newIndex, this.jrField);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        try {
            this.jrDesign.removeDataset((JRDataset)this.jrField);
            if (this.oldIndex < 0 || this.oldIndex > this.jrDesign.getDatasetsList().size()) {
                this.jrDesign.addDataset(this.jrField);
            } else {
                this.jrDesign.addDataset(this.oldIndex, this.jrField);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

