/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.dataset.descriptor;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.dataset.descriptor.DatasetRunRVPropertyPage;
import com.jaspersoft.studio.property.descriptor.returnvalue.ReturnValueContainer;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.ReturnValue;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class DatasetRunRVPropertyEditor
extends Wizard {
    private MDatasetRun mdatasetrun;
    private DatasetRunRVPropertyPage page0;

    public DatasetRunRVPropertyEditor(MDatasetRun mdatasetrun) {
        this.setWindowTitle(Messages.common_properties);
        this.setNeedsProgressMonitor(false);
        this.mdatasetrun = mdatasetrun;
    }

    public List<ReturnValue> getValue() {
        return ReturnValueContainer.convertToDatasetRun(this.page0.getValue());
    }

    public void addPages() {
        this.page0 = new DatasetRunRVPropertyPage(this.mdatasetrun);
        List returnValues = (List)this.mdatasetrun.getPropertyValue("returnValues");
        this.page0.setValue(ReturnValueContainer.convertFromDatasetRunReturn(returnValues));
        this.addPage((IWizardPage)this.page0);
    }

    private boolean hasMissingVariables() {
        JasperDesign design = this.mdatasetrun.getJasperDesign();
        JRDesignDataset mainDataset = (JRDesignDataset)design.getMainDataset();
        String subDatasetName = this.mdatasetrun.getValue().getDatasetName();
        JRDesignDataset subDataset = (JRDesignDataset)design.getDatasetMap().get(subDatasetName);
        for (ReturnValueContainer container : this.page0.getValue()) {
            String fromVariable = container.getFromVariable();
            if (!subDataset.getVariablesMap().containsKey(fromVariable)) {
                return true;
            }
            String toVariable = container.getToVariable();
            if (mainDataset.getVariablesMap().containsKey(toVariable)) continue;
            return true;
        }
        return false;
    }

    private void addMissingVariables() {
        JasperDesign design = this.mdatasetrun.getJasperDesign();
        JRDesignDataset mainDataset = (JRDesignDataset)design.getMainDataset();
        String subDatasetName = this.mdatasetrun.getValue().getDatasetName();
        JRDesignDataset subDataset = (JRDesignDataset)design.getDatasetMap().get(subDatasetName);
        for (ReturnValueContainer container : this.page0.getValue()) {
            String fromVariable = container.getFromVariable();
            if (!subDataset.getVariablesMap().containsKey(fromVariable)) {
                JRDesignVariable newVariable = new JRDesignVariable();
                newVariable.setName(fromVariable);
                try {
                    subDataset.addVariable(newVariable);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
            String toVariable = container.getToVariable();
            if (mainDataset.getVariablesMap().containsKey(toVariable)) continue;
            JRDesignVariable newVariable = new JRDesignVariable();
            newVariable.setName(toVariable);
            try {
                mainDataset.addVariable(newVariable);
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean performFinish() {
        boolean create_variables;
        if (this.hasMissingVariables() && (create_variables = UIUtils.showConfirmation((String)Messages.DatasetRunRVPropertyEditor_missingTitle, (String)Messages.DatasetRunRVPropertyEditor_missingDescription))) {
            this.addMissingVariables();
        }
        return true;
    }
}

