/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.dataset.descriptor;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.property.descriptor.returnvalue.EditableInputReturnValueDialog;
import com.jaspersoft.studio.property.descriptor.returnvalue.RVPropertyPage;
import com.jaspersoft.studio.property.descriptor.returnvalue.ReturnValueContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.ReturnValue;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JasperDesign;

public class DatasetRunRVPropertyPage
extends RVPropertyPage {
    private JRDesignDatasetRun datasetRun;

    public DatasetRunRVPropertyPage(MDatasetRun datasetRun) {
        super("datasetrunproperties", datasetRun != null ? datasetRun.getJasperDesign() : null);
        if (datasetRun != null) {
            this.datasetRun = datasetRun.getValue();
        }
        this.setTitle(Messages.DatasetRunRVPropertyPage_pageTitle);
        this.setDescription(Messages.DatasetRunRVPropertyPage_pageDescription);
    }

    public DatasetRunRVPropertyPage(JRDesignDatasetRun datasetRun, JasperDesign design) {
        super("datasetrunproperties", design);
        this.datasetRun = datasetRun;
        this.setTitle(Messages.DatasetRunRVPropertyPage_pageTitle);
        this.setDescription(Messages.DatasetRunRVPropertyPage_pageDescription);
    }

    @Override
    public JRVariable[] getDatasetVariables() {
        if (this.datasetRun == null) {
            return new JRVariable[0];
        }
        String datasetName = this.datasetRun.getDatasetName();
        JRDataset dataset = (JRDataset)this.design.getDatasetMap().get(datasetName);
        if (dataset != null) {
            return dataset.getVariables();
        }
        return new JRVariable[0];
    }

    @Override
    protected void openAddDialog() {
        ReturnValueContainer container = new ReturnValueContainer();
        HashSet<String> invalidTo = new HashSet<String>();
        HashSet<String> invalidFrom = new HashSet<String>();
        for (ReturnValueContainer definedValues : this.getValue()) {
            invalidTo.add(definedValues.getToVariable());
            invalidFrom.add(definedValues.getFromVariable());
        }
        EditableInputReturnValueDialog inputDialog = new EditableInputReturnValueDialog(this.getShell(), container, this.getToVariablesNames(), this.getFromVariablesNames(), invalidTo, invalidFrom);
        if (inputDialog.open() == 0) {
            this.addElemenet(container);
        }
    }

    @Override
    protected void openEditDialog(ReturnValueContainer edited) {
        ReturnValueContainer result = edited.clone();
        String[] toVariables = this.getVariablesPlusElement(this.getToVariablesNames(), edited.getToVariable());
        String[] fromVariables = this.getVariablesPlusElement(this.getFromVariablesNames(), edited.getFromVariable());
        HashSet<String> invalidTo = new HashSet<String>();
        HashSet<String> invalidFrom = new HashSet<String>();
        for (ReturnValueContainer definedValues : this.getValue()) {
            if (edited == definedValues) continue;
            invalidTo.add(definedValues.getToVariable());
            invalidFrom.add(definedValues.getFromVariable());
        }
        EditableInputReturnValueDialog inputDialog = new EditableInputReturnValueDialog(this.getShell(), result, toVariables, fromVariables, invalidTo, invalidFrom);
        if (inputDialog.open() == 0) {
            this.editElement(edited, result);
        }
    }

    @Override
    protected void updateButtonsStatus() {
        if (this.design != null) {
            JRDesignDataset mainDataset = (JRDesignDataset)this.design.getMainDataset();
            String datasetName = this.datasetRun.getDatasetName();
            JRDesignDataset subDataset = (JRDesignDataset)this.design.getDatasetMap().get(datasetName);
            for (ReturnValueContainer container : this.getValue()) {
                String fromVariable = container.getFromVariable();
                if (subDataset != null && !subDataset.getVariablesMap().containsKey(fromVariable)) {
                    this.setMessage("Some From variables are missing on the subdataset and will be possible to create them at the end of the wizard");
                    return;
                }
                String toVariable = container.getToVariable();
                if (mainDataset.getVariablesMap().containsKey(toVariable)) continue;
                this.setMessage("Some To variables are missing on the main dataset and will be possible to create them at the end of the wizard");
                return;
            }
        }
        this.setMessage(null);
    }

    public void setDatasetRun(JRDesignDatasetRun datasetRun, JasperDesign design) {
        this.design = design;
        this.datasetRun = datasetRun;
        this.updateDatasetRunReturnValues();
    }

    private void updateDatasetRunReturnValues() {
        if (this.datasetRun != null) {
            List returnValues = this.datasetRun.getReturnValuesList();
            this.setValue(ReturnValueContainer.convertFromDatasetRunReturn(returnValues));
        }
    }

    public void saveValuesIntoDataset() {
        if (this.datasetRun != null) {
            List<ReturnValueContainer> actaulValues = this.getValue();
            List<ReturnValue> newValues = ReturnValueContainer.convertToDatasetRun(actaulValues);
            ArrayList oldValues = new ArrayList(this.datasetRun.getReturnValuesList());
            for (ReturnValue oldValue : oldValues) {
                this.datasetRun.removeReturnValue(oldValue);
            }
            for (ReturnValue newValue : newValues) {
                this.datasetRun.addReturnValue(newValue);
            }
        }
    }
}

