/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.datasource.jdbc;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.datasource.AMDatasource;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import java.sql.Connection;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MJDBCDataSource
extends AMDatasource {
    private static IIconDescriptor iconDescriptor;
    public static final long serialVersionUID = 10200L;
    private static IPropertyDescriptor[] descriptors;
    public static final String PROPERTY_DRIVERCLASS = "PROPERTY_DRIVERCLASS";
    private String driverclass;
    public static final String PROPERTY_JDBC_URL = "PROPERTY_JDBC_URL";
    private String jdbcURL;
    public static final String PROPERTY_USERNAME = "PROPERTY_USERNAME";
    private String username;
    public static final String PROPERTY_PASSWORD = "PROPERTY_PASSWORD";
    private String password;
    public static final String PROPERTY_JAR = "PROPERTY_JAR";
    private String jar;
    public static final String PROPERTY_CONNECTION = "PROPERTY_CONNECTION";
    private Connection connection;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("datasourceJDBC");
        }
        return iconDescriptor;
    }

    public MJDBCDataSource() {
        super(null, -1);
    }

    public MJDBCDataSource(ANode parent, int index) {
        super(parent, index);
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MJDBCDataSource.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MJDBCDataSource.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        NTextPropertyDescriptor driverClassD = new NTextPropertyDescriptor(PROPERTY_DRIVERCLASS, Messages.common_driver_class);
        desc.add((IPropertyDescriptor)driverClassD);
        NTextPropertyDescriptor jdbcURLD = new NTextPropertyDescriptor(PROPERTY_JDBC_URL, Messages.common_jdbc_url);
        desc.add((IPropertyDescriptor)jdbcURLD);
        NTextPropertyDescriptor usernameD = new NTextPropertyDescriptor(PROPERTY_USERNAME, Messages.common_username);
        desc.add((IPropertyDescriptor)usernameD);
        NTextPropertyDescriptor passwordD = new NTextPropertyDescriptor(PROPERTY_PASSWORD, Messages.common_password);
        desc.add((IPropertyDescriptor)passwordD);
        NTextPropertyDescriptor jarD = new NTextPropertyDescriptor(PROPERTY_JAR, Messages.MJDBCDataSource_classpath);
        desc.add((IPropertyDescriptor)jarD);
        NTextPropertyDescriptor connectionD = new NTextPropertyDescriptor(PROPERTY_CONNECTION, Messages.common_connection);
        desc.add((IPropertyDescriptor)connectionD);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(PROPERTY_DRIVERCLASS)) {
            return this.driverclass;
        }
        if (id.equals(PROPERTY_JAR)) {
            return this.jar;
        }
        if (id.equals(PROPERTY_JDBC_URL)) {
            return this.jdbcURL;
        }
        if (id.equals(PROPERTY_USERNAME)) {
            return this.username;
        }
        if (id.equals(PROPERTY_PASSWORD)) {
            return this.password;
        }
        if (id.equals(PROPERTY_CONNECTION)) {
            return this.connection;
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (id.equals(PROPERTY_DRIVERCLASS)) {
            this.driverclass = (String)value;
        } else if (id.equals(PROPERTY_JDBC_URL)) {
            this.jdbcURL = (String)value;
        } else if (id.equals(PROPERTY_USERNAME)) {
            this.username = (String)value;
        } else if (id.equals(PROPERTY_JAR)) {
            this.jar = (String)value;
        } else if (id.equals(PROPERTY_PASSWORD)) {
            this.password = (String)value;
        } else if (id.equals(PROPERTY_CONNECTION)) {
            this.connection = (Connection)value;
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

