/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.group.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IDatasetContainer;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.dataset.command.DeleteDatasetCommand;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.property.IPostSetValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignDatasetParameter;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;

public class PostSetGroupName
implements IPostSetValue {
    @Override
    public Command postSetValue(IPropertySource target, Object prop, Object newValue, Object oldValue) {
        MParameter mprm;
        JSSCompoundCommand c = new JSSCompoundCommand(null);
        if (target instanceof MParameter && prop.equals("name") && (mprm = (MParameter)target).getParent() != null && mprm.getParent().getParent() != null) {
            ANode parentElement = mprm.getParent().getParent();
            c.setReferenceNodeIfNull(parentElement);
            if (parentElement instanceof MDataset) {
                MDataset parentDataset = (MDataset)parentElement;
                List<IDatasetContainer> references = DeleteDatasetCommand.getDatasetUsage(parentDataset.getRoot().getChildren(), parentDataset.getPropertyActualValue("name").toString());
                for (IDatasetContainer datasetRun : references) {
                    List<MDatasetRun> datasetList = datasetRun.getDatasetRunList();
                    for (MDatasetRun actualDataset : datasetList) {
                        c.add(new SetParameterName(actualDataset, oldValue.toString(), newValue.toString()));
                    }
                }
            }
        }
        return c;
    }

    private class SetParameterName
    extends Command {
        private MDatasetRun element;
        private String oldName;
        private String newName;
        private boolean parameterFound = false;

        public SetParameterName(MDatasetRun element, String oldName, String newName) {
            this.element = element;
            this.oldName = oldName;
            this.newName = newName;
        }

        public void execute() {
            JRDatasetParameter[] parameters = (JRDatasetParameter[])this.element.getPropertyValue("parameters");
            ArrayList<JRDatasetParameter> lst = new ArrayList<JRDatasetParameter>(Arrays.asList(parameters));
            for (JRDatasetParameter param : lst) {
                if (param.getName() == null || !param.getName().equals(this.oldName)) continue;
                try {
                    this.element.getValue().removeParameter(param);
                    ((JRDesignDatasetParameter)param).setName(this.newName);
                    this.element.getValue().addParameter(param);
                    this.parameterFound = true;
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                break;
            }
        }

        public void undo() {
            if (this.parameterFound) {
                JRDatasetParameter[] parameters = (JRDatasetParameter[])this.element.getPropertyValue("parameters");
                ArrayList<JRDatasetParameter> lst = new ArrayList<JRDatasetParameter>(Arrays.asList(parameters));
                for (JRDatasetParameter param : lst) {
                    if (param.getName() == null || !param.getName().equals(this.newName)) continue;
                    try {
                        this.element.getValue().removeParameter(param);
                        ((JRDesignDatasetParameter)param).setName(this.oldName);
                        this.element.getValue().addParameter(param);
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                    this.parameterFound = false;
                    break;
                }
            }
        }
    }
}

