/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.scriptlet.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.scriptlet.MScriptlet;
import com.jaspersoft.studio.model.scriptlet.MScriptlets;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignScriptlet;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class CreateScriptletCommand
extends Command {
    protected JRDesignScriptlet jrScriptlet;
    private JRDesignDataset jrDataset;
    private int index;

    public CreateScriptletCommand(MScriptlets destNode, MScriptlet srcNode, int index) {
        this.jrDataset = (JRDesignDataset)destNode.getValue();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrScriptlet = (JRDesignScriptlet)srcNode.getValue();
        }
    }

    public void execute() {
        block6: {
            if (this.jrScriptlet == null) {
                this.jrScriptlet = MScriptlet.createJRScriptlet(this.jrDataset);
            }
            if (this.jrScriptlet != null) {
                try {
                    if (this.index >= 0 && this.index < this.jrDataset.getScriptletsList().size()) {
                        this.jrDataset.addScriptlet(this.index, (JRScriptlet)this.jrScriptlet);
                    } else {
                        this.jrDataset.addScriptlet((JRScriptlet)this.jrScriptlet);
                    }
                    SelectionHelper.setOutlineSelection(this.jrScriptlet);
                }
                catch (JRException e) {
                    e.printStackTrace();
                    if (!e.getMessage().startsWith("Duplicate declaration")) break block6;
                    String defaultName = ModelUtils.getDefaultName(this.jrDataset.getScriptletsMap(), "CopyOFScriptlet_");
                    InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.CreateScriptletCommand_scriptlet_name, Messages.CreateScriptletCommand_scriptlet_name_dialog_text, defaultName, null);
                    if (dlg.open() != 0) break block6;
                    this.jrScriptlet.setName(dlg.getValue());
                    this.execute();
                }
            }
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.jrDataset.removeScriptlet((JRScriptlet)this.jrScriptlet);
    }
}

