/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.scriptlet.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.scriptlet.MScriptlet;
import com.jaspersoft.studio.model.scriptlet.MScriptlets;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignScriptlet;
import org.eclipse.gef.commands.Command;

public class ReorderScriptletCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignScriptlet jrScriptlet;
    private JRDesignDataset jrDataset;

    public ReorderScriptletCommand(MScriptlet child, MScriptlets parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrDataset = (JRDesignDataset)parent.getValue();
        this.jrScriptlet = (JRDesignScriptlet)child.getValue();
    }

    public void execute() {
        if (this.jrScriptlet.getName().equals("REPORT_SCRIPTLET")) {
            return;
        }
        this.oldIndex = this.jrDataset.getScriptletsList().indexOf(this.jrScriptlet);
        try {
            this.jrDataset.removeScriptlet((JRScriptlet)this.jrScriptlet);
            if (this.newIndex < 0 || this.newIndex > this.jrDataset.getScriptletsList().size()) {
                this.jrDataset.addScriptlet((JRScriptlet)this.jrScriptlet);
            } else {
                this.jrDataset.addScriptlet(this.newIndex, (JRScriptlet)this.jrScriptlet);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        try {
            this.jrDataset.removeScriptlet((JRScriptlet)this.jrScriptlet);
            if (this.oldIndex < 0 || this.oldIndex > this.jrDataset.getScriptletsList().size()) {
                this.jrDataset.addScriptlet((JRScriptlet)this.jrScriptlet);
            } else {
                this.jrDataset.addScriptlet(this.oldIndex, (JRScriptlet)this.jrScriptlet);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

