/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.sortfield.command;

import com.jaspersoft.studio.model.sortfield.MSortField;
import com.jaspersoft.studio.model.sortfield.MSortFields;
import com.jaspersoft.studio.model.sortfield.command.wizard.SortFieldWizard;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class CreateSortFieldCommand
extends Command {
    private JRDesignSortField jrField;
    private JRDesignDataset jrDataSet;
    private int index;

    public CreateSortFieldCommand(MSortFields destNode, MSortField srcNode, int index) {
        this.jrDataSet = (JRDesignDataset)destNode.getValue();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrField = (JRDesignSortField)srcNode.getValue();
        }
    }

    public CreateSortFieldCommand(JRDesignDataset destNode, JRDesignSortField srcNode, int index) {
        this.jrDataSet = destNode;
        this.index = index;
        this.jrField = srcNode;
    }

    public void execute() {
        this.createObject();
        if (this.jrField != null) {
            if (this.index < 0) {
                this.index = this.jrDataSet.getSortFieldsList().size();
            }
            try {
                if (this.index < 0 || this.index > this.jrDataSet.getSortFieldsList().size()) {
                    this.jrDataSet.addSortField((JRSortField)this.jrField);
                } else {
                    this.jrDataSet.addSortField(this.index, (JRSortField)this.jrField);
                }
                SelectionHelper.setOutlineSelection(this.jrField);
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
    }

    private void createObject() {
        if (this.jrField == null) {
            this.jrField = MSortField.createJRSortField(this.jrDataSet);
            SortFieldWizard wizard = new SortFieldWizard();
            wizard.init(this.jrDataSet, this.jrField);
            WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
            dialog.create();
            if (dialog.open() != 0) {
                this.jrField = null;
                return;
            }
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.jrField != null) {
            this.jrDataSet.removeSortField((JRSortField)this.jrField);
        }
    }
}

