/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.sortfield.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.sortfield.MSortField;
import com.jaspersoft.studio.model.sortfield.MSortFields;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import org.eclipse.gef.commands.Command;

public class ReorderSortFieldCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignSortField jrField;
    private JRDesignDataset jrDataset;

    public ReorderSortFieldCommand(MSortField child, MSortFields parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrDataset = (JRDesignDataset)parent.getValue();
        this.jrField = (JRDesignSortField)child.getValue();
    }

    public void execute() {
        try {
            this.oldIndex = this.jrDataset.getSortFieldsList().indexOf(this.jrField);
            this.jrDataset.removeSortField((JRSortField)this.jrField);
            if (this.newIndex < 0 || this.newIndex > this.jrDataset.getSortFieldsList().size()) {
                this.jrDataset.addSortField((JRSortField)this.jrField);
            } else {
                this.jrDataset.addSortField(this.newIndex, (JRSortField)this.jrField);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        try {
            this.jrDataset.removeSortField((JRSortField)this.jrField);
            if (this.oldIndex < 0 || this.oldIndex > this.jrDataset.getSortFieldsList().size()) {
                this.jrDataset.addSortField((JRSortField)this.jrField);
            } else {
                this.jrDataset.addSortField(this.oldIndex, (JRSortField)this.jrField);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

