/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style;

import com.jaspersoft.studio.ExternalStylesManager;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class MConditionalStyle
extends MStyle
implements IPropertySource {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("style");
        }
        return iconDescriptor;
    }

    public MConditionalStyle() {
    }

    public MConditionalStyle(ANode parent, JRDesignConditionalStyle jrstyle, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrstyle);
    }

    @Override
    public String getDisplayText() {
        JRExpression conditionExpression = ((JRDesignConditionalStyle)this.getValue()).getConditionExpression();
        if (conditionExpression != null) {
            return conditionExpression.getText();
        }
        return "<NO CONDITION SET>";
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MConditionalStyle.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MConditionalStyle.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        HashSet<IPropertyDescriptor> toRemove = new HashSet<IPropertyDescriptor>();
        for (IPropertyDescriptor d : desc) {
            if (d.getId().equals("name")) {
                toRemove.add(d);
                continue;
            }
            if (!d.getId().equals("isDefault")) continue;
            toRemove.add(d);
        }
        desc.removeAll(toRemove);
        JRExpressionPropertyDescriptor conditionalExpressionD = new JRExpressionPropertyDescriptor("conditionExpression", Messages.MConditionalStyle_conditional_expression);
        conditionalExpressionD.setCategory(Messages.MConditionalStyle_properties_category);
        conditionalExpressionD.setDescription(Messages.MConditionalStyle_conditional_expression_description);
        desc.add((IPropertyDescriptor)conditionalExpressionD);
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
        IPropertyDescriptor[] iPropertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor desc = iPropertyDescriptorArray[n2];
            if ("conditionExpression".equals(desc.getId())) {
                ((JRExpressionPropertyDescriptor)desc).setExpressionContext(ExpressionEditorSupportUtil.getReportExtendedExpressionContext());
                return;
            }
            ++n2;
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignConditionalStyle jrstyle = (JRDesignConditionalStyle)this.getValue();
        if (id.equals("conditionExpression")) {
            return ExprUtil.getExpression(jrstyle.getConditionExpression());
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (this.isEditable()) {
            JRDesignConditionalStyle jrstyle = (JRDesignConditionalStyle)this.getValue();
            if (id.equals("conditionExpression")) {
                jrstyle.setConditionExpression(ExprUtil.setValues(jrstyle.getConditionExpression(), value));
            } else if (id.equals("parentStyle")) {
                if (!Misc.isNullOrEmpty((String)((String)value))) {
                    JRStyle style = (JRStyle)this.getJasperDesign().getStylesMap().get(value);
                    if (style != null) {
                        jrstyle.setParentStyle(style);
                    } else {
                        jrstyle.setParentStyle(ExternalStylesManager.getExternalStyle((String)value, this.getJasperConfiguration()));
                    }
                } else {
                    jrstyle.setParentStyle(null);
                }
            } else {
                super.setPropertyValue(id, value);
            }
        }
    }

    @Override
    protected boolean isDependencyStyle() {
        return false;
    }

    public static JRDesignConditionalStyle createJRStyle() {
        JRDesignConditionalStyle jrDesignConditionalStyle = new JRDesignConditionalStyle();
        return jrDesignConditionalStyle;
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        MStyle parentStyle;
        if (parent instanceof MStyle && (parentStyle = (MStyle)parent).getParent() instanceof MStyles) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.NOT_COPYABLE;
    }
}

