/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style;

import com.jaspersoft.studio.ExternalStylesManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.model.style.StyleTemplateFactory;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRTempalteStyleExpressionPropertyDescriptor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class MStyleTemplate
extends APropertyNode
implements IPropertySource,
ICopyable {
    public static final String PATH_ANNOTATION = "@path";
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static ImageDescriptor styleNotFoundImage;
    private static IPropertyDescriptor[] descriptors;
    private static final int UPDATE_DELAY = 500;
    private UpdateStyleJob updateStyleJob;
    public static final String FORCE_UPDATE_CHILDREN = "forceUpdateChildren";

    static {
        styleNotFoundImage = JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/no_style_error.png");
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        JRTempalteStyleExpressionPropertyDescriptor sourceExpression = new JRTempalteStyleExpressionPropertyDescriptor("sourceExpression", Messages.MStyleTemplate_source_expression);
        sourceExpression.setDescription(Messages.MStyleTemplate_source_expression_description);
        desc.add((IPropertyDescriptor)sourceExpression);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#template");
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("styletemplate");
        }
        return iconDescriptor;
    }

    public MStyleTemplate() {
    }

    public MStyleTemplate(ANode parent, JRReportTemplate jrstyle, int newIndex) {
        super(parent, newIndex);
        super.setValue(jrstyle);
        this.setEditable(false);
    }

    @Override
    public String getDisplayText() {
        JRDesignReportTemplate jt = (JRDesignReportTemplate)this.getValue();
        if (jt != null && jt.getSourceExpression() != null && jt.getSourceExpression().getText() != null) {
            String expString = jt.getSourceExpression().getText();
            int indexStartComments = expString.indexOf("/*");
            int indexEndComments = indexStartComments != -1 ? expString.indexOf("*/", indexStartComments) : -1;
            while (indexStartComments != -1 && indexEndComments != -1) {
                expString = String.valueOf(expString.substring(0, indexStartComments)) + expString.substring(indexEndComments + 2);
                indexStartComments = (expString = expString.trim()).indexOf("/*");
                int n = indexEndComments = indexStartComments != -1 ? expString.indexOf("*/", indexStartComments) : -1;
            }
            return String.valueOf(MStyleTemplate.getIconDescriptor().getTitle()) + "(" + expString + ")";
        }
        return MStyleTemplate.getIconDescriptor().getTitle();
    }

    @Override
    public ImageDescriptor getImagePath() {
        JRDesignReportTemplate jt = (JRDesignReportTemplate)this.getValue();
        if (jt != null && jt.getSourceExpression() != null && jt.getSourceExpression().getText() != null && (ExternalStylesManager.isNotValuable(this) || !ExternalStylesManager.isTemplateValid(this))) {
            return styleNotFoundImage;
        }
        return MStyleTemplate.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        JRDesignReportTemplate jt = (JRDesignReportTemplate)this.getValue();
        if (jt != null && jt.getSourceExpression() != null && jt.getSourceExpression().getText() != null && ExternalStylesManager.isNotValuable(this)) {
            return "The resource can not be found, fix the expression and reload the style to use it";
        }
        return MStyleTemplate.getIconDescriptor().getToolTip();
    }

    public Object getPropertyValue(Object id) {
        JRDesignReportTemplate jrTemplate = (JRDesignReportTemplate)this.getValue();
        if (id.equals("sourceExpression")) {
            return ExprUtil.getExpression(jrTemplate.getSourceExpression());
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignReportTemplate jrTemplate = (JRDesignReportTemplate)this.getValue();
        if (id.equals("sourceExpression")) {
            ExternalStylesManager.removeCachedStyle(this.getJasperConfiguration(), (JRReportTemplate)this.getValue());
            jrTemplate.setSourceExpression(ExprUtil.setValues(jrTemplate.getSourceExpression(), value));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("sourceExpression")) {
            this.performUpdate();
        } else if (evt.getPropertyName().equals(FORCE_UPDATE_CHILDREN)) {
            this.refreshChildren();
        }
        super.propertyChange(evt);
    }

    private void fireChildrenChangeEvent() {
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                PropertyChangeEvent event = new PropertyChangeEvent(MStyleTemplate.this.getActualStyle(), "refresh", null, null);
                MStyleTemplate.this.getPropertyChangeSupport().firePropertyChange(event);
            }
        });
    }

    public boolean refreshChildren() {
        JasperReportsConfiguration jConf = this.getJasperConfiguration();
        if (jConf != null) {
            IFile project = (IFile)jConf.get("ifile");
            JRDesignReportTemplate jrTemplate = (JRDesignReportTemplate)this.getValue();
            for (INode child : new ArrayList<INode>(this.getChildren())) {
                ((ANode)child).setParent(null, -1);
            }
            this.getChildren().clear();
            String path = ExternalStylesManager.evaluateStyleExpression((JRReportTemplate)jrTemplate, project, jConf);
            if (path != null) {
                boolean result = StyleTemplateFactory.createTemplateReference(this, path, -1, new HashSet<String>(), false);
                this.fireChildrenChangeEvent();
                return result;
            }
        }
        return false;
    }

    private MStyleTemplate getActualStyle() {
        return this;
    }

    private void performUpdate() {
        if (this.updateStyleJob == null) {
            this.updateStyleJob = new UpdateStyleJob();
        }
        this.updateStyleJob.cancel();
        this.updateStyleJob.schedule(500L);
    }

    public static JRDesignReportTemplate createJRTemplate() {
        JRDesignReportTemplate jrDesignReportTemplate = new JRDesignReportTemplate();
        return jrDesignReportTemplate;
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MStyles) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    @Override
    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.performUpdate();
    }

    private class UpdateStyleJob
    extends Job {
        public UpdateStyleJob() {
            super("RefreshStyles");
            this.setSystem(true);
        }

        public IStatus run(final IProgressMonitor monitor) {
            UIUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    JasperReportsConfiguration jConf = MStyleTemplate.this.getJasperConfiguration();
                    if (MStyleTemplate.this.getParent() != null && MStyleTemplate.this.getValue() != null && jConf != null) {
                        MStyleTemplate.this.refreshChildren();
                    }
                    monitor.done();
                }
            });
            return Status.OK_STATUS;
        }
    }
}

