/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style.command;

import com.jaspersoft.studio.ExternalStylesManager;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class DeleteStyleTemplateCommand
extends Command {
    private JasperDesign jrDesign;
    private JRDesignReportTemplate jrTemplate;
    private int elementPosition = 0;
    private JasperReportsConfiguration jConfig;

    public DeleteStyleTemplateCommand(MStyles destNode, MStyleTemplate srcNode) {
        this.jrDesign = srcNode.getJasperDesign();
        this.jrTemplate = (JRDesignReportTemplate)srcNode.getValue();
        this.jConfig = destNode.getJasperConfiguration();
    }

    public void execute() {
        this.elementPosition = this.jrDesign.getTemplatesList().indexOf(this.jrTemplate);
        this.jrDesign.removeTemplate((JRReportTemplate)this.jrTemplate);
        ExternalStylesManager.removeCachedStyle(this.jConfig, (JRReportTemplate)this.jrTemplate);
        this.jConfig.refreshCachedStyles();
    }

    public boolean canUndo() {
        return this.jrDesign != null && this.jrTemplate != null;
    }

    public void undo() {
        if (this.elementPosition < 0 || this.elementPosition > this.jrDesign.getTemplatesList().size()) {
            this.jrDesign.addTemplate((JRReportTemplate)this.jrTemplate);
        } else {
            this.jrDesign.addTemplate(this.elementPosition, (JRReportTemplate)this.jrTemplate);
        }
        this.jConfig.refreshCachedStyles();
    }
}

