/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.model.style.MStyles;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class ReorderStyleTemplateCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignReportTemplate jrTemplate;
    private JasperDesign jrDesign;

    public ReorderStyleTemplateCommand(MStyleTemplate child, MStyles parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrDesign = parent.getJasperDesign();
        this.jrTemplate = (JRDesignReportTemplate)child.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrDesign.getTemplatesList().indexOf(this.jrTemplate);
        this.jrDesign.removeTemplate((JRReportTemplate)this.jrTemplate);
        if (this.newIndex < 0 || this.newIndex > this.jrDesign.getTemplatesList().size()) {
            this.jrDesign.addTemplate((JRReportTemplate)this.jrTemplate);
        } else {
            this.jrDesign.addTemplate(this.newIndex, (JRReportTemplate)this.jrTemplate);
        }
    }

    public void undo() {
        this.jrDesign.removeTemplate((JRReportTemplate)this.jrTemplate);
        if (this.oldIndex < 0 || this.oldIndex > this.jrDesign.getTemplatesList().size()) {
            this.jrDesign.addTemplate((JRReportTemplate)this.jrTemplate);
        } else {
            this.jrDesign.addTemplate(this.oldIndex, (JRReportTemplate)this.jrTemplate);
        }
    }
}

