/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style.command;

import com.jaspersoft.studio.model.style.MStyle;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.eclipse.gef.commands.Command;

public class ResetStyleCommand
extends Command {
    private MStyle resettedStyle;
    private JRDesignStyle backupValues;

    public ResetStyleCommand(MStyle resettedStyle) {
        this.resettedStyle = resettedStyle;
    }

    private void copyStyleAttributes(JRStyle source, JRDesignStyle dest) {
        dest.setBackcolor(source.getOwnBackcolor());
        dest.setBlankWhenNull(source.isOwnBlankWhenNull());
        dest.setBold(source.isOwnBold());
        dest.setDefault(source.isDefault());
        dest.setFill(source.getOwnFillValue());
        dest.setFontName(source.getOwnFontName());
        dest.setFontSize(source.getOwnFontsize());
        dest.setForecolor(source.getOwnForecolor());
        dest.setHorizontalTextAlign(source.getOwnHorizontalTextAlign());
        dest.setHorizontalImageAlign(source.getOwnHorizontalImageAlign());
        dest.setItalic(source.isOwnItalic());
        dest.setMarkup(source.getOwnMarkup());
        dest.setMode(source.getOwnModeValue());
        dest.setParentStyle(source.getStyle());
        dest.setParentStyleNameReference(source.getStyleNameReference());
        dest.setPattern(source.getOwnPattern());
        dest.setPdfEmbedded(source.isOwnPdfEmbedded());
        dest.setPdfEncoding(source.getOwnPdfEncoding());
        dest.setPdfFontName(source.getOwnPdfFontName());
        dest.setRadius(source.getOwnRadius());
        dest.setRotation(source.getOwnRotationValue());
        dest.setScaleImage(source.getOwnScaleImageValue());
        dest.setStrikeThrough(source.isOwnStrikeThrough());
        dest.setUnderline(source.isOwnUnderline());
        dest.setVerticalTextAlign(source.getOwnVerticalTextAlign());
        dest.setVerticalImageAlign(source.getOwnVerticalImageAlign());
        JRLineBox destLineBox = dest.getLineBox();
        JRLineBox sourceLineBox = source.getLineBox();
        if (destLineBox == null || sourceLineBox == null) {
            return;
        }
        destLineBox.setRightPadding(sourceLineBox.getOwnRightPadding());
        destLineBox.setLeftPadding(sourceLineBox.getOwnLeftPadding());
        destLineBox.setTopPadding(sourceLineBox.getOwnTopPadding());
        destLineBox.setBottomPadding(sourceLineBox.getOwnBottomPadding());
        destLineBox.setPadding(sourceLineBox.getOwnPadding());
        this.copyPenAttributrs((JRPen)sourceLineBox.getPen(), (JRPen)destLineBox.getPen());
        this.copyPenAttributrs((JRPen)sourceLineBox.getLeftPen(), (JRPen)destLineBox.getLeftPen());
        this.copyPenAttributrs((JRPen)sourceLineBox.getRightPen(), (JRPen)destLineBox.getRightPen());
        this.copyPenAttributrs((JRPen)sourceLineBox.getTopPen(), (JRPen)destLineBox.getTopPen());
        this.copyPenAttributrs((JRPen)sourceLineBox.getBottomPen(), (JRPen)destLineBox.getBottomPen());
        JRPen destLinePen = dest.getLinePen();
        JRPen sourceLinePen = source.getLinePen();
        this.copyPenAttributrs(sourceLinePen, destLinePen);
    }

    private void copyPenAttributrs(JRPen source, JRPen dest) {
        if (source == null || dest == null) {
            return;
        }
        dest.setLineColor(source.getOwnLineColor());
        dest.setLineStyle(source.getOwnLineStyleValue());
        dest.setLineWidth(source.getOwnLineWidth());
    }

    public void execute() {
        this.backupValues = new JRDesignStyle();
        this.copyStyleAttributes(this.resettedStyle.getValue(), this.backupValues);
        this.copyStyleAttributes((JRStyle)new JRDesignStyle(), (JRDesignStyle)this.resettedStyle.getValue());
    }

    public boolean canUndo() {
        return this.backupValues != null && this.canExecute();
    }

    public boolean canExecute() {
        return this.resettedStyle != null && this.resettedStyle.getValue() != null;
    }

    public void undo() {
        this.copyStyleAttributes((JRStyle)this.backupValues, (JRDesignStyle)this.resettedStyle.getValue());
        this.backupValues = null;
    }
}

