/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style.command;

import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.eclipse.gef.commands.Command;

public class UpdateStyleCommand
extends Command {
    private JRDesignStyle sourceStyle;
    private JRDesignStyle targetStyle;
    private JRDesignStyle targetStyleCopy = null;

    public UpdateStyleCommand(JRDesignStyle sourceStyle, JRDesignStyle targetStyle) {
        this.sourceStyle = sourceStyle;
        this.targetStyle = targetStyle;
    }

    public boolean canExecute() {
        return this.sourceStyle != null && this.targetStyle != null;
    }

    protected void copyParentStyleAttributes(JRDesignStyle targetStyle, JRDesignStyle sourceStyle) {
        targetStyle.setDefault(sourceStyle.isDefault());
        targetStyle.setParentStyle(sourceStyle.getStyle());
        targetStyle.setParentStyleNameReference(sourceStyle.getStyleNameReference());
        int index = 0;
        for (JRConditionalStyle condStyle : sourceStyle.getConditionalStyleList()) {
            if (targetStyle.getConditionalStyleList().size() > index) {
                this.copyAttributes((JRBaseStyle)targetStyle.getConditionalStyleList().get(index), (JRBaseStyle)condStyle);
            }
            ++index;
        }
    }

    protected void copyAttributes(JRBaseStyle targetStyle, JRBaseStyle sourceStyle) {
        targetStyle.setBackcolor(sourceStyle.getOwnBackcolor());
        targetStyle.setBlankWhenNull(sourceStyle.isOwnBlankWhenNull());
        targetStyle.setBold(sourceStyle.isOwnBold());
        targetStyle.setItalic(sourceStyle.isOwnItalic());
        targetStyle.setFill(sourceStyle.getOwnFillValue());
        targetStyle.setFontName(sourceStyle.getOwnFontName());
        targetStyle.setFontSize(sourceStyle.getOwnFontsize());
        targetStyle.setForecolor(sourceStyle.getOwnForecolor());
        targetStyle.setHorizontalImageAlign(sourceStyle.getOwnHorizontalImageAlign());
        targetStyle.setHorizontalTextAlign(sourceStyle.getOwnHorizontalTextAlign());
        targetStyle.setMarkup(sourceStyle.getOwnMarkup());
        targetStyle.setMode(sourceStyle.getOwnModeValue());
        targetStyle.setPattern(sourceStyle.getOwnPattern());
        targetStyle.setPdfEmbedded(sourceStyle.isOwnPdfEmbedded());
        targetStyle.setPdfEncoding(sourceStyle.getOwnPdfEncoding());
        targetStyle.setPdfFontName(sourceStyle.getOwnPdfFontName());
        targetStyle.setRadius(sourceStyle.getOwnRadius());
        targetStyle.setRotation(sourceStyle.getOwnRotationValue());
        targetStyle.setScaleImage(sourceStyle.getOwnScaleImageValue());
        targetStyle.setStrikeThrough(sourceStyle.isOwnStrikeThrough());
        targetStyle.setUnderline(sourceStyle.isOwnUnderline());
        targetStyle.setVerticalImageAlign(sourceStyle.getOwnVerticalImageAlign());
        targetStyle.setVerticalTextAlign(sourceStyle.getOwnVerticalTextAlign());
        JRParagraph targetParagraph = targetStyle.getParagraph();
        JRParagraph sourceParagraph = sourceStyle.getParagraph();
        targetParagraph.setFirstLineIndent(sourceParagraph.getOwnFirstLineIndent());
        targetParagraph.setLeftIndent(sourceParagraph.getOwnLeftIndent());
        targetParagraph.setLineSpacing(sourceParagraph.getOwnLineSpacing());
        targetParagraph.setLineSpacingSize(sourceParagraph.getOwnLineSpacingSize());
        targetParagraph.setRightIndent(sourceParagraph.getOwnRightIndent());
        targetParagraph.setSpacingAfter(sourceParagraph.getOwnSpacingAfter());
        targetParagraph.setSpacingBefore(sourceParagraph.getOwnSpacingBefore());
        targetParagraph.setTabStopWidth(sourceParagraph.getOwnTabStopWidth());
        JRPen targetPen = targetStyle.getLinePen();
        JRPen sourcePen = sourceStyle.getLinePen();
        targetPen.setLineColor(sourcePen.getOwnLineColor());
        targetPen.setLineStyle(sourcePen.getOwnLineStyleValue());
        targetPen.setLineWidth(sourcePen.getOwnLineWidth());
        JRLineBox targetBox = targetStyle.getLineBox();
        JRLineBox sourceBox = sourceStyle.getLineBox();
        targetBox.setBottomPadding(sourceBox.getOwnBottomPadding());
        targetBox.setLeftPadding(sourceBox.getOwnLeftPadding());
        targetBox.setPadding(sourceBox.getOwnPadding());
        targetBox.setRightPadding(sourceBox.getOwnRightPadding());
        targetBox.setTopPadding(sourceBox.getOwnTopPadding());
        this.copyLineBox(targetBox.getPen(), sourceBox.getPen());
        this.copyLineBox(targetBox.getLeftPen(), sourceBox.getLeftPen());
        this.copyLineBox(targetBox.getRightPen(), sourceBox.getRightPen());
        this.copyLineBox(targetBox.getBottomPen(), sourceBox.getBottomPen());
        this.copyLineBox(targetBox.getTopPen(), sourceBox.getTopPen());
        if (targetStyle instanceof JRDesignStyle && sourceStyle instanceof JRDesignStyle) {
            this.copyParentStyleAttributes((JRDesignStyle)targetStyle, (JRDesignStyle)sourceStyle);
        }
    }

    protected void copyLineBox(JRBoxPen targetPen, JRBoxPen sourcePen) {
        targetPen.setLineColor(sourcePen.getOwnLineColor());
        targetPen.setLineStyle(sourcePen.getOwnLineStyleValue());
        targetPen.setLineWidth(sourcePen.getOwnLineWidth());
    }

    public void execute() {
        this.targetStyleCopy = (JRDesignStyle)this.targetStyle.clone();
        this.copyAttributes((JRBaseStyle)this.targetStyle, (JRBaseStyle)this.sourceStyle);
    }

    public boolean canUndo() {
        return this.targetStyleCopy != null;
    }

    public void undo() {
        this.copyAttributes((JRBaseStyle)this.targetStyle, (JRBaseStyle)this.targetStyleCopy);
        this.targetStyleCopy = null;
    }
}

