/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.subreport;

import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.JReportsDTO;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.JRSubreportExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.returnvalue.RVPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.subreport.parameter.SubreportPropertiesPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeListener;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.OverflowType;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MSubreport
extends MGraphicElement {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;
    private static NamedEnumPropertyDescriptor<OverflowType> overflowTypeD;
    private JReportsDTO returnValuesDTO;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("subreport");
        }
        return iconDescriptor;
    }

    public MSubreport() {
    }

    public MSubreport(ANode parent, JRDesignSubreport jrSubreport, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrSubreport);
        if (jrSubreport != null) {
            jrSubreport.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        CheckBoxPropertyDescriptor runToBottomD = new CheckBoxPropertyDescriptor("runToBottom", Messages.MSubreport_run_to_bottom, NullEnum.NULL);
        runToBottomD.setDescription(Messages.MSubreport_run_to_bottom_description);
        desc.add((IPropertyDescriptor)runToBottomD);
        CheckBoxPropertyDescriptor useCacheD = new CheckBoxPropertyDescriptor("isUsingCache", Messages.common_using_cache, NullEnum.INHERITED);
        useCacheD.setDescription(Messages.MSubreport_using_cache_description);
        desc.add((IPropertyDescriptor)useCacheD);
        JRSubreportExpressionPropertyDescriptor exprD = new JRSubreportExpressionPropertyDescriptor("expression", Messages.common_expression);
        exprD.setDescription(Messages.MSubreport_expression_description);
        desc.add((IPropertyDescriptor)exprD);
        exprD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#subreportExpression"));
        JRExpressionPropertyDescriptor paramExprD = new JRExpressionPropertyDescriptor("parametersMapExpression", Messages.common_parameters_map_expression);
        paramExprD.setDescription(Messages.MSubreport_parameters_map_expression_description);
        desc.add((IPropertyDescriptor)paramExprD);
        paramExprD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#parametersMapExpression"));
        JRExpressionPropertyDescriptor connExprD = new JRExpressionPropertyDescriptor("connectionExpression", Messages.common_connection_expression);
        connExprD.setDescription(Messages.MSubreport_connection_expression_description);
        desc.add((IPropertyDescriptor)connExprD);
        connExprD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#connectionExpression"));
        JRExpressionPropertyDescriptor dsExprD = new JRExpressionPropertyDescriptor("dataSourceExpression", Messages.MSubreport_datasource_expression);
        dsExprD.setDescription(Messages.MSubreport_datasource_expression_description);
        desc.add((IPropertyDescriptor)dsExprD);
        dsExprD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#dataSourceExpression"));
        SubreportPropertiesPropertyDescriptor propertiesD = new SubreportPropertiesPropertyDescriptor("parameters", Messages.MSubreport_parametersName);
        propertiesD.setDescription(Messages.MSubreport_parameters_description);
        desc.add((IPropertyDescriptor)propertiesD);
        propertiesD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#subreportParameter"));
        propertiesD.init(this);
        RVPropertyDescriptor returnValuesD = new RVPropertyDescriptor("returnValues", Messages.MSubreport_returnValuesName);
        returnValuesD.setDescription(Messages.MSubreport_return_values_description);
        desc.add((IPropertyDescriptor)returnValuesD);
        returnValuesD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#returnValue"));
        overflowTypeD = new NamedEnumPropertyDescriptor<OverflowType>("overflowType", Messages.MSubreport_0, OverflowType.STRETCH, NullEnum.NOTNULL);
        overflowTypeD.setDescription(Messages.MSubreport_1);
        desc.add((IPropertyDescriptor)overflowTypeD);
        overflowTypeD.setCategory(Messages.MSubreport_subreport_properties_category);
        returnValuesD.setCategory(Messages.MSubreport_subreport_properties_category);
        propertiesD.setCategory(Messages.MSubreport_subreport_properties_category);
        dsExprD.setCategory(Messages.MSubreport_subreport_properties_category);
        connExprD.setCategory(Messages.MSubreport_subreport_properties_category);
        paramExprD.setCategory(Messages.MSubreport_subreport_properties_category);
        exprD.setCategory(Messages.MSubreport_subreport_properties_category);
        useCacheD.setCategory(Messages.MSubreport_subreport_properties_category);
        runToBottomD.setCategory(Messages.MSubreport_subreport_properties_category);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#subreport");
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignSubreport jrElement = this.getValue();
        if (id.equals("runToBottom")) {
            return jrElement.isRunToBottom();
        }
        if (id.equals("isUsingCache")) {
            return jrElement.getUsingCache();
        }
        if (id.equals("expression")) {
            return ExprUtil.getExpression(jrElement.getExpression());
        }
        if (id.equals("parametersMapExpression")) {
            return ExprUtil.getExpression(jrElement.getParametersMapExpression());
        }
        if (id.equals("connectionExpression")) {
            return ExprUtil.getExpression(jrElement.getConnectionExpression());
        }
        if (id.equals("dataSourceExpression")) {
            return ExprUtil.getExpression(jrElement.getDataSourceExpression());
        }
        if (id.equals("parameters")) {
            return JRCloneUtils.cloneArray((JRCloneable[])jrElement.getParameters());
        }
        if (id.equals("returnValues")) {
            if (this.returnValuesDTO == null) {
                this.returnValuesDTO = new JReportsDTO();
                this.returnValuesDTO.setjConfig(this.getJasperConfiguration());
                this.returnValuesDTO.setSubreport(jrElement, (JRDataset)ModelUtils.getFirstDatasetInHierarchy(this));
            }
            this.returnValuesDTO.setValue(JRCloneUtils.cloneList((List)jrElement.getReturnValuesList()));
            return this.returnValuesDTO;
        }
        if (id.equals("overflowType")) {
            return overflowTypeD.getIntValue(jrElement.getOverflowType());
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        JRDesignSubreport jrElement = this.getValue();
        if (id.equals("runToBottom")) {
            jrElement.setRunToBottom((Boolean)value);
        }
        if (id.equals("isUsingCache")) {
            jrElement.setUsingCache((Boolean)value);
        } else if (id.equals("overflowType")) {
            jrElement.setOverflowType(overflowTypeD.getEnumValue(value));
        } else if (id.equals("runToBottom")) {
            jrElement.setUsingCache((Boolean)value);
        } else if (id.equals("expression")) {
            jrElement.setExpression(ExprUtil.setValues(jrElement.getExpression(), value));
        } else if (id.equals("parametersMapExpression")) {
            jrElement.setParametersMapExpression(ExprUtil.setValues(jrElement.getParametersMapExpression(), value));
        } else if (id.equals("connectionExpression")) {
            if (value instanceof String) {
                value = value != null && ((String)value).equals("") ? null : value;
            }
            jrElement.setConnectionExpression(ExprUtil.setValues(jrElement.getConnectionExpression(), value));
        } else if (id.equals("dataSourceExpression")) {
            if (value instanceof String) {
                value = value != null && ((String)value).equals("") ? null : value;
            }
            jrElement.setDataSourceExpression(ExprUtil.setValues(jrElement.getDataSourceExpression(), value));
        } else if (id.equals("parameters")) {
            if (value.getClass().isArray()) {
                JRSubreportParameter p;
                JRSubreportParameter[] old;
                JRSubreportParameter[] v = (JRSubreportParameter[])value;
                JRSubreportParameter[] jRSubreportParameterArray = old = jrElement.getParameters();
                int n = old.length;
                int n2 = 0;
                while (n2 < n) {
                    p = jRSubreportParameterArray[n2];
                    jrElement.removeParameter(p.getName());
                    ++n2;
                }
                jRSubreportParameterArray = v;
                n = v.length;
                n2 = 0;
                while (n2 < n) {
                    p = jRSubreportParameterArray[n2];
                    try {
                        jrElement.addParameter(p);
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            }
        } else if (id.equals("returnValues")) {
            this.returnValuesDTO = (JReportsDTO)value;
            List<JRSubreportReturnValue> list = this.returnValuesDTO.getValue();
            JRSubreportReturnValue[] jRSubreportReturnValueArray = jrElement.getReturnValues();
            int n = jRSubreportReturnValueArray.length;
            int n3 = 0;
            while (n3 < n) {
                JRSubreportReturnValue srv = jRSubreportReturnValueArray[n3];
                jrElement.removeReturnValue(srv);
                ++n3;
            }
            for (JRSubreportReturnValue j : list) {
                jrElement.addReturnValue(j);
            }
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public int getDefaultHeight() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(this.getClass(), "height");
        return defaultValue != null ? (Integer)defaultValue : 200;
    }

    @Override
    public int getDefaultWidth() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(this.getClass(), "width");
        return defaultValue != null ? (Integer)defaultValue : 200;
    }

    @Override
    public JRDesignElement createJRElement(JasperDesign jasperDesign, boolean applayDefault) {
        JRDesignSubreport subreport = new JRDesignSubreport((JRDefaultStyleProvider)jasperDesign);
        if (applayDefault) {
            DefaultManager.INSTANCE.applyDefault(this.getClass(), (JRElement)subreport);
        }
        return subreport;
    }

    @Override
    public String getDisplayText() {
        String p = this.getElementNameProperty();
        return Misc.isNullOrEmpty((String)p) ? MSubreport.getIconDescriptor().getTitle() : p;
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MSubreport.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        JRDesignSubreport value = this.getValue();
        if (value != null) {
            String tip = "";
            if (value.getExpression() != null) {
                tip = String.valueOf(tip) + value.getExpression().getText();
            }
            if (tip.trim().isEmpty()) {
                return String.valueOf(MSubreport.getIconDescriptor().getTitle()) + ": " + Messages.common_noExpressionMessage;
            }
            return String.valueOf(MSubreport.getIconDescriptor().getTitle()) + ": " + tip;
        }
        return MSubreport.getIconDescriptor().getToolTip();
    }

    @Override
    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        JRDesignSubreport jrSource = this.getValue();
        if (jrSource != null) {
            JRDesignSubreport jrTarget = (JRDesignSubreport)target;
            jrTarget.setRunToBottom(jrSource.isRunToBottom());
        }
    }

    public JRDesignSubreport getValue() {
        return (JRDesignSubreport)super.getValue();
    }

    @Override
    public boolean isReportSplittingSupported() {
        return false;
    }
}

