/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.textfield.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.model.textfield.MPageNumber;
import com.jaspersoft.studio.model.textfield.MPageXofY;
import com.jaspersoft.studio.model.textfield.MTotalPages;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import org.eclipse.draw2d.geometry.Rectangle;

public class CreatePageXofYCommand
extends CreateElementCommand {
    private JasperDesign jrDesign;
    private JRDesignTextField tfPageTotal;
    private JRDesignTextField tfPageNumber;
    private boolean firstTime = true;

    public CreatePageXofYCommand(MElementGroup destNode, MPageXofY srcNode, int index) {
        super(destNode, (MGraphicElement)srcNode, index);
    }

    public CreatePageXofYCommand(MFrame destNode, MPageXofY srcNode, int index) {
        super(destNode, (MGraphicElement)srcNode, index);
    }

    public CreatePageXofYCommand(MBand destNode, MPageXofY srcNode, int index) {
        super(destNode, (MGraphicElement)srcNode, index);
    }

    public CreatePageXofYCommand(ANode destNode, MPageXofY srcNode, Rectangle position, int index) {
        super(destNode, (MGraphicElement)srcNode, position, index);
    }

    @Override
    protected void setContext(ANode destNode, MGraphicElement srcNode, int index) {
        super.setContext(destNode, srcNode, index);
        this.jrDesign = destNode.getJasperDesign();
    }

    @Override
    protected void createObject() {
        Rectangle location = this.getLocation();
        if (location == null) {
            location = this.jrElement != null ? new Rectangle(this.jrElement.getX(), this.jrElement.getY(), this.jrElement.getWidth(), this.jrElement.getHeight()) : new Rectangle(0, 0, 100, 50);
        }
        if (location.width < 0) {
            location.width = this.srcNode.getDefaultWidth() * 2;
        }
        if (location.height < 0) {
            location.height = this.srcNode.getDefaultHeight();
        }
        int index = this.getIndex();
        JRElementGroup jrGroup = this.getJrGroup();
        if (index < 0) {
            index = jrGroup.getChildren().size();
        }
        MPageNumber mPageNumber = new MPageNumber();
        this.tfPageNumber = mPageNumber.createJRElement(this.jrDesign);
        this.tfPageNumber.setX(location.x);
        this.tfPageNumber.setY(location.y);
        this.tfPageNumber.setWidth(location.width / 2);
        this.tfPageNumber.setHeight(location.height);
        this.tfPageNumber.setHorizontalTextAlign(HorizontalTextAlignEnum.RIGHT);
        this.tfPageNumber.setEvaluationTime(EvaluationTimeEnum.NOW);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setText(Messages.CreatePageXofYCommand_0);
        this.tfPageNumber.setExpression((JRExpression)expression);
        if (jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)jrGroup).addElement(index, (JRDesignElement)this.tfPageNumber);
        } else if (jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)jrGroup).addElement(index, (JRElement)this.tfPageNumber);
        }
        MTotalPages mTotalPages = new MTotalPages();
        this.tfPageTotal = mTotalPages.createJRElement(this.jrDesign);
        this.tfPageTotal.setX(location.x + this.tfPageNumber.getWidth());
        this.tfPageTotal.setY(location.y);
        this.tfPageTotal.setWidth(location.width / 2);
        this.tfPageTotal.setHeight(location.height);
        this.tfPageTotal.setHorizontalTextAlign(HorizontalTextAlignEnum.LEFT);
        this.tfPageTotal.setEvaluationTime(EvaluationTimeEnum.REPORT);
        expression = new JRDesignExpression();
        expression.setText(Messages.CreatePageXofYCommand_1);
        this.tfPageTotal.setExpression((JRExpression)expression);
        if (jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)jrGroup).addElement(index + 1, (JRDesignElement)this.tfPageTotal);
        } else if (jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)jrGroup).addElement(index + 1, (JRElement)this.tfPageTotal);
        }
    }

    @Override
    public void execute() {
        this.createObject();
        if (this.firstTime) {
            SelectionHelper.setSelection((JRChild)this.tfPageNumber, false);
            this.firstTime = false;
        }
    }

    @Override
    public void undo() {
        if (this.jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.jrGroup).removeElement((JRDesignElement)this.tfPageNumber);
        } else if (this.jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)this.jrGroup).removeElement((JRElement)this.tfPageNumber);
        }
        if (this.jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.jrGroup).removeElement((JRDesignElement)this.tfPageTotal);
        } else if (this.jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)this.jrGroup).removeElement((JRElement)this.tfPageTotal);
        }
    }
}

