/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.util;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import org.apache.commons.lang.StringUtils;

public abstract class ModelVisitor<T> {
    protected int level = 0;
    private T object;

    public ModelVisitor(INode model) {
        try {
            this.iterate(model);
        }
        catch (StopException stopException) {}
    }

    public void iterate(INode node) {
        if (node != null && node.getChildren() != null) {
            ++this.level;
            for (INode n : node.getChildren()) {
                if (!this.visit(n)) continue;
                this.iterate(n);
                this.postChildIteration(n);
            }
            --this.level;
        }
    }

    protected void postChildIteration(INode n) {
    }

    public abstract boolean visit(INode var1);

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void stop() {
        throw new StopException();
    }

    public static void printModel(ANode node) {
        final StringBuilder sb = new StringBuilder();
        INode r = node.getRoot();
        if (r == null) {
            sb.append("Root: null\n");
            do {
                r = node;
            } while ((node = node.getParent()) != null);
        }
        sb.append(r.getDisplayText()).append(" [" + r + "]\n");
        new ModelVisitor<String>(r){

            @Override
            public boolean visit(INode n) {
                sb.append(StringUtils.repeat((String)" ", (int)this.level)).append(n.getDisplayText()).append(" [" + n + "]\n");
                return true;
            }
        };
        System.out.println("\n" + sb.toString());
    }

    private static class StopException
    extends RuntimeException {
        public static final long serialVersionUID = 10200L;
    }
}

