/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.util;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.background.MBackgrounImage;
import com.jaspersoft.studio.callout.MCallout;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MBreak;
import com.jaspersoft.studio.model.MCompositeElementReport;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.MEllipse;
import com.jaspersoft.studio.model.MLine;
import com.jaspersoft.studio.model.MRectangle;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.MReportRoot;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.band.MBandGroupFooter;
import com.jaspersoft.studio.model.band.MBandGroupHeader;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFields;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.model.genericElement.MComponentElement;
import com.jaspersoft.studio.model.genericElement.MGenericElement;
import com.jaspersoft.studio.model.group.MGroup;
import com.jaspersoft.studio.model.group.MGroups;
import com.jaspersoft.studio.model.image.MImage;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.parameter.MParameterSystem;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.model.scriptlet.MScriptlet;
import com.jaspersoft.studio.model.scriptlet.MScriptlets;
import com.jaspersoft.studio.model.scriptlet.MSystemScriptlet;
import com.jaspersoft.studio.model.sortfield.MSortField;
import com.jaspersoft.studio.model.sortfield.MSortFields;
import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.model.style.StyleTemplateFactory;
import com.jaspersoft.studio.model.subreport.MSubreport;
import com.jaspersoft.studio.model.text.MStaticText;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.model.variable.MVariableSystem;
import com.jaspersoft.studio.model.variable.MVariables;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignBreak;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignEllipse;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGenericElement;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignLine;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignScriptlet;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.core.resources.IFile;

public class ReportFactory {
    public static INode createReport(JasperReportsConfiguration jConfig) {
        JasperDesign jd = jConfig.getJasperDesign();
        MReportRoot node = new MReportRoot(jConfig, (Object)jd);
        MReport report = new MReport((ANode)node, jConfig);
        ReportFactory.createStyles(jConfig, jd, report, -1);
        ReportFactory.createDataset(report, jd.getMainDesignDataset(), false);
        if (jd.getDatasetsList() != null) {
            for (JRDataset jrDataset : jd.getDatasetsList()) {
                ReportFactory.createDataset(new MDataset((ANode)report, (JRDesignDataset)jrDataset, -1), (JRDesignDataset)jrDataset, true);
            }
        }
        new MBackgrounImage(report);
        ReportFactory.createReportBands(jd, report);
        MCallout.createCallouts(report);
        return node;
    }

    public static INode createToolReport(JasperReportsConfiguration jConfig) {
        JasperDesign jd = jConfig.getJasperDesign();
        MReportRoot node = new MReportRoot(jConfig, (Object)jd);
        MCompositeElementReport report = new MCompositeElementReport((ANode)node, jConfig);
        new MBackgrounImage(report);
        ReportFactory.createTitleBand(jd, report);
        MCallout.createCallouts(report);
        return node;
    }

    private static void createTitleBand(JasperDesign jd, ANode report) {
        MBand title = new MBand(report, jd.getTitle(), BandTypeEnum.TITLE, -1);
        if (jd.getTitle() != null) {
            ReportFactory.createElementsForBand(title, jd.getTitle().getChildren());
        }
    }

    private static void createReportBands(JasperDesign jd, ANode report) {
        JRBand[] bandsList;
        MBand title = new MBand(report, jd.getTitle(), BandTypeEnum.TITLE, -1);
        if (jd.getTitle() != null) {
            ReportFactory.createElementsForBand(title, jd.getTitle().getChildren());
        }
        MBand pageHeader = new MBand(report, jd.getPageHeader(), BandTypeEnum.PAGE_HEADER, -1);
        if (jd.getPageHeader() != null) {
            ReportFactory.createElementsForBand(pageHeader, jd.getPageHeader().getChildren());
        }
        MBand columnHeader = new MBand(report, jd.getColumnHeader(), BandTypeEnum.COLUMN_HEADER, -1);
        if (jd.getColumnHeader() != null) {
            ReportFactory.createElementsForBand(columnHeader, jd.getColumnHeader().getChildren());
        }
        if (jd.getGroupsList() != null) {
            for (JRGroup gr : jd.getGroupsList()) {
                List grhBands;
                MBandGroupHeader b = null;
                if (gr.getGroupHeaderSection() != null && (grhBands = ((JRDesignSection)gr.getGroupHeaderSection()).getBandsList()) != null) {
                    for (JRDesignBand jrDB : grhBands) {
                        b = new MBandGroupHeader(report, (JRDesignGroup)gr, (JRBand)jrDB, -1);
                        ReportFactory.createElementsForBand(b, jrDB.getChildren());
                    }
                }
                if (b != null) continue;
                new MBandGroupHeader(report, (JRDesignGroup)gr, null, -1);
            }
        }
        MBand detBand = null;
        if (jd.getDetailSection() != null && (bandsList = jd.getDetailSection().getBands()) != null) {
            int k = 0;
            while (k < bandsList.length) {
                if (bandsList[k] != null) {
                    detBand = new MBand(report, bandsList[k], BandTypeEnum.DETAIL, -1);
                    ReportFactory.createElementsForBand(detBand, bandsList[k].getChildren());
                }
                ++k;
            }
        }
        if (detBand == null) {
            new MBand(report, null, BandTypeEnum.DETAIL, -1);
        }
        if (jd.getGroupsList() != null) {
            ListIterator ij = jd.getGroupsList().listIterator(jd.getGroupsList().size());
            while (ij.hasPrevious()) {
                List grhBands;
                JRGroup gr = (JRGroup)ij.previous();
                MBandGroupFooter b = null;
                if (gr.getGroupFooterSection() != null && (grhBands = ((JRDesignSection)gr.getGroupFooterSection()).getBandsList()) != null) {
                    for (JRDesignBand jrDB : grhBands) {
                        b = new MBandGroupFooter(report, (JRDesignGroup)gr, (JRBand)jrDB, -1);
                        ReportFactory.createElementsForBand(b, jrDB.getChildren());
                    }
                }
                if (b != null) continue;
                new MBandGroupFooter(report, (JRDesignGroup)gr, null, -1);
            }
        }
        MBand columnFooter = new MBand(report, jd.getColumnFooter(), BandTypeEnum.COLUMN_FOOTER, -1);
        if (jd.getColumnFooter() != null) {
            ReportFactory.createElementsForBand(columnFooter, jd.getColumnFooter().getChildren());
        }
        MBand footer = new MBand(report, jd.getPageFooter(), BandTypeEnum.PAGE_FOOTER, -1);
        if (jd.getPageFooter() != null) {
            ReportFactory.createElementsForBand(footer, jd.getPageFooter().getChildren());
        }
        MBand lastPageFooter = new MBand(report, jd.getLastPageFooter(), BandTypeEnum.LAST_PAGE_FOOTER, -1);
        if (jd.getLastPageFooter() != null) {
            ReportFactory.createElementsForBand(lastPageFooter, jd.getLastPageFooter().getChildren());
        }
        MBand summary = new MBand(report, jd.getSummary(), BandTypeEnum.SUMMARY, -1);
        if (jd.getSummary() != null) {
            ReportFactory.createElementsForBand(summary, jd.getSummary().getChildren());
        }
        MBand nodata = new MBand(report, jd.getNoData(), BandTypeEnum.NO_DATA, -1);
        if (jd.getNoData() != null) {
            ReportFactory.createElementsForBand(nodata, jd.getNoData().getChildren());
        }
        MBand background = new MBand(report, jd.getBackground(), BandTypeEnum.BACKGROUND, -1);
        if (jd.getBackground() != null) {
            ReportFactory.createElementsForBand(background, jd.getBackground().getChildren());
        }
    }

    public static void createStyles(JasperReportsConfiguration jConfig, JasperDesign jd, ANode report, int index) {
        MStyles nStyle = new MStyles(report, index);
        if (jd.getTemplates() != null) {
            Iterator it = jd.getTemplatesList().iterator();
            while (it.hasNext()) {
                ReportFactory.createNode(nStyle, it.next(), -1, (IFile)jConfig.get("ifile"));
            }
        }
        if (jd.getStyles() != null) {
            for (JRStyle jrstyle : jd.getStylesList()) {
                ANode mstyle = ReportFactory.createNode(nStyle, jrstyle, -1);
                if (((JRDesignStyle)jrstyle).getConditionalStyleList() == null) continue;
                for (Object jrc : ((JRDesignStyle)jrstyle).getConditionalStyleList()) {
                    ReportFactory.createNode(mstyle, jrc, -1);
                }
            }
        }
        nStyle.updateDefaulStyle();
    }

    public static void createDataset(ANode nDataset, JRDesignDataset dataSet, boolean showGroups) {
        MParameters<JRDesignDataset> nParameters = new MParameters<JRDesignDataset>(nDataset, dataSet, "parameters");
        if (dataSet.getParametersList() != null) {
            for (JRParameter jrparam : dataSet.getParametersList()) {
                ReportFactory.createNode(nParameters, jrparam, -1);
            }
        }
        MFields nFields = new MFields(nDataset, dataSet);
        if (dataSet.getFieldsList() != null) {
            for (JRField jrField : dataSet.getFieldsList()) {
                ReportFactory.createNode(nFields, jrField, -1);
            }
        }
        MSortFields nSortFields = new MSortFields(nDataset, dataSet);
        if (dataSet.getSortFieldsList() != null) {
            for (JRSortField sortField : dataSet.getSortFieldsList()) {
                ReportFactory.createNode(nSortFields, sortField, -1);
            }
        }
        MVariables nVariables = new MVariables(nDataset, dataSet);
        if (dataSet.getVariablesList() != null) {
            for (JRVariable jrVar : dataSet.getVariablesList()) {
                ReportFactory.createNode(nVariables, jrVar, -1);
            }
        }
        MScriptlets nScriptlets = new MScriptlets(nDataset, dataSet);
        if (dataSet.getParametersMap().containsKey("REPORT_SCRIPTLET")) {
            JRParameter prm = (JRParameter)dataSet.getParametersMap().get("REPORT_SCRIPTLET");
            JRDesignScriptlet jrscriptlet = new JRDesignScriptlet();
            jrscriptlet.setName("REPORT_SCRIPTLET");
            jrscriptlet.setDescription("Default Scriptlet");
            jrscriptlet.setValueClassName(prm.getValueClassName());
            ReportFactory.createNode(nScriptlets, jrscriptlet, -1);
        }
        if (dataSet.getScriptletClass() != null) {
            JRDesignScriptlet jrscriptlet = new JRDesignScriptlet();
            jrscriptlet.setName("DATASET_SCRIPTLET");
            jrscriptlet.setDescription("Default Scriptlet");
            jrscriptlet.setValueClassName(dataSet.getScriptletClass());
            ReportFactory.createNode(nScriptlets, jrscriptlet, -1);
        }
        if (dataSet.getScriptletsList() != null) {
            for (JRScriptlet jrScriptlet : dataSet.getScriptletsList()) {
                ReportFactory.createNode(nScriptlets, jrScriptlet, -1);
            }
        }
        if (showGroups) {
            MGroups nGroups = new MGroups(nDataset, dataSet);
            if (dataSet.getGroupsList() != null) {
                for (JRGroup jrGroup : dataSet.getGroupsList()) {
                    ReportFactory.createNode(nGroups, jrGroup, -1);
                }
            }
        }
    }

    public static void createElementsForBand(ANode band, List<?> list) {
        for (Object element : list) {
            ANode node = ReportFactory.createNode(band, element, -1);
            if (element instanceof JRDesignFrame) {
                JRDesignFrame frame = (JRDesignFrame)element;
                ReportFactory.createElementsForBand(node, frame.getChildren());
                continue;
            }
            if (!(element instanceof JRElementGroup)) continue;
            JRElementGroup group = (JRElementGroup)element;
            ReportFactory.createElementsForBand(node, group.getChildren());
        }
    }

    public static ANode createNode(ANode parent, Object jrObject, int newIndex, IFile file) {
        ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
        ANode n = m.createNode(parent, jrObject, newIndex);
        if (n != null) {
            List<?> children = m.getChildren4Element(jrObject);
            if (children != null && !children.isEmpty()) {
                ReportFactory.createElementsForBand(n, children);
            }
            return n;
        }
        if (jrObject instanceof JRDesignBand) {
            return new MBand(parent, (JRBand)((JRDesignBand)jrObject), ((JRDesignBand)jrObject).getOrigin().getBandTypeValue(), newIndex);
        }
        if (jrObject instanceof JRFrame) {
            return new MFrame(parent, (JRDesignFrame)jrObject, newIndex);
        }
        if (jrObject instanceof JRElementGroup) {
            return new MElementGroup(parent, (JRElementGroup)jrObject, newIndex);
        }
        if (jrObject instanceof JRSubreport) {
            return new MSubreport(parent, (JRDesignSubreport)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignEllipse) {
            return new MEllipse(parent, (JRDesignEllipse)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignRectangle) {
            return new MRectangle(parent, (JRDesignRectangle)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignLine) {
            return new MLine(parent, (JRDesignLine)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignImage) {
            return new MImage(parent, (JRDesignImage)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignImage) {
            return new MImage(parent, (JRDesignImage)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignStaticText) {
            return new MStaticText(parent, (JRStaticText)((JRDesignStaticText)jrObject), newIndex);
        }
        if (jrObject instanceof JRDesignBreak) {
            return new MBreak(parent, (JRDesignBreak)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignTextField) {
            return new MTextField(parent, (JRTextField)((JRDesignTextField)jrObject), newIndex);
        }
        if (jrObject instanceof JRGenericElement) {
            return new MGenericElement(parent, (JRDesignGenericElement)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignComponentElement) {
            return new MComponentElement(parent, (JRDesignComponentElement)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignStyle) {
            JRReportTemplate[] templates;
            if (newIndex != -1 && (templates = parent.getJasperDesign().getTemplates()) != null && templates.length > 0) {
                newIndex += templates.length;
            }
            return new MStyle(parent, (JRDesignStyle)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignConditionalStyle) {
            MConditionalStyle mConditionalStyle = new MConditionalStyle(parent, (JRDesignConditionalStyle)jrObject, newIndex);
            mConditionalStyle.setEditable(((APropertyNode)parent).isEditable());
            return mConditionalStyle;
        }
        if (jrObject instanceof JRDesignReportTemplate) {
            return StyleTemplateFactory.createTemplate(parent, (JRDesignReportTemplate)jrObject, newIndex, file);
        }
        if (jrObject instanceof JRDesignParameter) {
            JRDesignParameter jrParameter = (JRDesignParameter)jrObject;
            if (jrParameter.isSystemDefined()) {
                return new MParameterSystem(parent, jrParameter, newIndex);
            }
            return new MParameter(parent, jrParameter, newIndex);
        }
        if (jrObject instanceof JRDesignField) {
            return new MField(parent, (JRDesignField)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignSortField) {
            return new MSortField(parent, (JRDesignSortField)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignGroup) {
            return new MGroup(parent, (JRDesignGroup)jrObject, newIndex);
        }
        if (jrObject instanceof JRDesignVariable) {
            JRDesignVariable jrVariable = (JRDesignVariable)jrObject;
            if (jrVariable.isSystemDefined()) {
                return new MVariableSystem(parent, jrVariable, newIndex);
            }
            return new MVariable(parent, jrVariable, newIndex);
        }
        if (jrObject instanceof JRDesignScriptlet) {
            if (parent instanceof MScriptlets) {
                MScriptlets ms = (MScriptlets)parent;
                for (INode node : ms.getChildren()) {
                    JRDesignScriptlet jds = (JRDesignScriptlet)node.getValue();
                    if (!jds.getName().equals("REPORT_SCRIPTLET") && !jds.getName().equals("DATASET_SCRIPTLET")) continue;
                    if (newIndex < 0) {
                        newIndex = 0;
                    }
                    ++newIndex;
                }
            }
            if (((JRDesignScriptlet)jrObject).getName().equals("REPORT_SCRIPTLET")) {
                return new MSystemScriptlet(parent, (JRScriptlet)((JRDesignScriptlet)jrObject), newIndex);
            }
            if (((JRDesignScriptlet)jrObject).getName().equals("DATASET_SCRIPTLET")) {
                return new MSystemScriptlet(parent, (JRScriptlet)((JRDesignScriptlet)jrObject), newIndex);
            }
            return new MScriptlet(parent, (JRScriptlet)((JRDesignScriptlet)jrObject), newIndex);
        }
        if (jrObject instanceof JRDesignDataset) {
            return new MDataset(parent, (JRDesignDataset)jrObject, newIndex);
        }
        ++newIndex;
        return null;
    }

    public static ANode createNode(ANode parent, Object jrObject, int newIndex) {
        return ReportFactory.createNode(parent, jrObject, newIndex, null);
    }
}

