/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.ExpressionListFieldEditor;
import com.jaspersoft.studio.preferences.util.FieldEditorOverlayPage;
import com.jaspersoft.studio.preferences.util.PropertiesHelper;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.eclipse.util.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;

public class ExpressionEditorPreferencePage
extends FieldEditorOverlayPage {
    public static final String PAGE_ID = "com.jaspersoft.studio.preferences.ExpressionEditorPreferencePage.property";
    public static final String P_USER_DEFINED_EXPRESSIONS = "userDefinedExpressions";
    @Deprecated
    public static final String P_INCLUDE_FUCTIONS_LIBRARY_IMPORTS = "includeFunctionsLibraryImports";
    public static final String P_CONFIRMATION_ON_CLOSE = "askConfirmationOnEditorClose";
    public static final String P_REMEMBER_EXPEDITOR_SIZE = "rememberExpEditorSize";
    public static final String P_REMEMBER_EXPEDITOR_LOCATION = "rememberExpEditorLocation";
    public static final String V_EXPEDITOR_SIZE_WIDTH = "expressionEditorWidth";
    public static final String V_EXPEDITOR_SIZE_HEIGHT = "expressionEditorHeight";
    public static final String V_EXPEDITOR_LOCATION_X = "expressionEditorLocationX";
    public static final String V_EXPEDITOR_LOCATION_Y = "expressionEditorLocationY";

    public ExpressionEditorPreferencePage() {
        super(1);
        this.setPreferenceStore(JaspersoftStudioPlugin.getInstance().getPreferenceStore());
        this.setDescription(Messages.ExpressionEditorPreferencePage_subtitle);
    }

    @Override
    protected void createFieldEditors() {
        this.addField((FieldEditor)new ExpressionListFieldEditor(P_USER_DEFINED_EXPRESSIONS, Messages.ExpressionEditorPreferencePage_userDefinedExpressions, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_CONFIRMATION_ON_CLOSE, Messages.ExpressionEditorPreferencePage_confirmationOnClosing, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_REMEMBER_EXPEDITOR_SIZE, Messages.ExpressionEditorPreferencePage_rememberSize, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_REMEMBER_EXPEDITOR_LOCATION, Messages.ExpressionEditorPreferencePage_rememberLocation, this.getFieldEditorParent()));
        super.createFieldEditors();
    }

    public void init(IWorkbench workbench) {
    }

    public static List<String> getUserDefinedExpressionList() {
        IEclipsePreferences preferences = PropertiesHelper.INSTANCE_SCOPE.getNode(JaspersoftStudioPlugin.getUniqueIdentifier());
        String expressionListStr = preferences.get(P_USER_DEFINED_EXPRESSIONS, null);
        ArrayList<String> v = new ArrayList<String>();
        if (expressionListStr != null) {
            StringTokenizer st = new StringTokenizer(expressionListStr, "\n");
            while (st.hasMoreElements()) {
                v.add(StringUtils.safeDecode64((String)((String)st.nextElement())));
            }
        }
        return v;
    }

    public static void addUserDefinedExpression(String text) {
        List<String> expressions = ExpressionEditorPreferencePage.getUserDefinedExpressionList();
        if (!expressions.contains(text)) {
            expressions.add(text);
            IEclipsePreferences preferences = PropertiesHelper.INSTANCE_SCOPE.getNode(JaspersoftStudioPlugin.getUniqueIdentifier());
            preferences.put(P_USER_DEFINED_EXPRESSIONS, ExpressionEditorPreferencePage.encodeUserDefinedExpression(expressions));
        }
    }

    public static String encodeUserDefinedExpression(List<String> expressions) {
        StringBuffer expressionsBuff = new StringBuffer("");
        for (String e : expressions) {
            expressionsBuff.append(Base64.getEncoder().encodeToString(e.getBytes()));
            expressionsBuff.append("\n");
        }
        return expressionsBuff.toString();
    }

    public static void getDefaults(IPreferenceStore store) {
        store.setDefault(P_CONFIRMATION_ON_CLOSE, false);
        store.setDefault(P_REMEMBER_EXPEDITOR_SIZE, false);
        store.setDefault(P_REMEMBER_EXPEDITOR_LOCATION, false);
    }

    public String getPageId() {
        return PAGE_ID;
    }
}

