/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences;

import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.ExpressionEditorPreferencePage;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ExpressionListFieldEditor
extends ListEditor {
    public static final String EXPRESSION_SEP = "\n";

    public ExpressionListFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected String createList(String[] items) {
        return ExpressionEditorPreferencePage.encodeUserDefinedExpression(Arrays.asList(items));
    }

    protected String getNewInputObject() {
        if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
            JRDesignExpression newExp;
            JRExpressionEditor wizard = new JRExpressionEditor();
            WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(this.getShell(), wizard);
            if (dialog.open() == 0 && (newExp = wizard.getValue()) != null && !Misc.nvl((String)newExp.getText()).equals("")) {
                String newExprString = newExp.getText();
                List<String> itemsLst = Arrays.asList(this.getList().getItems());
                if (itemsLst.contains(newExprString)) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ExpressionListFieldEditor_CustomExpressionCreationWarningTitle, (String)Messages.ExpressionListFieldEditor_CustomExpressionCreationWarningMsg);
                    return null;
                }
                return newExprString;
            }
        }
        return null;
    }

    protected String[] parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, EXPRESSION_SEP);
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreElements()) {
            String nextElement = (String)st.nextElement();
            v.add(StringUtils.safeDecode64((String)nextElement));
        }
        return v.toArray(new String[v.size()]);
    }

    public org.eclipse.swt.widgets.List getListControl(Composite parent) {
        org.eclipse.swt.widgets.List listControl = super.getListControl(parent);
        if (listControl != null) {
            listControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ExpressionListFieldEditor.this.editCurrentExpression();
                }
            });
        }
        return listControl;
    }

    private void editCurrentExpression() {
        int selectionIndex = this.getList().getSelectionIndex();
        String currExprTxt = this.getList().getItem(selectionIndex);
        if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
            JRExpressionEditor wizard = new JRExpressionEditor();
            wizard.setValue(new JRDesignExpression(currExprTxt));
            WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(this.getShell(), wizard);
            if (dialog.open() == 0) {
                String newExprString;
                JRDesignExpression newExp = wizard.getValue();
                List<String> itemsLst = Arrays.asList(this.getList().getItems());
                if (newExp != null && !Misc.nvl((String)newExp.getText()).equals("") && !currExprTxt.equals(newExprString = newExp.getText())) {
                    if (itemsLst.contains(newExprString)) {
                        MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ExpressionListFieldEditor_CustomExpressionEditWarningTitle, (String)Messages.ExpressionListFieldEditor_CustomExpressionEditWarningMessage);
                    } else {
                        this.getList().setItem(selectionIndex, newExprString);
                    }
                }
            }
        }
    }
}

