/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.plugin.PaletteGroup;
import com.jaspersoft.studio.preferences.util.FieldEditorOverlayPage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.net.util.Base64;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class PalettePreferencePage
extends FieldEditorOverlayPage {
    private static ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
    public static final String PAGE_ID = "com.jaspersoft.studio.preferences.PalettePreferencePage.property";
    private Map<String, Group> grmap;

    public PalettePreferencePage() {
        super(1);
        this.setPreferenceStore(JaspersoftStudioPlugin.getInstance().getPreferenceStore());
        this.setDescription(Messages.PalettePreferencePage_0);
    }

    @Override
    public void createFieldEditors() {
        TreeMap<String, PaletteGroup> map = new TreeMap<String, PaletteGroup>();
        List<PaletteGroup> pgroups = m.getPaletteGroups();
        PaletteGroup pgc = new PaletteGroup();
        pgc.setId("com.jaspersoft.studio.COMMON_ELEMENTS");
        pgc.setName(Messages.common_elements);
        pgc.setImage("icons/resources/elementgroup-16.png");
        map.put(pgc.getId(), pgc);
        pgroups.add(0, pgc);
        for (PaletteGroup p : pgroups) {
            map.put(p.getId(), p);
        }
        Composite parent = this.getFieldEditorParent();
        Map<String, List<PaletteEntry>> me = m.getPaletteEntries();
        this.grmap = new HashMap<String, Group>();
        for (String key : me.keySet()) {
            Group grcmp;
            PaletteGroup pg = (PaletteGroup)map.get(key);
            if (pg == null) {
                pg = pgc;
            }
            if ((grcmp = this.grmap.get(key)) == null) {
                grcmp = new Group(parent, 0);
                grcmp.setText(pg.getName());
                grcmp.setLayoutData((Object)new GridData(768));
                this.grmap.put(key, grcmp);
            }
            List<PaletteEntry> lpe = me.get(key);
            for (PaletteEntry pe : lpe) {
                String id = PalettePreferencePage.getId(pe);
                BooleanFieldEditor be = new BooleanFieldEditor(id, pe.getLabel(), (Composite)grcmp);
                Control c = be.getDescriptionControl((Composite)grcmp);
                if (c instanceof Button) {
                    c.setToolTipText(pe.getDescription());
                    ((Button)c).setImage(JaspersoftStudioPlugin.getInstance().getImage(pe.getSmallIcon()));
                }
                this.addField((FieldEditor)be);
            }
        }
        super.createFieldEditors();
    }

    public static final String getId(PaletteEntry pe) {
        String id = pe.getId();
        if (Misc.isNullOrEmpty((String)pe.getId())) {
            id = "com.jaspersoft.studio.palette." + Base64.encodeBase64String((byte[])pe.getLabel().getBytes());
        }
        return id;
    }

    protected void adjustGridLayout() {
        for (Group gr : this.grmap.values()) {
            gr.setLayout((Layout)new GridLayout(2, false));
        }
    }

    public static void getDefaults(IPreferenceStore store) {
        Map<String, List<PaletteEntry>> me = m.getPaletteEntries();
        for (String key : me.keySet()) {
            List<PaletteEntry> lpe = me.get(key);
            for (PaletteEntry pe : lpe) {
                String id = PalettePreferencePage.getId(pe);
                if (pe.getLabel().equalsIgnoreCase("html")) {
                    store.setDefault(id, true);
                    continue;
                }
                store.setDefault(id, false);
            }
        }
    }

    public void init(IWorkbench workbench) {
    }

    public String getPageId() {
        return PAGE_ID;
    }
}

