/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.bindings;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.preferences.bindings.BindingElement;
import com.jaspersoft.studio.preferences.bindings.JSSKeySequence;
import com.jaspersoft.studio.preferences.bindings.JSSKeyStroke;
import com.jaspersoft.studio.preferences.bindings.PreferenceBindingElement;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class BindingsPreferencePersistence {
    private static final String TAG_KEY_BINDING = "keyBinding";
    private static final String TAG_BINDINGS_ROOT = "keyBindings";
    private static final String ATT_KEY_SEQUENCE = "keySequence";
    private static final String BINDING_ID = "id";
    private static HashMap<String, JSSKeySequence> bindings = null;

    public static void writeBindingsToPreferences(List<PreferenceBindingElement> elements) {
        HashMap<String, JSSKeySequence> newBindings = new HashMap<String, JSSKeySequence>();
        XMLMemento xmlMemento = XMLMemento.createWriteRoot((String)TAG_BINDINGS_ROOT);
        for (PreferenceBindingElement model : elements) {
            newBindings.put(model.getId(), model.getTrigger());
            BindingsPreferencePersistence.writeBindingToPreferences((IMemento)xmlMemento, model);
        }
        bindings = newBindings;
        IPreferenceStore preferenceStore = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        StringWriter writer = new StringWriter();
        try {
            try {
                xmlMemento.save((Writer)writer);
                preferenceStore.setValue(TAG_BINDINGS_ROOT, ((Object)writer).toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                FileUtils.closeStream((Closeable)writer);
            }
        }
        finally {
            FileUtils.closeStream((Closeable)writer);
        }
    }

    private static void writeBindingToPreferences(IMemento parent, PreferenceBindingElement binding) {
        IMemento element = parent.createChild(TAG_KEY_BINDING);
        element.putString(BINDING_ID, binding.getId());
        element.putString(ATT_KEY_SEQUENCE, binding.getTrigger().toString());
    }

    public static HashMap<String, JSSKeySequence> readBindingsFromPreferences() {
        HashMap<String, JSSKeySequence> result = new HashMap<String, JSSKeySequence>();
        IPreferenceStore preferenceStore = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        String preferenceString = preferenceStore.getString(TAG_BINDINGS_ROOT);
        XMLMemento preferenceMemento = null;
        if (preferenceString != null && preferenceString.length() > 0) {
            StringReader reader = new StringReader(preferenceString);
            try {
                try {
                    preferenceMemento = XMLMemento.createReadRoot((Reader)reader);
                    IMemento[] preferenceMementos = preferenceMemento.getChildren(TAG_BINDINGS_ROOT);
                    int preferenceMementoCount = preferenceMementos.length;
                    int i = preferenceMementoCount - 1;
                    while (i >= 0) {
                        try {
                            IMemento memento = preferenceMementos[i];
                            String id = memento.getString(BINDING_ID);
                            if (id != null) {
                                String keySequenceText = memento.getString(ATT_KEY_SEQUENCE);
                                JSSKeySequence keySequence = null;
                                keySequence = keySequenceText != null ? JSSKeySequence.getInstance(keySequenceText) : JSSKeySequence.getInstance(new JSSKeyStroke[0]);
                                result.put(id, keySequence);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JaspersoftStudioPlugin.getInstance().logError(ex);
                        }
                        --i;
                    }
                }
                catch (WorkbenchException ex) {
                    ex.printStackTrace();
                    FileUtils.closeStream((Closeable)reader);
                }
            }
            finally {
                FileUtils.closeStream((Closeable)reader);
            }
        }
        return result;
    }

    protected static HashMap<String, JSSKeySequence> getPreferenceBindings() {
        if (bindings == null) {
            bindings = BindingsPreferencePersistence.readBindingsFromPreferences();
        }
        return bindings;
    }

    public static JSSKeySequence getBinding(String actionID) {
        JSSKeySequence binding = BindingsPreferencePersistence.getPreferenceBindings().get(actionID);
        if (binding != null) {
            return binding;
        }
        BindingElement element = ExtensionManager.getContributedBindings().get(actionID);
        return element != null ? element.getDefault() : null;
    }

    public static boolean isPressed(String bindingID) {
        return BindingsPreferencePersistence.isPressed(bindingID, true);
    }

    public static boolean isPressed(String bindingID, boolean perfectMatch) {
        boolean sequenceMatched;
        JSSKeySequence keySequence = BindingsPreferencePersistence.getBinding(bindingID);
        if (keySequence == null) {
            return false;
        }
        boolean bl = sequenceMatched = keySequence.getSize() > 0;
        if (perfectMatch) {
            boolean bl2 = sequenceMatched = keySequence.getSize() == JasperReportsPlugin.getPressedKeysNumber();
        }
        if (sequenceMatched) {
            JSSKeyStroke[] jSSKeyStrokeArray = keySequence.getKeyStrokes();
            int n = jSSKeyStrokeArray.length;
            int n2 = 0;
            while (n2 < n) {
                JSSKeyStroke keyStroke = jSSKeyStrokeArray[n2];
                int key = Character.toLowerCase(keyStroke.getNaturalKey());
                if (key != 0 && !JasperReportsPlugin.isPressed((int)key)) {
                    sequenceMatched = false;
                    break;
                }
                ++n2;
            }
        }
        return sequenceMatched;
    }
}

