/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.bindings;

import com.jaspersoft.studio.preferences.bindings.JSSKeyStroke;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.util.Util;

public class JSSKeySequence
extends TriggerSequence
implements Comparable<JSSKeySequence> {
    private static final JSSKeySequence EMPTY_KEY_SEQUENCE = new JSSKeySequence(new JSSKeyStroke[0]);
    public static final String KEY_STROKE_DELIMITER = " ";
    public static final String KEY_STROKE_DELIMITERS = " \b\r\u007f\u001b\f\n\u0000\t\u000b";
    private HashSet<JSSKeyStroke> strokes = new HashSet();

    public static final JSSKeySequence getInstance() {
        return EMPTY_KEY_SEQUENCE;
    }

    public static final JSSKeySequence getInstance(JSSKeySequence keySequence, JSSKeyStroke keyStroke) {
        if (keySequence == null || keyStroke == null) {
            throw new NullPointerException();
        }
        JSSKeyStroke[] oldKeyStrokes = keySequence.getKeyStrokes();
        int oldKeyStrokeLength = oldKeyStrokes.length;
        JSSKeyStroke[] newKeyStrokes = new JSSKeyStroke[oldKeyStrokeLength + 1];
        System.arraycopy(oldKeyStrokes, 0, newKeyStrokes, 0, oldKeyStrokeLength);
        newKeyStrokes[oldKeyStrokeLength] = keyStroke;
        return new JSSKeySequence(newKeyStrokes);
    }

    public static final JSSKeySequence getInstance(JSSKeyStroke keyStroke) {
        return new JSSKeySequence(new JSSKeyStroke[]{keyStroke});
    }

    public static final JSSKeySequence getInstance(JSSKeyStroke[] keyStrokes) {
        return new JSSKeySequence(keyStrokes);
    }

    public static final JSSKeySequence getInstance(List<JSSKeyStroke> keyStrokes) {
        return new JSSKeySequence(keyStrokes.toArray(new JSSKeyStroke[keyStrokes.size()]));
    }

    public static final JSSKeySequence getInstance(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException();
        }
        ArrayList<JSSKeyStroke> keyStrokes = new ArrayList<JSSKeyStroke>();
        HashSet<JSSKeyStroke> addedStrokes = new HashSet<JSSKeyStroke>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, KEY_STROKE_DELIMITERS);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                JSSKeyStroke decodedStroke = JSSKeyStroke.getInstance(stringTokenizer.nextToken());
                if (addedStrokes.contains((Object)decodedStroke)) continue;
                addedStrokes.add(decodedStroke);
                if (decodedStroke.isModifier()) {
                    keyStrokes.add(0, decodedStroke);
                    continue;
                }
                keyStrokes.add(decodedStroke);
            }
            JSSKeyStroke[] keyStrokeArray = keyStrokes.toArray(new JSSKeyStroke[keyStrokes.size()]);
            return new JSSKeySequence(keyStrokeArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Could not construct key sequence with these key strokes: " + keyStrokes);
        }
        catch (NullPointerException nullPointerException) {
            throw new ParseException("Could not construct key sequence with these key strokes: " + keyStrokes);
        }
    }

    protected JSSKeySequence(JSSKeyStroke[] keyStrokes) {
        super((Trigger[])keyStrokes);
        JSSKeyStroke[] jSSKeyStrokeArray = keyStrokes;
        int n = keyStrokes.length;
        int n2 = 0;
        while (n2 < n) {
            JSSKeyStroke stroke = jSSKeyStrokeArray[n2];
            this.strokes.add(stroke);
            ++n2;
        }
    }

    public JSSKeyStroke[] getKeyStrokes() {
        int triggerLength = this.triggers.length;
        JSSKeyStroke[] keyStrokes = new JSSKeyStroke[triggerLength];
        System.arraycopy(this.triggers, 0, keyStrokes, 0, triggerLength);
        return keyStrokes;
    }

    public KeyStroke[] getEclipseKeyStrokes() {
        JSSKeyStroke[] strokes = this.getKeyStrokes();
        int modifier = 0;
        ArrayList<JSSKeyStroke> notModifierKeys = new ArrayList<JSSKeyStroke>();
        JSSKeyStroke[] jSSKeyStrokeArray = strokes;
        int n = strokes.length;
        int n2 = 0;
        while (n2 < n) {
            JSSKeyStroke stroke = jSSKeyStrokeArray[n2];
            if (stroke.isModifier() && stroke.getNaturalKey() != 0) {
                modifier |= stroke.getNaturalKey();
            } else {
                notModifierKeys.add(stroke);
            }
            ++n2;
        }
        ArrayList<KeyStroke> result = new ArrayList<KeyStroke>();
        for (JSSKeyStroke stroke : notModifierKeys) {
            result.add(KeyStroke.getInstance((int)modifier, (int)stroke.getNaturalKey()));
        }
        return result.toArray(new KeyStroke[result.size()]);
    }

    public TriggerSequence[] getPrefixes() {
        int numberOfPrefixes = this.triggers.length;
        TriggerSequence[] prefixes = new TriggerSequence[numberOfPrefixes];
        prefixes[0] = JSSKeySequence.getInstance();
        int i = 0;
        while (i < numberOfPrefixes - 1) {
            JSSKeyStroke[] prefixKeyStrokes = new JSSKeyStroke[i + 1];
            System.arraycopy(this.triggers, 0, prefixKeyStrokes, 0, i + 1);
            prefixes[i + 1] = JSSKeySequence.getInstance(prefixKeyStrokes);
            ++i;
        }
        return prefixes;
    }

    public String toString() {
        return this.format();
    }

    public String format() {
        StringBuffer stringBuffer = new StringBuffer();
        JSSKeyStroke[] keyStrokes = this.getKeyStrokes();
        int keyStrokesLength = keyStrokes.length;
        int i = 0;
        while (i < keyStrokesLength) {
            stringBuffer.append(keyStrokes[i].format());
            if (i + 1 < keyStrokesLength) {
                stringBuffer.append(KEY_STROKE_DELIMITER);
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    public boolean contains(JSSKeySequence sequence) {
        if (this.triggers.length > 0 && this.triggers.length >= sequence.triggers.length) {
            JSSKeyStroke[] jSSKeyStrokeArray = sequence.getKeyStrokes();
            int n = jSSKeyStrokeArray.length;
            int n2 = 0;
            while (n2 < n) {
                JSSKeyStroke stroke = jSSKeyStrokeArray[n2];
                if (!this.strokes.contains((Object)stroke)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(JSSKeySequence o) {
        return Util.compare((Comparable[])this.triggers, (Comparable[])o.triggers);
    }

    public int getSize() {
        if (this.triggers != null) {
            return this.triggers.length;
        }
        return 0;
    }

    public boolean isEqual(JSSKeySequence secondSequence) {
        if (secondSequence == null) {
            return false;
        }
        if (this.strokes.size() != secondSequence.strokes.size()) {
            return false;
        }
        for (JSSKeyStroke stroke : this.strokes) {
            if (secondSequence.strokes.contains((Object)stroke)) continue;
            return false;
        }
        return true;
    }
}

