/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class LocaleFieldEditor
extends ComboFieldEditor {
    private static String[][] locs;

    public LocaleFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, LocaleFieldEditor.getLocales(), parent);
    }

    private static String[][] getLocales() {
        if (locs == null) {
            Locale[] locales = Locale.getAvailableLocales();
            LocaleFieldEditor.sortLocalesOnToString(locales);
            locs = new String[locales.length][2];
            int i = 0;
            while (i < locs.length) {
                LocaleFieldEditor.locs[i][0] = locales[i].getDisplayName();
                LocaleFieldEditor.locs[i][1] = locales[i].toString();
                ++i;
            }
        }
        return locs;
    }

    public static void sortLocalesOnToString(Locale[] locales) {
        Comparator<Locale> localeComparator = new Comparator<Locale>(){

            @Override
            public int compare(Locale locale1, Locale locale2) {
                return locale1.getDisplayName().compareTo(locale2.getDisplayName());
            }
        };
        Arrays.sort(locales, localeComparator);
    }
}

