/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor;

import com.jaspersoft.studio.messages.Messages;
import net.sf.jasperreports.export.type.PdfPermissionsEnum;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PDFPermissionFieldEditor
extends FieldEditor {
    private Composite container;
    private Button aPrint;
    private Button mAnnot;
    private Button aAssem;
    private Button mCont;
    private Button aFillin;
    private Button aDegPrint;
    private Button aCopy;
    private Button aSRead;

    public PDFPermissionFieldEditor() {
    }

    public PDFPermissionFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.init(name, labelText);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.container.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.container = this.createEncodingGroup(parent, numColumns);
    }

    protected Composite createEncodingGroup(Composite parent, int numColumns) {
        Group container = new Group(parent, 0);
        container.setText(Messages.PDFPermissionFieldEditor_permissionsTitle);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        container.setLayoutData((Object)gridData);
        this.aPrint = new Button((Composite)container, 32);
        this.aPrint.setText(Messages.PDFPermissionFieldEditor_allowPrinting);
        this.mAnnot = new Button((Composite)container, 32);
        this.mAnnot.setText(Messages.PDFPermissionFieldEditor_allowModifyAnnotations);
        this.aAssem = new Button((Composite)container, 32);
        this.aAssem.setText(Messages.PDFPermissionFieldEditor_allowAssembly);
        this.mCont = new Button((Composite)container, 32);
        this.mCont.setText(Messages.PDFPermissionFieldEditor_allowModifyContents);
        this.aFillin = new Button((Composite)container, 32);
        this.aFillin.setText(Messages.PDFPermissionFieldEditor_allowFillIn);
        this.aDegPrint = new Button((Composite)container, 32);
        this.aDegPrint.setText(Messages.PDFPermissionFieldEditor_allowDegradedPrinting);
        this.aCopy = new Button((Composite)container, 32);
        this.aCopy.setText(Messages.PDFPermissionFieldEditor_allowCopy);
        this.aSRead = new Button((Composite)container, 32);
        this.aSRead.setText(Messages.PDFPermissionFieldEditor_allowScreenReader);
        return container;
    }

    protected void doLoad() {
        String resourcePreference = this.getStoredValue();
        this.setProperty(resourcePreference);
    }

    private void setProperty(String resourcePreference) {
        Integer ires = 0;
        try {
            if (resourcePreference != null && !resourcePreference.isEmpty()) {
                ires = new Integer(resourcePreference);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.aPrint.setSelection((ires & 0x804) == 2052);
        this.mAnnot.setSelection((ires & 0x20) != 0);
        this.aAssem.setSelection((ires & 0x400) != 0);
        this.mCont.setSelection((ires & 8) != 0);
        this.aFillin.setSelection((ires & 0x100) != 0);
        this.aDegPrint.setSelection((ires & 4) != 0);
        this.aCopy.setSelection((ires & 0x10) != 0);
        this.aSRead.setSelection((ires & 0x200) != 0);
    }

    protected void doLoadDefault() {
        this.setProperty("0");
    }

    protected String getStoredValue() {
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    private String getProperty() {
        String res = "";
        if (this.aPrint.getSelection()) {
            res = this.appendPermission(res, PdfPermissionsEnum.PRINTING.getName());
        }
        if (this.mAnnot.getSelection()) {
            res = this.appendPermission(res, PdfPermissionsEnum.MODIFY_ANNOTATIONS.getName());
        }
        if (this.aAssem.getSelection()) {
            res = this.appendPermission(res, PdfPermissionsEnum.ASSEMBLY.getName());
        }
        if (this.mCont.getSelection()) {
            res = this.appendPermission(res, PdfPermissionsEnum.MODIFY_CONTENTS.getName());
        }
        if (this.aFillin.getSelection()) {
            res = this.appendPermission(res, PdfPermissionsEnum.FILL_IN.getName());
        }
        if (this.aDegPrint.getSelection()) {
            res = this.appendPermission(res, PdfPermissionsEnum.DEGRADED_PRINTING.getName());
        }
        if (this.aCopy.getSelection()) {
            res = this.appendPermission(res, PdfPermissionsEnum.COPY.getName());
        }
        if (this.aSRead.getSelection()) {
            res = this.appendPermission(res, PdfPermissionsEnum.SCREENREADERS.getName());
        }
        return res;
    }

    private String appendPermission(String res, String value) {
        if (!res.isEmpty()) {
            res = String.valueOf(res) + "|";
        }
        res = String.valueOf(res) + value;
        return res;
    }

    protected boolean hasSameProperty(String prop) {
        String current = this.getStoredValue();
        if (prop == null) {
            return current == null || current.length() == 0;
        }
        return prop.equals(current);
    }

    protected void doStore() {
        String prop = this.getProperty();
        if (this.hasSameProperty(prop)) {
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), prop);
    }

    public int getNumberOfControls() {
        return 1;
    }
}

