/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.number;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class FloatFieldEditor
extends StringFieldEditor {
    private float minValidValue = 0.0f;
    private float maxValidValue = Float.MAX_VALUE;
    private static final int DEFAULT_TEXT_LIMIT = 10;

    protected FloatFieldEditor() {
    }

    public FloatFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, 10);
    }

    public FloatFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        this.init(name, labelText);
        this.setTextLimit(textLimit);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage(JFaceResources.getString((String)"FloatFieldEditor.errorMessage"));
        this.createControl(parent);
    }

    public void setValidRange(float min, float max) {
        this.minValidValue = min;
        this.maxValidValue = max;
        this.setErrorMessage(JFaceResources.format((String)"FloatFieldEditor.errorMessage", (Object[])new Object[]{new Float(min), new Float(max)}));
    }

    protected boolean checkState() {
        block5: {
            Text text = this.getTextControl();
            if (text == null) {
                return false;
            }
            String numberString = text.getText();
            if (numberString.isEmpty() && this.isEmptyStringAllowed()) {
                return false;
            }
            try {
                int number = Float.valueOf(numberString).intValue();
                if (!((float)number >= this.minValidValue) || !((float)number <= this.maxValidValue)) break block5;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showErrorMessage();
                return false;
            }
        }
        this.showErrorMessage();
        return false;
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            float value = this.getPreferenceStore().getFloat(this.getPreferenceName());
            text.setText("" + value);
            this.oldValue = "" + value;
        }
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            float value = this.getPreferenceStore().getDefaultFloat(this.getPreferenceName());
            text.setText("" + value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            Float i = new Float(text.getText());
            this.getPreferenceStore().setValue(this.getPreferenceName(), i.floatValue());
        }
    }

    public float getFloatValue() throws NumberFormatException {
        return new Float(this.getStringValue()).floatValue();
    }
}

