/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.properties;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.exporter.BaseResource;
import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IPropertyCustomExporter;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.messages.Messages;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.Pair;
import org.eclipse.jface.preference.IPreferenceStore;

public class ExportedJRPropertiesHandler
implements IExportedResourceHandler,
IPropertyCustomExporter {
    private static final String CONTAINER_NAME = "jrProperties";
    private static final String FILE_NAME = "backup.properties";
    private List<IResourceDefinition> cachedExportableResources = null;
    private Pair<String, List<IResourceDefinition>> cachedImportableResources = null;

    @Override
    public String getResourceNameExport() {
        try {
            IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
            Properties props = FileUtils.load((String)store.getString("net.sf.jasperreports.JRPROPERTIES"));
            return "JasperReports Properties (" + props.size() + ")";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "JasperReports Properties";
        }
    }

    @Override
    public String getResourceNameImport(File exportedContainer) {
        String result;
        block5: {
            File destDir = new File(exportedContainer, CONTAINER_NAME);
            File f = new File(destDir, FILE_NAME);
            FileInputStream is = null;
            result = "JasperReports Properties";
            try {
                try {
                    is = new FileInputStream(f);
                    Properties loadedProperties = new Properties();
                    loadedProperties.load(is);
                    result = "JasperReports Properties (" + loadedProperties.size() + ")";
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    FileUtils.closeStream((Closeable)is);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(is);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)is);
        }
        return result;
    }

    @Override
    public List<IResourceDefinition> getExportableResources() {
        if (this.cachedExportableResources == null) {
            this.cachedExportableResources = new ArrayList<IResourceDefinition>();
            try {
                IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
                Properties props = FileUtils.load((String)store.getString("net.sf.jasperreports.JRPROPERTIES"));
                for (Object key : props.keySet()) {
                    Object value = props.get(key);
                    BaseResource resource = new BaseResource(String.valueOf(key.toString()) + "=" + Misc.nvl((String)value.toString()));
                    resource.setData(key);
                    this.cachedExportableResources.add(resource);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.cachedExportableResources;
    }

    @Override
    public List<IResourceDefinition> getRestorableResources(File exportedContainer) {
        block9: {
            String containerPath = exportedContainer.getAbsolutePath();
            if (this.cachedImportableResources == null || !((String)this.cachedImportableResources.getKey()).equals(containerPath)) {
                File destDir = new File(exportedContainer, CONTAINER_NAME);
                File indexFile = new File(destDir, FILE_NAME);
                FileInputStream is = null;
                if (indexFile.exists()) {
                    try {
                        try {
                            ArrayList<BaseResource> result = new ArrayList<BaseResource>();
                            is = new FileInputStream(indexFile);
                            Properties props = new Properties();
                            props.load(is);
                            for (Object key : props.keySet()) {
                                Object value = props.get(key);
                                BaseResource resource = new BaseResource(String.valueOf(key.toString()) + "=" + Misc.nvl((String)value.toString()));
                                resource.setData(key);
                                result.add(resource);
                            }
                            this.cachedImportableResources = new Pair((Object)containerPath, result);
                        }
                        catch (Exception ex) {
                            JaspersoftStudioPlugin.getInstance().logError(ex);
                            this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                            FileUtils.closeStream((Closeable)is);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(is);
                        throw throwable;
                    }
                    FileUtils.closeStream((Closeable)is);
                } else {
                    this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                }
            }
        }
        return (List)this.cachedImportableResources.getValue();
    }

    @Override
    public File exportContentFolder(List<IResourceDefinition> resourcesToExport) {
        File destDir;
        block8: {
            FileOutputStream out = null;
            destDir = null;
            try {
                try {
                    IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
                    Properties props = FileUtils.load((String)store.getString("net.sf.jasperreports.JRPROPERTIES"));
                    HashSet<String> resourcesToExportSet = new HashSet<String>();
                    for (IResourceDefinition definition : resourcesToExport) {
                        resourcesToExportSet.add((String)definition.getData());
                    }
                    for (Object key : new ArrayList<Object>(props.keySet())) {
                        if (resourcesToExportSet.contains(key.toString())) continue;
                        props.remove(key);
                    }
                    File tempDir = new File(System.getProperty("java.io.tmpdir"));
                    tempDir.deleteOnExit();
                    destDir = new File(tempDir, CONTAINER_NAME);
                    if (destDir.exists()) {
                        FileUtils.recursiveDelete((File)destDir);
                    }
                    destDir.mkdirs();
                    out = new FileOutputStream(new File(destDir, FILE_NAME));
                    props.store(out, "JasperReports Properties Backup");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    destDir = null;
                    FileUtils.closeStream(out);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(out);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)out);
        }
        return destDir;
    }

    @Override
    public void restoreContentFolder(File exportedContainer, List<IResourceDefinition> resourcesToImport) {
        block11: {
            FileInputStream is = null;
            try {
                try {
                    HashSet<String> propertiesToImport = new HashSet<String>();
                    for (IResourceDefinition resourceToImport : resourcesToImport) {
                        propertiesToImport.add(resourceToImport.getData().toString());
                    }
                    File destDir = new File(exportedContainer, CONTAINER_NAME);
                    File f = new File(destDir, FILE_NAME);
                    is = new FileInputStream(f);
                    Properties loadedProperties = new Properties();
                    loadedProperties.load(is);
                    for (Object key : new ArrayList<Object>(loadedProperties.keySet())) {
                        if (propertiesToImport.contains(key.toString())) continue;
                        loadedProperties.remove(key);
                    }
                    boolean hasDuplicatedProperties = false;
                    IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
                    Properties oldProperties = FileUtils.load((String)store.getString("net.sf.jasperreports.JRPROPERTIES"));
                    for (Object key : loadedProperties.keySet()) {
                        if (oldProperties.getProperty(key.toString()) == null) continue;
                        hasDuplicatedProperties = true;
                        break;
                    }
                    boolean doit = true;
                    if (hasDuplicatedProperties) {
                        doit = UIUtils.showConfirmation((String)Messages.ExportedJRPropertiesHandler_duplocatedTitle, (String)Messages.ExportedJRPropertiesHandler_duplicatedMessage);
                    }
                    if (doit) {
                        for (Map.Entry<Object, Object> property : loadedProperties.entrySet()) {
                            Object key = property.getKey();
                            Object value = property.getValue();
                            oldProperties.setProperty(key.toString(), value.toString());
                        }
                        store.setValue("net.sf.jasperreports.JRPROPERTIES", FileUtils.getPropertyAsString((Properties)oldProperties));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FileUtils.closeStream(is);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(is);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)is);
        }
    }

    @Override
    public List<String> getHandledProperties() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("net.sf.jasperreports.JRPROPERTIES");
        return result;
    }
}

