/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.properties;

import com.jaspersoft.studio.preferences.editor.properties.PropertyListFieldEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SearchPropertyListFieldEditor
extends PropertyListFieldEditor {
    private String searchString = "";
    private static final String DEFAULT = "type filter text";

    public SearchPropertyListFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public Label getLabelControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(768));
        Label labelControl = super.getLabelControl(container);
        final Text searchText = new Text(container, 2048);
        searchText.setForeground(ColorConstants.gray);
        searchText.setText(DEFAULT);
        searchText.addModifyListener(e -> {
            String text2 = searchText.getText().trim();
            String oldText = this.searchString;
            this.searchString = text2.equals(DEFAULT) || text2.isEmpty() ? "" : text2;
            if (!oldText.equals(this.searchString)) {
                this.viewer.refresh();
            }
        });
        searchText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (searchText.getText().trim().isEmpty()) {
                    searchText.setText(SearchPropertyListFieldEditor.DEFAULT);
                }
            }

            public void focusGained(FocusEvent e) {
                if (searchText.getText().trim().equals(SearchPropertyListFieldEditor.DEFAULT)) {
                    searchText.setText("");
                }
            }
        });
        GridDataFactory.fillDefaults().align(0x1000008, 128).grab(true, false).hint(250, 16).applyTo((Control)searchText);
        return labelControl;
    }

    @Override
    public Table getTableControl(Composite parent) {
        Table table = super.getTableControl(parent);
        this.viewer.setContentProvider((IContentProvider)new SearchContentProvider());
        return table;
    }

    private class SearchContentProvider
    implements IStructuredContentProvider {
        private SearchContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private Object[] getSubset(Collection<?> allElements) {
            ArrayList result = new ArrayList();
            for (Object obj : allElements) {
                PropertyListFieldEditor.Pair pair = (PropertyListFieldEditor.Pair)obj;
                if (!SearchPropertyListFieldEditor.this.searchString.isEmpty() && !pair.getKey().toLowerCase().contains(SearchPropertyListFieldEditor.this.searchString.toLowerCase())) continue;
                result.add(obj);
            }
            return result.toArray();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return this.getSubset((List)inputElement);
            }
            if (inputElement instanceof Collection) {
                return this.getSubset((Collection)inputElement);
            }
            return new Object[0];
        }
    }
}

