/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.sorttable.model;

import com.jaspersoft.studio.preferences.editor.sorttable.model.TableViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableViewerSorterHandler
extends SelectionAdapter {
    private Table table;
    private TableViewerSorter sorter;

    public TableViewerSorterHandler(Table table, TableViewerSorter sorter) {
        this.table = table;
        this.sorter = sorter;
        this.registerColumns();
    }

    public void dispose() {
        this.unregisterColumns();
    }

    public void widgetSelected(SelectionEvent event) {
        int columnIndex = this.table.indexOf((TableColumn)event.widget);
        this.sort(columnIndex);
    }

    public void sort(int columnIndex) {
        this.sort(columnIndex, !this.sorter.isAscending());
    }

    public void sort(int columnIndex, boolean ascending) {
        this.sorter.setSortingColumn(columnIndex);
        this.sorter.setAscending(ascending);
        this.sorter.sort();
        TableColumn column = this.table.getColumn(columnIndex);
        this.table.setSortColumn(column);
        this.table.setSortDirection(this.sorter.isAscending() ? 128 : 1024);
    }

    private void registerColumns() {
        TableColumn[] columns = this.table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].addSelectionListener((SelectionListener)this);
            ++i;
        }
    }

    private void unregisterColumns() {
        TableColumn[] columns = this.table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].removeSelectionListener((SelectionListener)this);
            ++i;
        }
    }
}

