/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.execution;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.JSSComboFieldEditor;
import com.jaspersoft.studio.preferences.editor.LocaleFieldEditor;
import com.jaspersoft.studio.preferences.editor.TimeZoneFieldEditor;
import com.jaspersoft.studio.preferences.editor.number.SpinnerFieldEditor;
import com.jaspersoft.studio.preferences.util.FieldEditorOverlayPage;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.engine.fill.JRFileVirtualizer;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;

public class ReportExecutionPreferencePage
extends FieldEditorOverlayPage {
    public static final String JSS_VIRTUALIZER_USE = "com.jaspersoft.studio.virtualizer.use";
    public static final String JSS_VIRTUALIZER_TYPE = "com.jaspersoft.studio.virtualizer.type";
    public static final String JSS_VIRTUALIZER_MAX_SIZE = "com.jaspersoft.studio.virtualizer.maxsize";
    public static final String JSS_VIRTUALIZER_TMP = "com.jaspersoft.studio.virtualizer.tmp";
    public static final String JSS_VIRTUALIZER_BLOCK_SIZE = "com.jaspersoft.studio.virtualizer.block.size";
    public static final String JSS_VIRTUALIZER_MIN_GROW_COUNT = "com.jaspersoft.studio.virtualizer.min.grow.count";
    public static final String JSS_VIRTUALIZER_PAGE_ELEMENT_SIZE = "net.sf.jasperreports.virtual.page.element.size";
    public static final String JSS_EXECPREFIX = "com.jaspersoft.studio.execute.";
    public static final String JSS_LIMIT_RECORDS = "com.jaspersoft.studio.execute.limitrecords";
    public static final String JSS_MAX_RECORDS = "com.jaspersoft.studio.execute.REPORT_MAX_COUNT";
    public static final String JSS_IGNOREPAGINATION = "com.jaspersoft.studio.execute.IS_IGNORE_PAGINATION";
    public static final String JSS_REPORT_LOCALE = "net.sf.jasperreports.default.locale";
    public static final String JSS_REPORT_TIMEZONE = "net.sf.jasperreports.default.timezone";
    public static final String JSS_REPORT_FORCE_PARAMETER_TIMEZONE = "com.jaspersoft.studio.parameters.usetimezone";
    public static final String JSS_RUNREPORTONDACHANGE = "com.jaspersoft.studio.run.report.on.da.change";
    private BooleanFieldEditor bfeONEXIT;
    private JSSComboFieldEditor cfeType;
    private SpinnerFieldEditor msfe;
    private DirectoryFieldEditor dfeTMP;
    private BooleanFieldEditor bfeUSE;
    private SpinnerFieldEditor sfeBLOCKSIZE;
    private SpinnerFieldEditor sfeMINGROWCOUNT;
    private SpinnerFieldEditor sfePAGEELSIZE;
    private VirtualizerType vtype = VirtualizerType.FILE;
    private BooleanFieldEditor bLimRec;
    private SpinnerFieldEditor mnumrec;

    public ReportExecutionPreferencePage() {
        super(1);
        this.setPreferenceStore(JaspersoftStudioPlugin.getInstance().getPreferenceStore());
    }

    @Override
    public void createFieldEditors() {
        BooleanFieldEditor brunOnDaChange = new BooleanFieldEditor(JSS_RUNREPORTONDACHANGE, "Run report on Data Adapter change", this.getFieldEditorParent());
        brunOnDaChange.getDescriptionControl(this.getFieldEditorParent()).setToolTipText("Run report on Data Adapter change");
        this.addField((FieldEditor)brunOnDaChange);
        BooleanFieldEditor timezoneCheckBox = new BooleanFieldEditor(JSS_REPORT_FORCE_PARAMETER_TIMEZONE, "Calculate date ranges for input parameters using system time zone", this.getFieldEditorParent());
        timezoneCheckBox.getDescriptionControl(this.getFieldEditorParent()).setToolTipText("Calculates date ranges for input parameters using the system time zone. Set to false to use the time zone set in the\ufffdreport\ufffd(REPORT_TIME_ZONE).");
        this.addField((FieldEditor)timezoneCheckBox);
        this.addField((FieldEditor)new LocaleFieldEditor(JSS_REPORT_LOCALE, Messages.ReportExecutionPreferencePage_localeLabel, this.getFieldEditorParent()));
        this.addField((FieldEditor)new TimeZoneFieldEditor(JSS_REPORT_TIMEZONE, Messages.ReportExecutionPreferencePage_timeZoneLabel, this.getFieldEditorParent()));
        this.bLimRec = new BooleanFieldEditor(JSS_LIMIT_RECORDS, Messages.ReportExecutionPreferencePage_limitNumberLabel, this.getFieldEditorParent());
        this.addField((FieldEditor)this.bLimRec);
        this.mnumrec = new SpinnerFieldEditor(JSS_MAX_RECORDS, Messages.ReportExecutionPreferencePage_maxNumberLabel, this.getFieldEditorParent(), 0);
        this.mnumrec.setMinimum(-1);
        this.mnumrec.setMaximum(Integer.MAX_VALUE);
        this.mnumrec.getLabelControl(this.getFieldEditorParent()).setToolTipText(Messages.ReportExecutionPreferencePage_maxNumberTooltip);
        this.addField(this.mnumrec);
        this.addField((FieldEditor)new BooleanFieldEditor(JSS_IGNOREPAGINATION, Messages.ReportExecutionPreferencePage_ignorePaginationLabel, this.getFieldEditorParent()));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        new Label(this.getFieldEditorParent(), 258).setLayoutData((Object)gd);
        this.bfeUSE = new BooleanFieldEditor(JSS_VIRTUALIZER_USE, Messages.ReportExecutionPreferencePage_useVritualizerLabel, this.getFieldEditorParent());
        this.addField((FieldEditor)this.bfeUSE);
        this.bfeONEXIT = new BooleanFieldEditor("net.sf.jasperreports.virtualizer.files.delete.on.exit", Messages.ReportExecutionPreferencePage_deleteTempLabel, this.getFieldEditorParent());
        this.addField((FieldEditor)this.bfeONEXIT);
        this.sfePAGEELSIZE = new SpinnerFieldEditor(JSS_VIRTUALIZER_PAGE_ELEMENT_SIZE, Messages.ReportExecutionPreferencePage_pageElementSizeLabel, this.getFieldEditorParent(), 0);
        this.sfePAGEELSIZE.setMinimum(1);
        this.sfePAGEELSIZE.setMaximum(Integer.MAX_VALUE);
        this.addField(this.sfePAGEELSIZE);
        HelpSystem.setHelp((Control)this.sfePAGEELSIZE.getSpinnerControl(), "net.sf.jasperreports.doc/docs/config.reference.html?cp=0_2#" + this.sfePAGEELSIZE.getPreferenceName());
        this.cfeType = new JSSComboFieldEditor(JSS_VIRTUALIZER_TYPE, Messages.ReportExecutionPreferencePage_typeLabel, new String[][]{{Messages.ReportExecutionPreferencePage_fileVritualizerEntry, JRFileVirtualizer.class.getName()}, {Messages.ReportExecutionPreferencePage_gzipMemoryVirtualizer, JRGzipVirtualizer.class.getName()}, {Messages.ReportExecutionPreferencePage_singleSwapFileVirtualizer, JRSwapFileVirtualizer.class.getName()}}, this.getFieldEditorParent());
        this.addField(this.cfeType);
        this.msfe = new SpinnerFieldEditor(JSS_VIRTUALIZER_MAX_SIZE, Messages.ReportExecutionPreferencePage_maxSizeLabel, this.getFieldEditorParent(), 0);
        this.msfe.setMinimum(0);
        this.msfe.setMaximum(Integer.MAX_VALUE);
        this.msfe.getLabelControl(this.getFieldEditorParent()).setToolTipText(Messages.ReportExecutionPreferencePage_maximumSizeTooltip);
        this.addField(this.msfe);
        this.dfeTMP = new DirectoryFieldEditor(JSS_VIRTUALIZER_TMP, Messages.ReportExecutionPreferencePage_tempPathLabel, this.getFieldEditorParent());
        this.addField((FieldEditor)this.dfeTMP);
        this.sfeBLOCKSIZE = new SpinnerFieldEditor(JSS_VIRTUALIZER_BLOCK_SIZE, Messages.ReportExecutionPreferencePage_blockSizeLabel, this.getFieldEditorParent(), 0);
        this.sfeBLOCKSIZE.setMinimum(0);
        this.sfeBLOCKSIZE.setMaximum(Integer.MAX_VALUE);
        this.addField(this.sfeBLOCKSIZE);
        this.sfeMINGROWCOUNT = new SpinnerFieldEditor(JSS_VIRTUALIZER_MIN_GROW_COUNT, Messages.ReportExecutionPreferencePage_minGrowLabel, this.getFieldEditorParent(), 0);
        this.sfeMINGROWCOUNT.setMinimum(0);
        this.sfeMINGROWCOUNT.setMaximum(Integer.MAX_VALUE);
        this.addField(this.sfeMINGROWCOUNT);
        this.vtype = this.getVirtualizerType(this.getPreferenceStore().getString(JSS_VIRTUALIZER_TYPE));
        this.enableVirtualizers(this.getPreferenceStore().getBoolean(JSS_VIRTUALIZER_USE));
        this.enableLimitRecords(this.getPreferenceStore().getBoolean(JSS_LIMIT_RECORDS));
        this.enableSwapVirtualizer(this.vtype.equals((Object)VirtualizerType.SWAP));
        super.createFieldEditors();
    }

    private VirtualizerType getVirtualizerType(String type) {
        if (type.equals(JRFileVirtualizer.class.getName())) {
            return VirtualizerType.FILE;
        }
        if (type.equals(JRSwapFileVirtualizer.class.getName())) {
            return VirtualizerType.SWAP;
        }
        return VirtualizerType.ZIP;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value")) {
            if (event.getSource() == this.bfeUSE) {
                this.enableVirtualizers((Boolean)event.getNewValue());
            } else if (event.getSource() == this.cfeType) {
                this.vtype = this.getVirtualizerType((String)event.getNewValue());
                this.enableSwapVirtualizer(this.vtype.equals((Object)VirtualizerType.SWAP));
            } else if (event.getSource() == this.mnumrec) {
                this.enableLimitRecords((Integer)event.getNewValue() >= 0);
            } else if (event.getSource() == this.bLimRec) {
                this.enableLimitRecords((Boolean)event.getNewValue());
            }
        }
    }

    private void enableLimitRecords(boolean newVal) {
        this.mnumrec.setEnabled(newVal, this.getFieldEditorParent());
    }

    private void enableSwapVirtualizer(boolean isSwap) {
        this.bfeONEXIT.setEnabled(this.vtype.equals((Object)VirtualizerType.FILE), this.getFieldEditorParent());
        this.dfeTMP.setEnabled(isSwap || this.vtype.equals((Object)VirtualizerType.FILE), this.getFieldEditorParent());
        this.sfeBLOCKSIZE.setEnabled(isSwap, this.getFieldEditorParent());
        this.sfeMINGROWCOUNT.setEnabled(isSwap, this.getFieldEditorParent());
    }

    private void enableVirtualizers(boolean newVal) {
        this.bfeONEXIT.setEnabled(newVal && this.vtype.equals((Object)VirtualizerType.FILE), this.getFieldEditorParent());
        this.cfeType.setEnabled(newVal, this.getFieldEditorParent());
        this.msfe.setEnabled(newVal, this.getFieldEditorParent());
        this.enableSwapVirtualizer(newVal && this.vtype.equals((Object)VirtualizerType.SWAP));
        this.sfePAGEELSIZE.setEnabled(newVal, this.getFieldEditorParent());
    }

    public void init(IWorkbench workbench) {
    }

    public static void getDefaults(IPreferenceStore store) {
        store.setDefault("net.sf.jasperreports.virtualizer.files.delete.on.exit", "true");
        store.setDefault(JSS_VIRTUALIZER_USE, "false");
        store.setDefault(JSS_VIRTUALIZER_TYPE, JRFileVirtualizer.class.getName());
        store.setDefault(JSS_VIRTUALIZER_MAX_SIZE, 100);
        store.setDefault(JSS_VIRTUALIZER_TMP, "");
        store.setDefault(JSS_VIRTUALIZER_BLOCK_SIZE, 100);
        store.setDefault(JSS_VIRTUALIZER_MIN_GROW_COUNT, 100);
        store.setDefault(JSS_VIRTUALIZER_PAGE_ELEMENT_SIZE, 1);
        store.setDefault("net.sf.jasperreports.virtualizer.files.delete.on.exit", "false");
        store.setDefault(JSS_LIMIT_RECORDS, "false");
        store.setDefault(JSS_MAX_RECORDS, -1);
        store.setDefault(JSS_IGNOREPAGINATION, "false");
        store.setDefault(JSS_REPORT_LOCALE, Locale.getDefault().toString());
        store.setDefault(JSS_REPORT_TIMEZONE, TimeZone.getDefault().getID());
        store.setDefault(JSS_REPORT_FORCE_PARAMETER_TIMEZONE, false);
        store.setDefault(JSS_RUNREPORTONDACHANGE, "true");
    }

    public String getPageId() {
        return "com.jaspersoft.studio.preferences.execution.ReportExecutionPreferencePage.property";
    }

    static enum VirtualizerType {
        SWAP,
        FILE,
        ZIP;

    }
}

