/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.execution;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.util.Map;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRFileVirtualizer;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;

public class VirtualizerHelper {
    public static void setVirtualizer(JasperDesign jd, JasperReportsConfiguration jContext, Map<String, Object> parammap) {
        if (jContext.getPropertyBoolean("com.jaspersoft.studio.virtualizer.use", false).booleanValue()) {
            parammap.put("REPORT_VIRTUALIZER", VirtualizerHelper.createVirtualizer(jContext));
        }
    }

    private static JRVirtualizer createVirtualizer(JasperReportsConfiguration jContext) {
        JRFileVirtualizer v = null;
        String vtype = jContext.getProperty("com.jaspersoft.studio.virtualizer.type", JRFileVirtualizer.class.getName());
        int maxSize = jContext.getPropertyInteger("com.jaspersoft.studio.virtualizer.maxsize", 100);
        if (vtype.equals(JRFileVirtualizer.class.getName())) {
            v = new JRFileVirtualizer((JasperReportsContext)jContext, maxSize, VirtualizerHelper.getDirectory(jContext));
        } else if (vtype.equals(JRGzipVirtualizer.class.getName())) {
            v = new JRGzipVirtualizer(maxSize);
        } else if (vtype.equals(JRSwapFileVirtualizer.class.getName())) {
            int blockSize = jContext.getPropertyInteger("com.jaspersoft.studio.virtualizer.block.size", 100);
            int minGrowCount = jContext.getPropertyInteger("com.jaspersoft.studio.virtualizer.min.grow.count", 100);
            v = new JRSwapFileVirtualizer(maxSize, new JRSwapFile(VirtualizerHelper.getDirectory(jContext), blockSize, minGrowCount), false);
        }
        return v;
    }

    private static String getDirectory(JasperReportsConfiguration jContext) {
        File f;
        String directory = jContext.getProperty("com.jaspersoft.studio.virtualizer.tmp");
        if (directory != null && !directory.trim().equals("") && !(f = new File(directory)).exists()) {
            directory = null;
        }
        if (directory == null || directory.trim().equals("")) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            directory = workspace.getRoot().getLocation().toOSString();
        }
        return directory;
    }
}

